/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.restartrealbill.validators;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.constants.FaChangeItem;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.restartrealbill.utils.CommonCheckUtils;

public class FaReStartRealBillSubmitValidator
extends AbstractValidator {
    private static final String A_LGO_KEY = "kd.fi.fa.opplugin.restartrealbill.validators.FaReStartRealBillSubmitValidator";

    public void validate() {
        HashMap<Long, List<DynamicObject>> orgId2AllClearReStartDynObjListMap = new HashMap<Long, List<DynamicObject>>(16);
        HashMap<Long, DynamicObject> orgId2MainBookMap = new HashMap<Long, DynamicObject>(10);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject reStartRealBill = dataEntity.getDataEntity();
            DynamicObject orgDynObj = reStartRealBill.getDynamicObject("org");
            Long orgId = orgDynObj.getLong("id");
            String orgName = orgDynObj.getString("name");
            String reStartRealBillNo = reStartRealBill.getString("billno");
            Date reStartDate = reStartRealBill.getDate("restartdate");
            DynamicObjectCollection reStartEntity = reStartRealBill.getDynamicObjectCollection("restartentity");
            Set<Object> realCardMasterIds = reStartEntity.stream().map(dynObj -> dynObj.getLong(Fa.id((String)"realcard"))).collect(Collectors.toSet());
            this.checkFutureBiz(orgId, reStartDate, realCardMasterIds, dataEntity);
            DynamicObject mainAssetBookDynObj = (DynamicObject)orgId2MainBookMap.get(orgId);
            if (Objects.isNull(mainAssetBookDynObj) && Objects.nonNull(mainAssetBookDynObj = FaBizUtils.getAsstBookByOrg((Long)orgId, (String)Fa.comma((String[])new String[]{"depreuse", "periodtype"})))) {
                orgId2MainBookMap.put(orgId, mainAssetBookDynObj);
            }
            if (Objects.isNull(mainAssetBookDynObj)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"FaReStartRealBillSubmitValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), orgName));
            }
            long periodTypeId = mainAssetBookDynObj.getLong("periodtype");
            DynamicObject reStartPeriod = PeriodUtil.getPeriodFullObjByDate((Date)reStartDate, (long)periodTypeId);
            Long reStartPeriodId = reStartPeriod.getLong("id");
            long depUseId = mainAssetBookDynObj.getLong("depreuse");
            this.checkDepAdjust(orgId, depUseId, reStartPeriodId, realCardMasterIds, dataEntity);
            this.checkClearBill(orgId, reStartPeriodId, realCardMasterIds, dataEntity);
            ArrayList<DynamicObject> allClearReStartDynObjList = new ArrayList<DynamicObject>(reStartEntity.size());
            HashMap<Long, String> partClearRealCardId2NumberMap = new HashMap<Long, String>(16);
            HashMap<Long, Date> partClearRealCardId2BizDateMap = new HashMap<Long, Date>(16);
            for (DynamicObject entityDynObj : reStartEntity) {
                String reStartType = entityDynObj.getString("restarttype");
                if ("1".equals(reStartType)) {
                    allClearReStartDynObjList.add(entityDynObj);
                    continue;
                }
                DynamicObject realCardDyn = entityDynObj.getDynamicObject("realcard");
                Long realCardId = Long.parseLong(realCardDyn.getPkValue().toString());
                String realCardAssetNumber = realCardDyn.getString("number");
                partClearRealCardId2NumberMap.put(realCardId, realCardAssetNumber);
                Date partClearBizDate = entityDynObj.getDynamicObject("clearbilldetailid").getDate("bizdate");
                Date date = (Date)partClearRealCardId2BizDateMap.get(realCardId);
                if (Objects.isNull(date)) {
                    partClearRealCardId2BizDateMap.put(realCardId, partClearBizDate);
                    continue;
                }
                if (date.compareTo(partClearBizDate) <= 0) continue;
                partClearRealCardId2BizDateMap.put(realCardId, partClearBizDate);
            }
            String checkResult = CommonCheckUtils.checkDepSum(orgId, reStartRealBillNo, reStartDate);
            if (checkResult != null) {
                this.addErrorMessage(dataEntity, checkResult);
            }
            this.checkOtherBiz(partClearRealCardId2NumberMap, partClearRealCardId2BizDateMap, reStartRealBill, dataEntity);
            if (allClearReStartDynObjList.size() <= 0) continue;
            List isAllClearReStartDynObjList = (List)orgId2AllClearReStartDynObjListMap.get(orgId);
            if (Objects.isNull(isAllClearReStartDynObjList)) {
                orgId2AllClearReStartDynObjListMap.put(orgId, allClearReStartDynObjList);
                continue;
            }
            isAllClearReStartDynObjList.addAll(allClearReStartDynObjList);
        }
        this.checkNumberRepeat(orgId2AllClearReStartDynObjListMap);
    }

    private void checkOtherBiz(Map<Long, String> partClearRealCardId2NumberMap, Map<Long, Date> partClearRealCardId2BizDateMap, DynamicObject reStartRealBill, ExtendedDataEntity dataEntity) {
        if (Objects.isNull(partClearRealCardId2NumberMap) || partClearRealCardId2NumberMap.isEmpty()) {
            return;
        }
        Date reStartDate = reStartRealBill.getDate("restartdate");
        String realCardIdField = Fa.dot((String[])new String[]{"entryentity", "realcardmasterid"});
        DynamicObjectCollection reStartEntity = reStartRealBill.getDynamicObjectCollection("restartentity");
        HashSet<Long> reStartEntityClearBillIdSet = new HashSet<Long>(reStartEntity.size());
        for (DynamicObject dynObj : reStartEntity) {
            Long reStartEntityClearBillId = (Long)dynObj.getDynamicObject("clearbillid").getPkValue();
            reStartEntityClearBillIdSet.add(reStartEntityClearBillId);
        }
        partClearRealCardId2BizDateMap.forEach((partClearRealCardId, bizDate) -> {
            Map<String, Map<Long, String>> billEntityName2BillIdBillNoMap = this.getBusyChgRecord(reStartDate, realCardIdField, (Long)partClearRealCardId, DateUtil.getDateFormat((Date)bizDate, (boolean)Boolean.FALSE));
            if (billEntityName2BillIdBillNoMap.isEmpty()) {
                return;
            }
            HashSet billSet = new HashSet(billEntityName2BillIdBillNoMap.size());
            billEntityName2BillIdBillNoMap.forEach((billEntityName, billId2BillNoMap) -> {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billEntityName);
                LocaleString displayName = dataEntityType.getDisplayName();
                Set<Long> billIdSet = billId2BillNoMap.keySet();
                if ("fa_change_dept".equals(billEntityName)) {
                    Set<String> existsEffectDepChangeBillNo = this.getExistsEffectDepChangeBillNo(billIdSet);
                    if (existsEffectDepChangeBillNo.size() > 0) {
                        String allBillNo = String.join((CharSequence)"\uff0c", existsEffectDepChangeBillNo);
                        billSet.add(displayName.getLocaleValue() + ":" + allBillNo);
                    }
                } else if ("fa_clearbill".equals(billEntityName)) {
                    billIdSet.removeAll(reStartEntityClearBillIdSet);
                    HashSet<String> clearBillNoSet = new HashSet<String>(billIdSet.size());
                    for (Long clearBillId : billIdSet) {
                        String clearBillNo = this.getClearBillNo((Map<Long, String>)billId2BillNoMap, clearBillId);
                        clearBillNoSet.add(clearBillNo);
                    }
                    if (clearBillNoSet.size() > 0) {
                        String allBillNo = String.join((CharSequence)"\uff0c", clearBillNoSet);
                        billSet.add(displayName.getLocaleValue() + ":" + (String)allBillNo);
                    }
                } else {
                    String allBillNo = String.join((CharSequence)"\uff0c", billId2BillNoMap.values());
                    billSet.add(displayName.getLocaleValue() + ":" + allBillNo);
                }
            });
            if (billSet.size() > 0) {
                String number = (String)partClearRealCardId2NumberMap.get(partClearRealCardId);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%1$s\uff0c\u90e8\u5206\u6e05\u7406\u548c\u91cd\u542f\u4e4b\u95f4\u5b58\u5728\u5982\u4e0b\u4e1a\u52a1\u5355\u636e\uff1a%2$s\uff0c\u91cd\u542f\u5931\u8d25\u3002", (String)"FaReStartRealBillSubmitValidator_14", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, billSet);
                this.addErrorMessage(dataEntity, errorMsg);
            }
        });
    }

    private String getClearBillNo(Map<Long, String> billId2BillNoMap, Long clearBillId) {
        for (Map.Entry<Long, String> map : billId2BillNoMap.entrySet()) {
            if (!Objects.equals(clearBillId, map.getKey())) continue;
            return map.getValue();
        }
        return null;
    }

    private Set<String> getExistsEffectDepChangeBillNo(Set<Long> changeBillIdSet) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
        QFilter idFilter = new QFilter("id", "in", changeBillIdSet);
        List sysInitDepreItem = FaChangeItem.SYS_INIT_DEPRE_ITEM;
        QFilter fieldFilter = new QFilter(Fa.dot((String[])new String[]{"fieldentry", "field"}), "in", (Object)sysInitDepreItem);
        qFilterList.add(idFilter);
        qFilterList.add(fieldFilter);
        DynamicObjectCollection dynObjCollection = QueryServiceHelper.query((String)"fa_change_dept", (String)"billno", (QFilter[])qFilterList.toArray(new QFilter[0]));
        HashSet<String> billNoSet = new HashSet<String>(dynObjCollection.size());
        if (dynObjCollection.size() > 0) {
            for (DynamicObject dynObj : dynObjCollection) {
                billNoSet.add(dynObj.getString("billno"));
            }
        }
        return billNoSet;
    }

    private Map<String, Map<Long, String>> getBusyChgRecord(Date reStartDate, String realCardIdField, Long partClearRealCardId, Date bizDate) {
        QFilter[] filters = new QFilter[]{new QFilter(realCardIdField, "=", (Object)partClearRealCardId), new QFilter("busydate", ">", (Object)bizDate), new QFilter("busydate", "<", (Object)reStartDate), new QFilter("isdelete", "=", (Object)Boolean.FALSE)};
        String selectFields = Fa.comma((String[])new String[]{"billentityname", "billid", "billno"});
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fa_busy_chg_record", (String)selectFields, (QFilter[])filters);
        HashMap<String, Map<Long, String>> result = new HashMap<String, Map<Long, String>>(dynamicObjectCollection.size());
        for (DynamicObject dynObj : dynamicObjectCollection) {
            String billEntityName = dynObj.getString("billentityname");
            HashMap<Long, String> billId2BillNoMap = (HashMap<Long, String>)result.get(billEntityName);
            if (Objects.isNull(billId2BillNoMap)) {
                billId2BillNoMap = new HashMap<Long, String>(16);
                result.put(billEntityName, billId2BillNoMap);
            }
            billId2BillNoMap.put(dynObj.getLong("billid"), dynObj.getString("billno"));
        }
        return result;
    }

    private void checkAftPartClearReStartBiz(DynamicObject faReStartRealBill, DynamicObject reStartPeriod, long periodTypeId, Long orgId, List<DynamicObject> partClearReStartDynObjList, ExtendedDataEntity dataEntity) {
        if (Objects.isNull(partClearReStartDynObjList) || partClearReStartDynObjList.isEmpty()) {
            return;
        }
        int containerInitCnt = partClearReStartDynObjList.size();
        HashMap<Long, Set<Long>> clearBillClearPeriodId2RealCardIdSetMap = new HashMap<Long, Set<Long>>(containerInitCnt);
        HashMap<Long, DynamicObject> clearBillClearPeriodId2PeriodDynObjMap = new HashMap<Long, DynamicObject>(containerInitCnt);
        HashSet<Long> partClearBillIdSet = new HashSet<Long>(containerInitCnt);
        for (DynamicObject dynObj : partClearReStartDynObjList) {
            partClearBillIdSet.add(dynObj.getLong(Fa.id((String)"clearbillid")));
            DynamicObject realCardDynObj = dynObj.getDynamicObject("realcard");
            long realCardId = realCardDynObj.getLong("id");
            Date clearBillClearDate = dynObj.getDate("clearbillid.cleardate");
            DynamicObject period = PeriodUtil.getPeriodFullObjByDate((Date)clearBillClearDate, (long)periodTypeId);
            long periodId = period.getLong("id");
            clearBillClearPeriodId2PeriodDynObjMap.put(periodId, period);
            HashSet<Long> realCardIdSet = (HashSet<Long>)clearBillClearPeriodId2RealCardIdSetMap.get(periodId);
            if (Objects.isNull(realCardIdSet)) {
                realCardIdSet = new HashSet<Long>(16);
                realCardIdSet.add(realCardId);
                clearBillClearPeriodId2RealCardIdSetMap.put(periodId, realCardIdSet);
                continue;
            }
            realCardIdSet.add(realCardId);
        }
        String reStartRealBillNo = faReStartRealBill.getString("billno");
        this.checkBill(reStartRealBillNo, orgId, reStartPeriod, partClearBillIdSet, clearBillClearPeriodId2RealCardIdSetMap, clearBillClearPeriodId2PeriodDynObjMap, dataEntity);
    }

    private void checkBill(String reStartRealBillNo, Long orgId, DynamicObject reStartPeriod, Set<Long> partClearBillIdSet, Map<Long, Set<Long>> clearBillClearPeriodId2RealCardIdSetMap, Map<Long, DynamicObject> clearBillClearPeriodId2PeriodDynObjMap, ExtendedDataEntity dataEntity) {
        if (Objects.isNull(clearBillClearPeriodId2RealCardIdSetMap) || clearBillClearPeriodId2RealCardIdSetMap.isEmpty()) {
            return;
        }
        Date reStartLastDate = reStartPeriod.getDate("enddate");
        long reStartPeriodId = reStartPeriod.getLong("id");
        Set<Map.Entry<Long, Set<Long>>> entries = clearBillClearPeriodId2RealCardIdSetMap.entrySet();
        HashSet<String> existChangeBillNoSet = new HashSet<String>(16);
        HashSet<String> existClearBillNoSet = new HashSet<String>(16);
        HashSet<String> existSplitBillNoSet = new HashSet<String>(16);
        HashSet<String> existMergeBillNoSet = new HashSet<String>(16);
        HashSet<String> existDevalueBillNoSet = new HashSet<String>(16);
        HashSet<String> existDispatchBillNoSet = new HashSet<String>(16);
        HashSet<String> existReStartBillNoSet = new HashSet<String>(16);
        for (Map.Entry<Long, Set<Long>> map : entries) {
            Long clearBillClearPeriodId = map.getKey();
            DynamicObject period = clearBillClearPeriodId2PeriodDynObjMap.get(clearBillClearPeriodId);
            Date beginDate = period.getDate("begindate");
            Set<Long> realCardIdSet = map.getValue();
            existChangeBillNoSet.addAll(this.checkChangeBill(orgId, reStartLastDate, beginDate, realCardIdSet));
            existClearBillNoSet.addAll(this.checkClearBill(orgId, reStartLastDate, beginDate, realCardIdSet, partClearBillIdSet));
            existSplitBillNoSet.addAll(this.checkSplitBill(orgId, reStartLastDate, beginDate, realCardIdSet));
            existMergeBillNoSet.addAll(this.checkMergeBill(orgId, reStartLastDate, beginDate, realCardIdSet));
            existDevalueBillNoSet.addAll(this.checkDevalueBill(orgId, reStartPeriodId, clearBillClearPeriodId, realCardIdSet));
            existDispatchBillNoSet.addAll(this.checkDispatchBill(orgId, reStartLastDate, beginDate, realCardIdSet));
            existReStartBillNoSet.addAll(this.checkReStartBill(reStartRealBillNo, orgId, reStartLastDate, beginDate, realCardIdSet));
        }
        String errorBillNoMsg = this.getAllErrorBillNoMsg(existChangeBillNoSet, existClearBillNoSet, existSplitBillNoSet, existMergeBillNoSet, existDevalueBillNoSet, existDispatchBillNoSet, existReStartBillNoSet);
        if (Objects.nonNull(errorBillNoMsg)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u91cd\u542f\u5355\u5355\u636e\uff1a%1$s\uff0c\u91cd\u542f\u5931\u8d25\uff0c\u5b58\u5728\u5176\u4ed6\u4e1a\u52a1\u5355\u636e\uff1a%2$s\u3002", (String)"FaReStartRealBillSubmitValidator_12", (String)"fi-fa-opplugin", (Object[])new Object[0]), reStartRealBillNo, errorBillNoMsg);
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    private String getAllErrorBillNoMsg(Set<String> existChangeBillNoSet, Set<String> existClearBillNoSet, Set<String> existSplitBillNoSet, Set<String> existMergeBillNoSet, Set<String> existDevalueBillNoSet, Set<String> existDispatchBillNoSet, Set<String> existReStartBillNoSet) {
        HashSet<String> errorBillNoSet = new HashSet<String>(16);
        if (existChangeBillNoSet.size() > 0) {
            String changeBillNos = String.join((CharSequence)"\uff0c", existChangeBillNoSet);
            errorBillNoSet.add(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u5355\u636e\uff1a%s", (String)"FaReStartRealBillSubmitValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), changeBillNos));
        }
        if (existClearBillNoSet.size() > 0) {
            String clearBillNos = String.join((CharSequence)"\uff0c", existClearBillNoSet);
            errorBillNoSet.add(String.format(ResManager.loadKDString((String)"\u6e05\u7406\u5355\u5355\u636e\uff1a%s", (String)"FaReStartRealBillSubmitValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), clearBillNos));
        }
        if (existSplitBillNoSet.size() > 0) {
            String splitBillNos = String.join((CharSequence)"\uff0c", existSplitBillNoSet);
            errorBillNoSet.add(String.format(ResManager.loadKDString((String)"\u62c6\u5206\u5355\u5355\u636e\uff1a%s", (String)"FaReStartRealBillSubmitValidator_7", (String)"fi-fa-opplugin", (Object[])new Object[0]), splitBillNos));
        }
        if (existMergeBillNoSet.size() > 0) {
            String mergeBillNos = String.join((CharSequence)"\uff0c", existMergeBillNoSet);
            errorBillNoSet.add(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u5355\u5355\u636e\uff1a%s", (String)"FaReStartRealBillSubmitValidator_8", (String)"fi-fa-opplugin", (Object[])new Object[0]), mergeBillNos));
        }
        if (existDevalueBillNoSet.size() > 0) {
            String devalueBillNos = String.join((CharSequence)"\uff0c", existDevalueBillNoSet);
            errorBillNoSet.add(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u5355\u5355\u636e\uff1a%s", (String)"FaReStartRealBillSubmitValidator_9", (String)"fi-fa-opplugin", (Object[])new Object[0]), devalueBillNos));
        }
        if (existDispatchBillNoSet.size() > 0) {
            String dispatchBillNos = String.join((CharSequence)"\uff0c", existDispatchBillNoSet);
            errorBillNoSet.add(String.format(ResManager.loadKDString((String)"\u8c03\u62e8\u5355\u5355\u636e\uff1a%s", (String)"FaReStartRealBillSubmitValidator_10", (String)"fi-fa-opplugin", (Object[])new Object[0]), dispatchBillNos));
        }
        if (existReStartBillNoSet.size() > 0) {
            String reStartBillNos = String.join((CharSequence)"\uff0c", existReStartBillNoSet);
            errorBillNoSet.add(String.format(ResManager.loadKDString((String)"\u91cd\u542f\u5355\u5355\u636e\uff1a%s", (String)"FaReStartRealBillSubmitValidator_11", (String)"fi-fa-opplugin", (Object[])new Object[0]), reStartBillNos));
        }
        if (errorBillNoSet.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)"\uff1b", errorBillNoSet);
    }

    private Set<String> checkReStartBill(String reStartRealBillNo, Long orgId, Date reStartLastDate, Date beginDate, Set<Long> realCardIdSet) {
        if (Objects.isNull(realCardIdSet) || realCardIdSet.isEmpty()) {
            return new HashSet<String>(1);
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(5);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter billNoFilter = new QFilter("billno", "!=", (Object)reStartRealBillNo);
        QFilter realFilter = new QFilter(Fa.dot((String[])new String[]{"restartentity", "realcard"}), "in", realCardIdSet);
        QFilter largeDateFilter = new QFilter("restartdate", ">=", (Object)beginDate);
        QFilter lessDateFilter = new QFilter("restartdate", "<=", (Object)reStartLastDate);
        qFilterList.add(orgFilter);
        qFilterList.add(billNoFilter);
        qFilterList.add(realFilter);
        qFilterList.add(largeDateFilter);
        qFilterList.add(lessDateFilter);
        return this.getCheckResultBillNoSet("fa_restartrealbill", qFilterList);
    }

    private Set<String> checkDispatchBill(Long orgId, Date reStartLastDate, Date beginDate, Set<Long> realCardIdSet) {
        if (Objects.isNull(realCardIdSet) || realCardIdSet.isEmpty()) {
            return new HashSet<String>(1);
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter realFilter = new QFilter(Fa.dot((String[])new String[]{"dispatchentry", "realcard"}), "in", realCardIdSet);
        QFilter largeDateFilter = new QFilter("dispatchdate", ">=", (Object)beginDate);
        QFilter lessDateFilter = new QFilter("dispatchdate", "<=", (Object)reStartLastDate);
        qFilterList.add(orgFilter);
        qFilterList.add(realFilter);
        qFilterList.add(largeDateFilter);
        qFilterList.add(lessDateFilter);
        return this.getCheckResultBillNoSet("fa_dispatch", qFilterList);
    }

    private Set<String> checkDevalueBill(Long orgId, long reStartPeriodId, long clearBillClearPeriodId, Set<Long> realCardIdSet) {
        if (Objects.isNull(realCardIdSet) || realCardIdSet.isEmpty()) {
            return new HashSet<String>(1);
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter realFilter = new QFilter("changebillentry.realcard", "in", realCardIdSet);
        QFilter largeDateFilter = new QFilter("devalueperiod", ">=", (Object)clearBillClearPeriodId);
        QFilter lessDateFilter = new QFilter("devalueperiod", "<=", (Object)reStartPeriodId);
        qFilterList.add(orgFilter);
        qFilterList.add(realFilter);
        qFilterList.add(largeDateFilter);
        qFilterList.add(lessDateFilter);
        return this.getCheckResultBillNoSet("fa_asset_devalue", qFilterList);
    }

    private Set<String> checkMergeBill(Long orgId, Date reStartLastDate, Date beginDate, Set<Long> realCardIdSet) {
        if (Objects.isNull(realCardIdSet) || realCardIdSet.isEmpty()) {
            return new HashSet<String>(1);
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter realFilter = new QFilter(Fa.dot((String[])new String[]{"inentryentity", "outentryentity", "OUTREALCARDMASTERID"}), "in", realCardIdSet);
        QFilter largeDateFilter = new QFilter("mergedate", ">=", (Object)beginDate);
        QFilter lessDateFilter = new QFilter("mergedate", "<=", (Object)reStartLastDate);
        qFilterList.add(orgFilter);
        qFilterList.add(realFilter);
        qFilterList.add(largeDateFilter);
        qFilterList.add(lessDateFilter);
        return this.getCheckResultBillNoSet("fa_mergebill", qFilterList);
    }

    private Set<String> checkSplitBill(Long orgId, Date reStartLastDate, Date beginDate, Set<Long> realCardIdSet) {
        if (Objects.isNull(realCardIdSet) || realCardIdSet.isEmpty()) {
            return new HashSet<String>(1);
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter realFilter = new QFilter(Fa.dot((String[])new String[]{"realcard", "masterid"}), "in", realCardIdSet);
        QFilter largeDateFilter = new QFilter("splitdate", ">=", (Object)beginDate);
        QFilter lessDateFilter = new QFilter("splitdate", "<=", (Object)reStartLastDate);
        qFilterList.add(orgFilter);
        qFilterList.add(realFilter);
        qFilterList.add(largeDateFilter);
        qFilterList.add(lessDateFilter);
        return this.getCheckResultBillNoSet("fa_assetsplitbill", qFilterList);
    }

    private Set<String> checkClearBill(Long orgId, Date reStartLastDate, Date beginDate, Set<Long> realCardIdSet, Set<Long> partClearBillIdSet) {
        if (Objects.isNull(realCardIdSet) || realCardIdSet.isEmpty()) {
            return new HashSet<String>(1);
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(5);
        QFilter idFilter = new QFilter("id", "not in", partClearBillIdSet);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter realFilter = new QFilter(Fa.dot((String[])new String[]{"detail_entry", "realcardmasterid"}), "in", realCardIdSet);
        QFilter largeDateFilter = new QFilter("cleardate", ">=", (Object)beginDate);
        QFilter lessDateFilter = new QFilter("cleardate", "<=", (Object)reStartLastDate);
        qFilterList.add(idFilter);
        qFilterList.add(orgFilter);
        qFilterList.add(realFilter);
        qFilterList.add(largeDateFilter);
        qFilterList.add(lessDateFilter);
        return this.getCheckResultBillNoSet("fa_clearbill", qFilterList);
    }

    private Set<String> checkChangeBill(Long orgId, Date reStartLastDate, Date beginDate, Set<Long> realCardIdSet) {
        if (Objects.isNull(realCardIdSet) || realCardIdSet.isEmpty()) {
            return new HashSet<String>(1);
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(5);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter realFilter = new QFilter(Fa.dot((String[])new String[]{"fieldentry", "realcard1"}), "in", realCardIdSet);
        QFilter fieldFilter = new QFilter(Fa.dot((String[])new String[]{"fieldentry", "field"}), "in", (Object)FaChangeItem.SYS_INIT_DEPRE_ITEM);
        QFilter largeDateFilter = new QFilter("changedate", ">=", (Object)beginDate);
        QFilter lessDateFilter = new QFilter("changedate", "<=", (Object)reStartLastDate);
        qFilterList.add(orgFilter);
        qFilterList.add(realFilter);
        qFilterList.add(fieldFilter);
        qFilterList.add(largeDateFilter);
        qFilterList.add(lessDateFilter);
        return this.getCheckResultBillNoSet("fa_change_dept", qFilterList);
    }

    private Set<String> getCheckResultBillNoSet(String entityName, List<QFilter> qFilterList) {
        String selectFields = "billno";
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)A_LGO_KEY, (String)entityName, (String)selectFields, (QFilter[])qFilterList.toArray(new QFilter[0]), null);
        if (Objects.isNull(dynamicObjectCollection) || dynamicObjectCollection.isEmpty()) {
            return new HashSet<String>(1);
        }
        return dynamicObjectCollection.stream().map(dynObj -> dynObj.getString("billno")).collect(Collectors.toSet());
    }

    private void checkClearBill(Long orgId, Long reStartPeriodId, Set<Object> realCardIds, ExtendedDataEntity dataEntity) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
        qFilterList.add(new QFilter("clearperiod", "=", (Object)reStartPeriodId));
        qFilterList.add(new QFilter("org", "=", (Object)orgId));
        qFilterList.add(new QFilter(Fa.dot((String[])new String[]{"detail_entry", "realcardmasterid"}), "in", realCardIds));
        String realCardNumber = Fa.dot((String[])new String[]{"detail_entry", "realcard", "number"});
        DynamicObjectCollection dynObjCollection = QueryServiceHelper.query((String)A_LGO_KEY, (String)"fa_clearbill", (String)realCardNumber, (QFilter[])qFilterList.toArray(new QFilter[0]), null);
        if (Objects.isNull(dynObjCollection) || dynObjCollection.isEmpty()) {
            return;
        }
        Set realCardNumberSet = dynObjCollection.stream().map(dynObj -> dynObj.getString(realCardNumber)).collect(Collectors.toSet());
        String errorMsg = String.join((CharSequence)"\uff0c", realCardNumberSet);
        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%s\u5f53\u671f\u505a\u8fc7\u6e05\u7406\u4e0d\u5141\u8bb8\u91cd\u542f\u3002", (String)"FaReStartRealBillSubmitValidator_13", (String)"fi-fa-opplugin", (Object[])new Object[0]), errorMsg));
    }

    private void checkDepAdjust(Long orgId, long depUseId, Long reStartPeriodId, Set<Object> realCardIds, ExtendedDataEntity dataEntity) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        qFilterList.add(new QFilter("depreuse", "=", (Object)depUseId));
        qFilterList.add(new QFilter("period", "=", (Object)reStartPeriodId));
        qFilterList.add(new QFilter("org", "=", (Object)orgId));
        qFilterList.add(new QFilter(Fa.dot((String[])new String[]{"entryentity", "realcard"}), "in", realCardIds));
        String realCardNumber = Fa.dot((String[])new String[]{"entryentity", "realcard", "number"});
        DynamicObjectCollection dynObjCollection = QueryServiceHelper.query((String)A_LGO_KEY, (String)"fa_depreadjustbill", (String)realCardNumber, (QFilter[])qFilterList.toArray(new QFilter[0]), null);
        if (Objects.isNull(dynObjCollection) || dynObjCollection.isEmpty()) {
            return;
        }
        Set realCardNumberSet = dynObjCollection.stream().map(dynObj -> dynObj.getString(realCardNumber)).collect(Collectors.toSet());
        String errorMsg = String.join((CharSequence)"\uff0c", realCardNumberSet);
        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u91cd\u542f\u5931\u8d25\uff0c\u4e0b\u5217\u8d44\u4ea7\u7f16\u7801\u5f53\u671f\u505a\u8fc7\u6298\u65e7\u8c03\u6574\uff1a%s\u3002", (String)"FaReStartRealBillSubmitValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), errorMsg));
    }

    private void checkNumberRepeat(Map<Long, List<DynamicObject>> orgId2AllClearReStartDynObjListMap) {
        if (Objects.isNull(orgId2AllClearReStartDynObjListMap) || orgId2AllClearReStartDynObjListMap.isEmpty()) {
            return;
        }
        Set<Map.Entry<Long, List<DynamicObject>>> entries = orgId2AllClearReStartDynObjListMap.entrySet();
        for (Map.Entry<Long, List<DynamicObject>> entry : entries) {
            Long orgId = entry.getKey();
            List<DynamicObject> allClearReStartDynObjList = entry.getValue();
            Set<Long> realCardMasterIdSet = allClearReStartDynObjList.stream().map(dynObj -> dynObj.getDynamicObject("realcard").getLong("masterid")).collect(Collectors.toSet());
            Set<String> realCardNumberSet = allClearReStartDynObjList.stream().map(dynObj -> dynObj.getDynamicObject("realcard").getString("number")).collect(Collectors.toSet());
            this.checkRepeatRealCardNumber(orgId, realCardMasterIdSet, realCardNumberSet);
            Set<String> realCardBillNoSet = allClearReStartDynObjList.stream().map(dynObj -> dynObj.getDynamicObject("realcard").getString("billno")).collect(Collectors.toSet());
            this.checkRepeatRealCardBillNo(orgId, realCardMasterIdSet, realCardBillNoSet);
        }
    }

    private void checkRepeatRealCardBillNo(Long orgId, Set<Long> realCardMasterIdSet, Set<String> realCardBillNoSet) {
        ArrayList<QFilter> realCardNoQFilterList = new ArrayList<QFilter>(3);
        realCardNoQFilterList.add(new QFilter("org", "=", (Object)orgId));
        realCardNoQFilterList.add(new QFilter("billno", "in", realCardBillNoSet));
        realCardNoQFilterList.add(new QFilter("isbak", "=", (Object)Boolean.FALSE));
        String selectFields = Fa.comma((String[])new String[]{"billno", "masterid"});
        DynamicObjectCollection realCardsDynObjCollection = QueryServiceHelper.query((String)A_LGO_KEY, (String)"fa_card_real", (String)selectFields, (QFilter[])realCardNoQFilterList.toArray(new QFilter[0]), null);
        if (Objects.isNull(realCardsDynObjCollection) || realCardsDynObjCollection.isEmpty()) {
            return;
        }
        Set repeatRealCardBillNoSet = realCardsDynObjCollection.stream().filter(dynObj -> !realCardMasterIdSet.contains(dynObj.getLong("masterid"))).map(dynObj -> dynObj.getString("billno")).collect(Collectors.toSet());
        if (repeatRealCardBillNoSet.size() == 0) {
            return;
        }
        String repeatRealCardBillNoStr = String.join((CharSequence)"\uff0c", repeatRealCardBillNoSet);
        String errorMsg = String.format(ResManager.loadKDString((String)"\u91cd\u542f\u5931\u8d25\uff0c\u5b58\u5728\u91cd\u590d\u7684\u5361\u7247\u7f16\u7801\uff1a%s\u3002", (String)"FaReStartRealBillSubmitValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), repeatRealCardBillNoStr);
        throw new KDBizException(errorMsg);
    }

    private void checkRepeatRealCardNumber(Long orgId, Set<Long> realCardMasterIdSet, Set<String> realCardNumberSet) {
        ArrayList<QFilter> realCardNumberQFilterList = new ArrayList<QFilter>(3);
        realCardNumberQFilterList.add(new QFilter("org", "=", (Object)orgId));
        realCardNumberQFilterList.add(new QFilter("number", "in", realCardNumberSet));
        realCardNumberQFilterList.add(new QFilter("isbak", "=", (Object)Boolean.FALSE));
        String selectFields = Fa.comma((String[])new String[]{"number", "masterid"});
        DynamicObjectCollection realCardsDynObjCollection = QueryServiceHelper.query((String)A_LGO_KEY, (String)"fa_card_real", (String)selectFields, (QFilter[])realCardNumberQFilterList.toArray(new QFilter[0]), null);
        if (Objects.isNull(realCardsDynObjCollection) || realCardsDynObjCollection.isEmpty()) {
            return;
        }
        Set repeatRealCardNumberSet = realCardsDynObjCollection.stream().filter(dynamicObject -> !realCardMasterIdSet.contains(dynamicObject.getLong("masterid"))).map(dynObj -> dynObj.getString("number")).collect(Collectors.toSet());
        if (repeatRealCardNumberSet.size() == 0) {
            return;
        }
        String repeatRealCardNumberStr = String.join((CharSequence)"\uff0c", repeatRealCardNumberSet);
        String errorMsg = String.format(ResManager.loadKDString((String)"\u91cd\u542f\u5931\u8d25\uff0c\u5b58\u5728\u91cd\u590d\u7684\u8d44\u4ea7\u7f16\u7801\uff1a%s\u3002", (String)"FaReStartRealBillSubmitValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), repeatRealCardNumberStr);
        throw new KDBizException(errorMsg);
    }

    private void checkFutureBiz(Long orgId, Date reStartDate, Set<Object> realCardMasterIds, ExtendedDataEntity dataEntity) {
        FutureBizChecker futureBizChecker = new FutureBizChecker(null, (Object)orgId, realCardMasterIds, reStartDate, BusyTypeDetailEnum.REAL_FIN_CHG);
        Optional optional = futureBizChecker.check();
        optional.ifPresent(s -> this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u65e0\u6cd5\u64cd\u4f5c\uff1a%s\u3002", (String)"FaReStartRealBillSubmitValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), s)));
    }
}

