/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.split;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaOpUtils;

public class FaSplitBillDataChangeValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            long curPeriodId;
            DynamicObject splitBill = dataEntity.getDataEntity();
            if (splitBill.getDate("splitdate") == null) continue;
            DynamicObject org = splitBill.getDynamicObject("org");
            long splitPeriodId = splitBill.getLong(Fa.id((String)"splitperiod"));
            if (splitPeriodId != (curPeriodId = this.getAssetBookCurPeriodByOrgId(org))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u4e0e\u62c6\u5206\u5355\u671f\u95f4\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u5236\u5355\u3002", (String)"FaSplitBillDataChangeValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            this.checkCardDataHasChange(dataEntity);
            FaOpUtils.checkDoOperable(dataEntity.getDataEntity(), "assetsplitentry", Fa.dot((String[])new String[]{"realcard", "masterid"}), "fa_assetsplitbill");
        }
    }

    private void checkCardDataHasChange(ExtendedDataEntity dataEntity) {
        DynamicObject splitBill = dataEntity.getDataEntity();
        DynamicObject splitCard = splitBill.getDynamicObject("split_realcard");
        if (splitCard == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u88ab\u62c6\u5206\u8d44\u4ea7\u3002", (String)"FaSplitBillDataChangeValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection befSplitEntry = splitBill.getDynamicObjectCollection("assetsplitentry");
        if (befSplitEntry.isEmpty()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62c6\u5206\u524d\u7684\u5361\u7247\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaSplitBillDataChangeValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        } else {
            BigDecimal assetAmount;
            BigDecimal splitAssetAmount;
            long unitId;
            DynamicObject realCardInDB = QueryServiceHelper.queryOne((String)"fa_card_real", (String)Fa.comma((String[])new String[]{"unit", "assetamount"}), (QFilter[])new QFilter[]{new QFilter("id", "=", splitCard.getPkValue())});
            Set finCardIds = befSplitEntry.stream().map(v -> v.getLong(Fa.id((String)"bef_fincard"))).collect(Collectors.toSet());
            DynamicObject befSplitReal = (DynamicObject)befSplitEntry.get(0);
            long splitUnitId = befSplitReal.getLong(Fa.id((String)"bef_unit"));
            if (splitUnitId != (unitId = realCardInDB.getLong("unit"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u8ba1\u91cf\u5355\u4f4d\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u5236\u5355\u3002", (String)"FaSplitBillDataChangeValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            if ((splitAssetAmount = befSplitReal.getBigDecimal("bef_assetamount")).compareTo(assetAmount = realCardInDB.getBigDecimal("assetamount")) != 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u8d44\u4ea7\u6570\u91cf\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u5236\u5355\u3002", (String)"FaSplitBillDataChangeValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            Map finCardId2CardInDB = BusinessDataServiceHelper.loadFromCache((String)"fa_card_fin", (String)Fa.comma((String[])new String[]{"id", "originalval", "originalamount", "decval", "preresidualval"}), (QFilter[])new QFilter[]{new QFilter("id", "in", finCardIds)});
            for (DynamicObject befSplit : befSplitEntry) {
                BigDecimal preResidualVal;
                BigDecimal splitPreResidualVal;
                BigDecimal decVal;
                BigDecimal splitDecVal;
                BigDecimal originalAmount;
                BigDecimal splitOriginalAmount;
                BigDecimal originalVal;
                long finCardId = befSplit.getLong(Fa.id((String)"bef_fincard"));
                DynamicObject finCardInDB = (DynamicObject)finCardId2CardInDB.get(finCardId);
                BigDecimal splitOriginalVal = befSplit.getBigDecimal("bef_originalval");
                if (splitOriginalVal.compareTo(originalVal = finCardInDB.getBigDecimal("originalval")) != 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u8d44\u4ea7\u539f\u503c\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u5236\u5355\u3002", (String)"FaSplitBillDataChangeValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
                if ((splitOriginalAmount = befSplit.getBigDecimal("bef_originalamount")).compareTo(originalAmount = finCardInDB.getBigDecimal("originalamount")) != 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u539f\u5e01\u91d1\u989d\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u5236\u5355\u3002", (String)"FaSplitBillDataChangeValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
                if ((splitDecVal = befSplit.getBigDecimal("bef_decval")).compareTo(decVal = finCardInDB.getBigDecimal("decval")) != 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u51cf\u503c\u51c6\u5907\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u5236\u5355\u3002", (String)"FaSplitBillDataChangeValidator_7", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
                if ((splitPreResidualVal = befSplit.getBigDecimal("bef_preresidualval")).compareTo(preResidualVal = finCardInDB.getBigDecimal("preresidualval")) == 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u9884\u8ba1\u51c0\u6b8b\u503c\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u5236\u5355\u3002", (String)"FaSplitBillDataChangeValidator_8", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private long getAssetBookCurPeriodByOrgId(DynamicObject org) {
        Map load = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (QFilter[])new QFilter[]{new QFilter("org", "=", org.getPkValue())});
        if (load.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%s\u3011\u4e0d\u5b58\u5728\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaSplitBillDataChangeValidator_9", (String)"fi-fa-opplugin", (Object[])new Object[0]), org.getString("name")));
        }
        long periodId = 0L;
        for (Map.Entry entry : load.entrySet()) {
            DynamicObject assetBook = (DynamicObject)entry.getValue();
            long curPeriodId = assetBook.getLong(Fa.id((String)"curperiod"));
            if (periodId == 0L) {
                periodId = curPeriodId;
                continue;
            }
            if (periodId == curPeriodId) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%s\u3011\u591a\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u4e0d\u4e00\u81f4\u3002", (String)"FaSplitBillDataChangeValidator_10", (String)"fi-fa-opplugin", (Object[])new Object[0]), org.getString("name")));
        }
        return periodId;
    }
}

