/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.split;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.assetsplit.FaSplitBillAndCardHelper;
import kd.fi.fa.common.util.Fa;

public class FaSplitCardBillAssetCardOp {
    private String operationKey;
    private boolean isCommit;
    FaSplitBillAndCardHelper convertHelper;
    private static final String PREFIX_TABLE = "t_";
    private static final String AUDIT = "audit";
    private static final Log log = LogFactory.getLog(FaSplitCardBillAssetCardOp.class);

    public FaSplitCardBillAssetCardOp(String operationKey, boolean isCommit, FaSplitBillAndCardHelper convertHelper) {
        this.operationKey = operationKey;
        this.isCommit = isCommit;
        this.convertHelper = convertHelper;
    }

    private FaSplitCardBillAssetCardOp() {
    }

    public String splitConvertCardProcess(DynamicObject splitBill) {
        String msg;
        this.genCardIds(splitBill);
        Map assetCardMap = this.convertHelper.splitBillConvert2AssetCardMap(splitBill);
        if (this.isCommit) {
            Long splitBillTableId = EntityMetadataCache.loadTableDefine((String)"fa_assetsplitbill", (String)"fa_assetsplitbill").getTableId();
            DynamicObjectType splitBillHeadType = ((EntryProp)EntityMetadataCache.getDataEntityType((String)"fa_assetsplitbill").getProperty("billhead_lk")).getDynamicCollectionItemPropertyType();
            for (DynamicObject card : assetCardMap.values()) {
                this.addSplitBill2CardLink(card, splitBill, splitBillTableId, splitBillHeadType);
            }
        }
        if ((msg = this.assetCardProcess(assetCardMap)) != null) {
            TXHandle txHandle = TX.requiresNew();
            Object object = null;
            try {
                DeleteServiceHelper.delete((String)"botp_billtracker", (QFilter[])new QFilter[]{new QFilter("sbillid", "=", (Object)splitBill.getLong("id"))});
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (txHandle != null) {
                    if (object != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
            }
        }
        return msg;
    }

    private void addSplitBill2CardLink(DynamicObject card, DynamicObject bill, Long splitBillTableId, DynamicObjectType splitBillHeadType) {
        DynamicObjectCollection billHeads = card.getDynamicObjectCollection("billhead_lk");
        billHeads.clear();
        DynamicObject billHead = new DynamicObject(splitBillHeadType);
        billHead.set("billhead_lk_stableid", (Object)splitBillTableId);
        billHead.set("billhead_lk_sbillid", bill.getPkValue());
        billHead.set("billhead_lk_sid", bill.getPkValue());
        billHead.set("seq", (Object)1);
        billHeads.add((Object)billHead);
    }

    private void genCardIds(DynamicObject splitBill) {
        String bizType = splitBill.getString("biztype");
        int newCardQty = "B".equals(bizType) ? splitBill.getInt("splitqty") : splitBill.getInt("splitqty") - 1;
        DynamicObjectCollection befSplitEntry = splitBill.getDynamicObjectCollection("assetsplitentry");
        long[] genRealIds = DB.genLongIds((String)"t_fa_card_real", (int)newCardQty);
        long[] genFinIds = DB.genLongIds((String)"t_fa_card_fin", (int)(newCardQty * befSplitEntry.size()));
        int j = 0;
        for (DynamicObject befSplit : befSplitEntry) {
            int i = 0;
            DynamicObjectCollection aftSplitEntry = befSplit.getDynamicObjectCollection("subassetsplitentry");
            for (DynamicObject aftSplit : aftSplitEntry) {
                if (aftSplit.getBoolean("issourcecard")) continue;
                if (aftSplit.getLong(Fa.id((String)"aft_realcard")) == 0L) {
                    aftSplit.set(Fa.id((String)"aft_realcard"), (Object)genRealIds[i]);
                }
                if (aftSplit.getLong(Fa.id((String)"aft_fincard")) == 0L) {
                    aftSplit.set(Fa.id((String)"aft_fincard"), (Object)genFinIds[j]);
                }
                ++i;
                ++j;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private String assetCardProcess(Map<Integer, DynamicObject> assetCardMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String assetAndRealCardOp(Map<Integer, DynamicObject> assetCardMap) {
        DynamicObject[] dataEntities = new DynamicObject[assetCardMap.size()];
        int i = 0;
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>(dataEntities.length);
        for (Map.Entry<Integer, DynamicObject> entry : assetCardMap.entrySet()) {
            dataEntities[i] = entry.getValue();
            indexMap.put(i, entry.getKey());
            ++i;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("skipbillnovalidator", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("WF", String.valueOf(false));
        OperationResult submitOperationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"fa_asset_card", (DynamicObject[])dataEntities, (OperateOption)option);
        log.info("fa_asset_card\u63d0\u4ea4\u64cd\u4f5c\u7ed3\u675f\uff0c\u672c\u6b21\u64cd\u4f5c\u5165\u5e93\u6807\u8bc6\uff1a" + this.isCommit + ", \u64cd\u4f5c\u7ed3\u679c\uff1a" + submitOperationResult.isSuccess());
        String submitMsg = FaSplitCardBillAssetCardOp.processOperationResult4Index(indexMap, submitOperationResult);
        if (submitMsg != null) {
            return submitMsg;
        }
        List ids = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (AUDIT.equals(this.operationKey)) {
            OperationResult auditOperationResult = OperationServiceHelper.executeOperate((String)AUDIT, (String)"fa_asset_card", (Object[])ids.toArray(), (OperateOption)option);
            log.info("fa_asset_card\u5ba1\u6838\u64cd\u4f5c\u7ed3\u675f\uff0c\u672c\u6b21\u64cd\u4f5c\u5165\u5e93\u6807\u8bc6\uff1a" + this.isCommit + ", \u64cd\u4f5c\u7ed3\u679c\uff1a" + auditOperationResult.isSuccess());
            return FaSplitCardBillAssetCardOp.processOperationResult4Index(indexMap, auditOperationResult);
        }
        return null;
    }

    private static String processOperationResult4Index(Map<Integer, Integer> indexMap, OperationResult operationResult) {
        if (!operationResult.isSuccess()) {
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            StringBuilder sb = new StringBuilder();
            String headMsg = ResManager.loadKDString((String)"\u62c6\u5206\u540e\u5361\u7247\u5206\u5f55\u884c\u53f7\u201c%s\u201d\uff1a", (String)"FaSplitCardBillAssetCardOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]);
            for (IOperateInfo operateInfo : allErrorOrValidateInfo) {
                OperateErrorInfo errorInfo = (OperateErrorInfo)operateInfo;
                int dataEntityIndex = errorInfo.getDataEntityIndex();
                String message = errorInfo.getMessage();
                if (sb.length() != 0) {
                    sb.append("\r\n");
                }
                sb.append(String.format(headMsg, indexMap.get(dataEntityIndex))).append(message);
            }
            if (StringUtils.isEmpty((String)sb.toString())) {
                return operationResult.getMessage();
            }
            return sb.toString();
        }
        return null;
    }
}

