/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.split;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.utils.FaOpUtils;

public class FaSplitCardBillAuditValidator
extends AbstractValidator {
    public void validate() {
        HashMap<Long, Boolean> orgId2SumMutilVou = new HashMap<Long, Boolean>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            try {
                FaOpUtils.checkDoOperable(dataEntity.getDataEntity(), "assetsplitentry", "realcard.masterid", "assetsplitentry");
                String bookNames = FaOpUtils.checkAssetBookDate(dataEntity.getDataEntity(), "org", "splitdate");
                if (!bookNames.isEmpty()) {
                    String msgCaption = ResManager.loadKDString((String)"\u62c6\u5206\u65e5\u671f\u4e0d\u5728\u8d26\u7c3f\u5f53\u524d\u671f\u95f4", (String)"FaSplitCardBillAuditValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format("%s:%s\u3002", msgCaption, bookNames));
                    continue;
                }
                boolean enableSumMutilVoucher = false;
                Long orgId = dataEntity.getDataEntity().getLong("org.id");
                if (orgId2SumMutilVou.get(orgId) != null) {
                    enableSumMutilVoucher = (Boolean)orgId2SumMutilVou.get(orgId);
                } else {
                    enableSumMutilVoucher = SystemParamHelper.getBooleanParam((String)"enable_sum_mutil_voucher", (long)orgId, (boolean)false);
                    orgId2SumMutilVou.put(orgId, enableSumMutilVoucher);
                }
                QFilter q1 = new QFilter("org.id", "=", (Object)dataEntity.getDataEntity().getDynamicObject("org").getLong("id"));
                QFilter q2 = null;
                q2 = !enableSumMutilVoucher ? new QFilter("period.id", ">=", (Object)dataEntity.getDataEntity().getDynamicObject("splitperiod").getLong("id")) : new QFilter("period.id", ">", (Object)dataEntity.getDataEntity().getDynamicObject("splitperiod").getLong("id"));
                DynamicObjectCollection depreSumList = QueryServiceHelper.query((String)"fa_depre_sum", (String)"id", (QFilter[])new QFilter[]{q1, q2});
                ArrayList<Object> depreSumIdSet = new ArrayList<Object>();
                for (DynamicObject depreSum : depreSumList) {
                    depreSumIdSet.add(depreSum.get("id"));
                }
                if (depreSumIdSet.size() <= 0 || !FaDepreUtil.hashVouncherV2(depreSumIdSet, (String)"fa_depre_sum")) continue;
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1", (String)"FaSplitCardBillAuditValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                this.addMessage(dataEntity, e.getMessage(), ErrorLevel.Error);
            }
        }
    }
}

