/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.split;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;

public class FaSplitCardBillManualCodeValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection existsBarCodes;
            String barcode;
            DynamicObjectCollection existsNumbers;
            String number;
            long orgId;
            DynamicObjectCollection existsBillNos;
            String billNo;
            HashSet<String> cardBillNos = new HashSet<String>(this.dataEntities.length);
            HashSet<String> cardNumbers = new HashSet<String>(this.dataEntities.length);
            HashSet<String> cardBarCodes = new HashSet<String>(this.dataEntities.length);
            this.checkCode(dataEntity, cardBillNos, cardNumbers, cardBarCodes);
            if (!"save".equals(this.getOperateType())) continue;
            if (!cardBillNos.isEmpty() && (billNo = String.join((CharSequence)"\u3001", (existsBillNos = QueryServiceHelper.query((String)"fa_card_real", (String)"billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", cardBillNos), new QFilter("org", "=", (Object)(orgId = dataEntity.getDataEntity().getLong(Fa.id((String)"org"))))})).stream().map(v -> v.getString("billno")).collect(Collectors.toSet()))).length() != 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f00\u542f\u624b\u5de5\u7f16\u7801\u540e\uff0c\u4ee5\u4e0b\u5361\u7247\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728\uff1a%s\u3002", (String)"FaSplitCardBillManualCodeValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNo));
            }
            if (!cardNumbers.isEmpty() && (number = String.join((CharSequence)"\u3001", (existsNumbers = QueryServiceHelper.query((String)"fa_card_real", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "in", cardNumbers)})).stream().map(v -> v.getString("number")).collect(Collectors.toSet()))).length() != 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f00\u542f\u624b\u5de5\u7f16\u7801\u540e\uff0c\u4ee5\u4e0b\u8d44\u4ea7\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff1a%s\u3002", (String)"FaSplitCardBillManualCodeValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), number));
            }
            if (cardBarCodes.isEmpty() || (barcode = String.join((CharSequence)"\u3001", (existsBarCodes = QueryServiceHelper.query((String)"fa_card_real", (String)"barcode", (QFilter[])new QFilter[]{new QFilter("barcode", "in", cardBarCodes)})).stream().map(v -> v.getString("barcode")).collect(Collectors.toSet()))).length() == 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f00\u542f\u624b\u5de5\u7f16\u7801\u540e\uff0c\u4ee5\u4e0b\u6761\u5f62\u7801\u5df2\u7ecf\u5b58\u5728\uff1a%s\u3002", (String)"FaSplitCardBillManualCodeValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), barcode));
        }
    }

    private void checkCode(ExtendedDataEntity dataEntity, Set<String> cardBillNos, Set<String> cardNumbers, Set<String> cardBarCodes) {
        DynamicObject splitBill = dataEntity.getDataEntity();
        boolean isManualCode = splitBill.getBoolean("ismanualcode");
        if (isManualCode) {
            this.checkOpenManualCode(dataEntity, splitBill, cardBillNos, cardNumbers, cardBarCodes);
        } else {
            this.checkCloseManualCode(dataEntity, splitBill);
        }
    }

    private void checkCloseManualCode(ExtendedDataEntity dataEntity, DynamicObject splitBill) {
        DynamicObjectCollection aftSplitEntry = this.getAftSplitEntry(splitBill);
        if (aftSplitEntry == null) {
            return;
        }
        int index = 0;
        for (DynamicObject aftSplit : aftSplitEntry) {
            String cardBarCode;
            String cardNumber;
            ++index;
            if (aftSplit.getBoolean("issourcecard")) continue;
            String cardBillNo = aftSplit.getString("aft_cardbillno");
            if (StringUtils.isNotBlank((CharSequence)cardBillNo)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u5355\u672a\u5f00\u542f\u624b\u5de5\u7f16\u7801\uff0c\u62c6\u5206\u540e\u5206\u5f55\u7b2c %s \u884c\u5361\u7247\u7f16\u53f7\u4e0d\u5141\u8bb8\u5f55\u5165\u3002", (String)"FaSplitCardBillManualCodeValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), index));
            }
            if (StringUtils.isNotBlank((CharSequence)(cardNumber = aftSplit.getString("aft_cardnumber")))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u5355\u672a\u5f00\u542f\u624b\u5de5\u7f16\u7801\uff0c\u62c6\u5206\u540e\u5206\u5f55\u7b2c %s \u884c\u8d44\u4ea7\u7f16\u7801\u4e0d\u5141\u8bb8\u5f55\u5165\u3002", (String)"FaSplitCardBillManualCodeValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), index));
            }
            if (!StringUtils.isNotBlank((CharSequence)(cardBarCode = aftSplit.getString("aft_barcode")))) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u5355\u672a\u5f00\u542f\u624b\u5de5\u7f16\u7801\uff0c\u62c6\u5206\u540e\u5206\u5f55\u7b2c %s \u884c\u6761\u5f62\u7801\u4e0d\u5141\u8bb8\u5f55\u5165\u3002", (String)"FaSplitCardBillManualCodeValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), index));
        }
    }

    private void checkOpenManualCode(ExtendedDataEntity dataEntity, DynamicObject splitBill, Set<String> cardBillNos, Set<String> cardNumbers, Set<String> cardBarCodes) {
        DynamicObjectCollection aftSplitEntry = this.getAftSplitEntry(splitBill);
        if (aftSplitEntry == null) {
            return;
        }
        int index = 0;
        String billNo = "";
        String number = "";
        String barCode = "";
        for (DynamicObject aftSplit : aftSplitEntry) {
            String cardBillNo = aftSplit.getString("aft_cardbillno");
            if (++index == 1) {
                billNo = cardBillNo;
            } else if (StringUtils.isBlank((CharSequence)cardBillNo)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u5355\u5df2\u5f00\u542f\u624b\u5de5\u7f16\u7801\uff0c\u62c6\u5206\u540e\u5206\u5f55\u7b2c %s \u884c\u5361\u7247\u7f16\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FaSplitCardBillManualCodeValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), index));
            } else if (billNo.equals(cardBillNo) || !cardBillNos.add(cardBillNo)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u540e\u5206\u5f55\u7b2c %1$s \u884c\uff0c\u5361\u7247\u7f16\u53f7\u91cd\u590d\uff1a%2$s\u3002", (String)"FaSplitCardBillManualCodeValidator_7", (String)"fi-fa-opplugin", (Object[])new Object[0]), index, cardBillNo));
            }
            String cardNumber = aftSplit.getString("aft_cardnumber");
            if (index == 1) {
                number = cardNumber;
            } else if (StringUtils.isBlank((CharSequence)cardNumber)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u5355\u5df2\u5f00\u542f\u624b\u5de5\u7f16\u7801\uff0c\u62c6\u5206\u540e\u5206\u5f55\u7b2c %s \u884c\u8d44\u4ea7\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FaSplitCardBillManualCodeValidator_8", (String)"fi-fa-opplugin", (Object[])new Object[0]), index));
            } else if (number.equals(cardNumber) || !cardNumbers.add(cardNumber)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u540e\u5206\u5f55\u7b2c %1$s \u884c\uff0c\u8d44\u4ea7\u7f16\u7801\u91cd\u590d\uff1a%2$s\u3002", (String)"FaSplitCardBillManualCodeValidator_9", (String)"fi-fa-opplugin", (Object[])new Object[0]), index, cardNumber));
            }
            String cardBarCode = aftSplit.getString("aft_barcode");
            if (index == 1) {
                barCode = cardBarCode;
                continue;
            }
            if (!barCode.equals(cardBarCode) && (!StringUtils.isNotBlank((CharSequence)cardBarCode) || cardBarCodes.add(cardBarCode))) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u540e\u5206\u5f55\u7b2c %1$s \u884c\uff0c\u6761\u5f62\u7801\u91cd\u590d\uff1a%2$s\u3002", (String)"FaSplitCardBillManualCodeValidator_10", (String)"fi-fa-opplugin", (Object[])new Object[0]), index, cardBarCode));
        }
    }

    private DynamicObjectCollection getAftSplitEntry(DynamicObject splitBill) {
        DynamicObjectCollection befSplitEntry = splitBill.getDynamicObjectCollection("assetsplitentry");
        if (befSplitEntry == null || befSplitEntry.isEmpty()) {
            return null;
        }
        DynamicObject befSplit = (DynamicObject)befSplitEntry.get(0);
        DynamicObjectCollection aftSplitEntry = befSplit.getDynamicObjectCollection("subassetsplitentry");
        if (aftSplitEntry == null || aftSplitEntry.isEmpty()) {
            return null;
        }
        return aftSplitEntry;
    }
}

