/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.split;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.dao.IFaFinCardDao;
import kd.fi.fa.business.dao.IFaRealCardDao;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.depretask.DepreSplitSum;
import kd.fi.fa.business.po.FaCardVersionParameter;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.utils.FaOperateLogUtil;
import kd.fi.fa.business.utils.FaShareOpUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.AbstractBizCtrOperationServicePlugIn;
import kd.fi.fa.opplugin.FaMigrateDateValidator;
import kd.fi.fa.opplugin.realcard.FaRealCardCodeOpUtils;
import kd.fi.fa.opplugin.split.FaSplitCardBillUnAuditValidator;

public class FaSplitCardBillUnAuditOp
extends AbstractBizCtrOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FaSplitCardBillUnAuditOp.class);
    private static final String[] SELECTOR = new String[]{"id", "originalval", "accumdepre", "addupyeardepre", "decval", "preresidualval", "networth", "netamount", "originalamount", "incometax", "monthorigvalchg", "yearorigvalchg", "monthdepre", "monthdeprechg", "isneeddepre", "depredamount", "bizperiod", "org", "depreuse", "addidepreamount"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("billno");
        fieldKeys.add("splitperiod");
        fieldKeys.add("billstatus");
        fieldKeys.add("splittype");
        fieldKeys.add("splitdate");
        fieldKeys.add("split_realcard");
        fieldKeys.add("assetsplitentry");
        fieldKeys.add("createtime");
        fieldKeys.add("modifytime");
        fieldKeys.add("biztype");
        fieldKeys.add("voucherflag");
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "realcard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_assetamount"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_fincard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_originalval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_accumdepre"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_addupyeardepre"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_decval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_preresidualval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_networth"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_netamount"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_originalamount"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_incometax"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_monthorigvalchg"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_yearorigvalchg"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_monthdepre"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_monthdeprechg"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "bef_bakrealcard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"assetsplitentry", "realcardmasterid"}));
        fieldKeys.add("subassetsplitentry");
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_realcard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_cardnumber"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_cardbillno"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_unit"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_fincard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_basecurrency"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_assetamount"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_originalval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_accumdepre"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_addupyeardepre"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_decval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_preresidualval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_networth"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_netamount"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_originalamount"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_incometax"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_monthorigvalchg"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_yearorigvalchg"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_monthdepre"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "aft_monthdeprechg"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"subassetsplitentry", "issourcecard"}));
        fieldKeys.add("aft_barcode");
        fieldKeys.add("aft_monthaccumdeprechg");
        fieldKeys.add("ismanualcode");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaMigrateDateValidator());
        e.addValidator((AbstractValidator)new FaSplitCardBillUnAuditValidator());
    }

    /*
     * Exception decompiling
     */
    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void beginOperationTransactionOneOrg(long orgId, List<DynamicObject> bills) {
        HashSet<Object> billIds = new HashSet<Object>(bills.size());
        HashSet realIdCreatedBySplit = new HashSet();
        HashMap<Long, Long> befAndAftMap = new HashMap<Long, Long>();
        ArrayList<Long> bakRealIds = new ArrayList<Long>();
        IFaFinCardDao finDao = FaFinCardDaoFactory.getInstance();
        DynamicObjectCollection books = FaBizUtils.getAsstBookFieldsByOrg((Long)orgId, (String)Fa.comma((String[])new String[]{"id", "depreuse", "curperiod"}));
        HashMap<Long, Object> bookMap = new HashMap<Long, Object>(4);
        for (Object book : books) {
            bookMap.put(book.getLong("id"), book);
        }
        ArrayList<Long> srcBillIdList = new ArrayList<Long>(bakRealIds.size());
        for (DynamicObject bill : bills) {
            this.deleteClearBill(bill);
            billIds.add(bill.getPkValue());
            srcBillIdList.add(bill.getLong("id"));
            FaModiRealStatsUtils.update_splitbill_bizStatus((DynamicObject)bill, (BizStatusEnum)BizStatusEnum.SPLIT, (BizStatusEnum)BizStatusEnum.READY);
            DynamicObjectCollection befRowDys = bill.getDynamicObjectCollection("assetsplitentry");
            boolean isManualCode = bill.getBoolean("ismanualcode");
            for (DynamicObject befRowDy : befRowDys) {
                DynamicObject befBakRealDy = befRowDy.getDynamicObject("bef_bakrealcard");
                DynamicObject befBakFinDy = befRowDy.getDynamicObject("bef_fincard");
                if (befBakRealDy == null) continue;
                Long bakRealId = befBakRealDy.getLong("id");
                bakRealIds.add(bakRealId);
                long realCardId = befBakFinDy.getLong(Fa.id((String)"realcard"));
                befAndAftMap.put(bakRealId, realCardId);
                long assetBookId = befBakFinDy.getDynamicObject("assetbook").getLong("id");
                DynamicObject book = (DynamicObject)bookMap.get(assetBookId);
                if (book == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u62c6\u5206\u5361\u7247\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaSplitCardBillUnAuditOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
                finDao.restoreCard(book.getLong("curperiod"), book.getLong("depreuse"), new Object[]{realCardId}, v -> this.unFinSplitCardHandle(befRowDy, v, realIdCreatedBySplit, isManualCode), SELECTOR);
                befRowDy.set(Fa.id((String)"bef_bakrealcard"), (Object)0);
                befRowDy.set("bef_bakrealcard", null);
            }
            bill.set("voucherflag", (Object)"B");
        }
        this.unRealSplitCard(bills);
        DeleteServiceHelper.delete((String)"fa_depresplitsetup", (QFilter[])new QFilter("realcard", "in", realIdCreatedBySplit).toArray());
        SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[0]));
        DeleteServiceHelper.delete((String)"fa_card_dynamic", (QFilter[])new QFilter[]{new QFilter("entityname", "=", (Object)"fa_assetsplitbill"), new QFilter("changebillid", "in", billIds)});
        IFaRealCardDao realDao = FaRealCardDaoFactory.getInstance();
        DynamicObject[] finDynamics = finDao.query(new QFilter("realcard.masterid", "in", realIdCreatedBySplit));
        FaShareOpUtils.deleteFaShare(Arrays.asList(finDynamics), (String)"fa_card_fin");
        FaOperateLogUtil.OpNameInfo opNameInfo = new FaOperateLogUtil.OpNameInfo("delete", new MultiLangEnumBridge("\u5220\u9664", "FaSplitCardBillUnAuditOp_1", "fi-fa-opplugin"));
        String numbers4Fin = "";
        if (finDynamics != null && finDynamics.length > 0) {
            numbers4Fin = Arrays.stream(finDynamics).map(dyn -> dyn.getString("number")).collect(Collectors.joining(","));
        }
        FaOperateLogUtil.OpDescriptionInfo opDescriptionInfo = new FaOperateLogUtil.OpDescriptionInfo(new MultiLangEnumBridge("\u5220\u9664\u8d22\u52a1\u5361\u7247\uff0c\u7f16\u53f7\u4e3a\uff1a%s", "FaSplitCardBillUnAuditOp_2", "fi-fa-opplugin"), new String[]{numbers4Fin});
        FaOperateLogUtil.addLog((String)"fa_card_fin", null, (FaOperateLogUtil.OpNameInfo)opNameInfo, (FaOperateLogUtil.OpDescriptionInfo)opDescriptionInfo);
        finDao.delete(new QFilter("realcard.masterid", "in", realIdCreatedBySplit));
        DynamicObject[] realDynamics = realDao.query(new QFilter("id", "in", (Object)realIdCreatedBySplit.toArray()));
        if (realDynamics != null && realDynamics.length > 0) {
            DynamicObject realCard = realDynamics[0];
            long assetUnitId = realCard.getLong(Fa.id((String)"assetunit"));
            FaRealCardCodeOpUtils.batchRecycleCodeAndDelShare(assetUnitId, realDynamics);
        }
        String numbers4Real = "";
        if (realDynamics != null && realDynamics.length > 0) {
            numbers4Real = Arrays.stream(realDynamics).map(dyn -> dyn.getString("number")).collect(Collectors.joining(","));
        }
        FaOperateLogUtil.OpDescriptionInfo opDescriptionInfo4DelReal = new FaOperateLogUtil.OpDescriptionInfo(new MultiLangEnumBridge("\u5b9e\u7269\u5361\u7247\uff08\u7f16\u53f7\uff1a%s\uff09\u5df2\u5220\u9664\u3002", "FaSplitCardBillUnAuditOp_3", "fi-fa-opplugin"), new String[]{numbers4Real});
        FaOperateLogUtil.addLog((String)"fa_card_real", null, (FaOperateLogUtil.OpNameInfo)opNameInfo, (FaOperateLogUtil.OpDescriptionInfo)opDescriptionInfo4DelReal);
        DeleteServiceHelper.delete((String)"fa_asset_card", (QFilter[])new QFilter[]{new QFilter("masterid", "in", realIdCreatedBySplit)});
        AttachmentServiceHelper.batchRemove((String)"fa_card_real", realIdCreatedBySplit.stream().collect(Collectors.toList()));
        DeleteServiceHelper.delete((String)"fa_card_dynamic", (QFilter[])new QFilter[]{new QFilter("realcard", "in", realIdCreatedBySplit)});
        FaCardVersionParameter cardVersionParameter = new FaCardVersionParameter();
        cardVersionParameter.setSrcBillIdList(srcBillIdList);
        cardVersionParameter.setSrcbillentityname("fa_assetsplitbill");
        realDao.restoreCards(bakRealIds.toArray(), befAndAftMap, BizStatusEnum.SPLIT, null, null, cardVersionParameter);
        new DepreSplitSum().deduct(finDynamics, true, false);
    }

    private void deleteClearBill(DynamicObject bill) {
        String bizType = bill.getString("biztype");
        if ("B".equalsIgnoreCase(bizType)) {
            Long billId = bill.getLong("id");
            DynamicObject clearBill = QueryServiceHelper.queryOne((String)"fa_clearbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("srcbill", "=", (Object)billId), new QFilter("clearsource", "=", (Object)FaClearSourceEnum.SPLIT.name())});
            if (clearBill == null) {
                return;
            }
            Set<Long> clearBillIds = Collections.singleton(clearBill.getLong("id"));
            OperateOption operate = OperateOption.create();
            operate.setVariableValue("unAuditFromSplit", "true");
            operate.setVariableValue("ishasright", String.valueOf(true));
            OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"fa_clearbill", (Object[])clearBillIds.toArray(new Long[0]), (OperateOption)operate);
            FaCommonUtils.handleOperationResult((OperationResult)result);
            operate = OperateOption.create();
            operate.setVariableValue("deleteClearBillByUnAudit", "true");
            operate.setVariableValue("ishasright", "true");
            result = OperationServiceHelper.executeOperate((String)"delete", (String)"fa_clearbill", (Object[])clearBillIds.toArray(new Long[0]), (OperateOption)operate);
            FaCommonUtils.handleOperationResult((OperationResult)result);
        }
    }

    private void unFinSplitCardHandle(DynamicObject befRowDy, DynamicObject befFinDy, Set<Long> realIdCreatedBySplit, boolean isManualCode) {
        DynamicObjectCollection aftRowDys = befRowDy.getDynamicObjectCollection("subassetsplitentry");
        BigDecimal aftMonthAccDepChg = BigDecimal.ZERO;
        for (DynamicObject aftRowDy : aftRowDys) {
            if (!aftRowDy.getBoolean("issourcecard")) {
                DynamicObject aftRealDy = aftRowDy.getDynamicObject("aft_realcard");
                long aftRealId = aftRealDy == null ? 0L : aftRealDy.getLong("id");
                realIdCreatedBySplit.add(aftRealId);
                aftRowDy.set(Fa.id((String)"aft_fincard"), (Object)0);
                aftRowDy.set("aft_fincard", null);
                aftRowDy.set(Fa.id((String)"aft_realcard"), (Object)0);
                aftRowDy.set("aft_realcard", null);
                if (isManualCode) continue;
                aftRowDy.set("aft_cardbillno", (Object)"");
                aftRowDy.set("aft_cardnumber", (Object)"");
                aftRowDy.set("aft_barcode", (Object)"");
                continue;
            }
            aftMonthAccDepChg = aftRowDy.getBigDecimal("aft_monthaccumdeprechg");
        }
        BigDecimal befOriginalVal = befRowDy.getBigDecimal("bef_originalval");
        BigDecimal befAccumDepre = befRowDy.getBigDecimal("bef_accumdepre");
        BigDecimal befAddUpYearDepre = befRowDy.getBigDecimal("bef_addupyeardepre");
        BigDecimal befDecVal = befRowDy.getBigDecimal("bef_decval");
        BigDecimal befPreResidualVal = befRowDy.getBigDecimal("bef_preresidualval");
        BigDecimal befNetWorth = befRowDy.getBigDecimal("bef_networth");
        BigDecimal befNetAmount = befRowDy.getBigDecimal("bef_netamount");
        BigDecimal befOriginalAmount = befRowDy.getBigDecimal("bef_originalamount");
        BigDecimal befIncomeTax = befRowDy.getBigDecimal("bef_incometax");
        BigDecimal befMonthOrigValChg = befRowDy.getBigDecimal("bef_monthorigvalchg");
        BigDecimal befYearOrigValChg = befRowDy.getBigDecimal("bef_yearorigvalchg");
        BigDecimal befMonthDepreChg = befRowDy.getBigDecimal("bef_monthdeprechg");
        befFinDy.set("originalval", (Object)befOriginalVal);
        befFinDy.set("accumdepre", (Object)befAccumDepre);
        befFinDy.set("addupyeardepre", (Object)befAddUpYearDepre);
        befFinDy.set("decval", (Object)befDecVal);
        befFinDy.set("preresidualval", (Object)befPreResidualVal);
        befFinDy.set("networth", (Object)befNetWorth);
        befFinDy.set("netamount", (Object)befNetAmount);
        befFinDy.set("originalamount", (Object)befOriginalAmount);
        befFinDy.set("incometax", (Object)befIncomeTax);
        befFinDy.set("monthorigvalchg", (Object)befMonthOrigValChg);
        befFinDy.set("yearorigvalchg", (Object)befYearOrigValChg);
        befFinDy.set("monthdepre", (Object)BigDecimal.ZERO);
        befFinDy.set("monthdeprechg", (Object)befMonthDepreChg);
        befFinDy.set("monthaccumdeprechg", (Object)befFinDy.getBigDecimal("monthaccumdeprechg").subtract(aftMonthAccDepChg));
        befFinDy.set("isneeddepre", (Object)"1");
    }

    private void unRealSplitCard(List<DynamicObject> bills) {
        DynamicObject[] splitRealCards;
        HashMap<Long, BigDecimal> realCardId2AssetAmount = new HashMap<Long, BigDecimal>(FaUtils.getInitialCapacity43((int)bills.size()));
        for (DynamicObject bill : bills) {
            DynamicObjectCollection befSplitEntry = bill.getDynamicObjectCollection("assetsplitentry");
            if (befSplitEntry == null || befSplitEntry.isEmpty()) continue;
            DynamicObject befEntry = (DynamicObject)befSplitEntry.get(0);
            BigDecimal befSplitAssetAmount = befEntry.getBigDecimal("bef_assetamount");
            realCardId2AssetAmount.put(befEntry.getLong("realcardmasterid"), befSplitAssetAmount);
        }
        for (DynamicObject splitRealCard : splitRealCards = BusinessDataServiceHelper.load((Object[])realCardId2AssetAmount.keySet().toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_real"))) {
            long realCardId = splitRealCard.getLong("id");
            if (!realCardId2AssetAmount.containsKey(realCardId)) continue;
            splitRealCard.set("assetamount", realCardId2AssetAmount.get(realCardId));
        }
        SaveServiceHelper.save((DynamicObject[])splitRealCards);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        Set splitBillPks = Arrays.stream(e.getDataEntities()).map(v -> v.getPkValue()).collect(Collectors.toSet());
        DeleteServiceHelper.delete((String)"botp_billtracker", (QFilter[])new QFilter[]{new QFilter("sbillid", "in", splitBillPks)});
    }
}

