/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.split;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.utils.CheckFaFinCardDataUtil;
import kd.fi.fa.common.util.Fa;

public class FaSplitCardBillWorkLoadValidator
extends AbstractValidator {
    public void validate() {
        Map<Long, DynamicObject> finCardId2DepreMethodTypeMap = this.getFinCardId2DepreMethodTypeMap();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject splitBill = dataEntity.getDataEntity();
            DynamicObjectCollection assetSplitBefEntry = splitBill.getDynamicObjectCollection("assetsplitentry");
            for (DynamicObject assetSplitBefDynObj : assetSplitBefEntry) {
                String depreuseName = assetSplitBefDynObj.getString(Fa.dot((String[])new String[]{"bef_depreuse", "name"}));
                DynamicObjectCollection aftSplitEntryDynObjColl = assetSplitBefDynObj.getDynamicObjectCollection("subassetsplitentry");
                int i = 1;
                for (DynamicObject aftSplitDynObj : aftSplitEntryDynObjColl) {
                    Object depredAmountObj;
                    Object preUsingAmountObj;
                    Object workLoadUnitObj;
                    Object depreMethodObj;
                    boolean isSourceCard = aftSplitDynObj.getBoolean("issourcecard");
                    Object numberObj = null;
                    if (isSourceCard) {
                        DynamicObject finCard = aftSplitDynObj.getDynamicObject("aft_fincard");
                        depreMethodObj = finCardId2DepreMethodTypeMap.get((Long)finCard.getPkValue());
                        workLoadUnitObj = finCard.get("workloadunit");
                        preUsingAmountObj = finCard.get("preusingamount");
                        depredAmountObj = finCard.get("depredamount");
                        numberObj = finCard.get("number");
                    } else {
                        depreMethodObj = aftSplitDynObj.get("aft_depremethod");
                        workLoadUnitObj = aftSplitDynObj.get("aft_workloadunit");
                        preUsingAmountObj = aftSplitDynObj.get("aft_preusingamount");
                        depredAmountObj = aftSplitDynObj.get("aft_depredamount");
                    }
                    Set errorMsgSet = CheckFaFinCardDataUtil.checkPreUsingAmountAndDepredAmount((Object)depreMethodObj, (Object)workLoadUnitObj, (Object)preUsingAmountObj, (Object)depredAmountObj, numberObj);
                    if (errorMsgSet.size() > 0) {
                        String errorMsg = String.join((CharSequence)";", errorMsgSet);
                        if (numberObj != null && StringUtils.isNotEmpty((String)numberObj.toString())) {
                            errorMsg = errorMsg.replaceAll(numberObj.toString(), "");
                        }
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\uff1a%1$s\uff0c\u62c6\u5206\u540e\u5361\u7247\u7b2c%2$s\u884c\uff1a%3$s", (String)"FaSplitCardBillWorkLoadValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), depreuseName, i, errorMsg));
                    }
                    ++i;
                }
            }
        }
    }

    private Map<Long, DynamicObject> getFinCardId2DepreMethodTypeMap() {
        DynamicObject[] dynamicObjects;
        ArrayList<Object> finCardIdList = new ArrayList<Object>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject splitBill = dataEntity.getDataEntity();
            DynamicObjectCollection assetSplitBefEntry = splitBill.getDynamicObjectCollection("assetsplitentry");
            for (DynamicObject assetSplitBefDynObj : assetSplitBefEntry) {
                DynamicObjectCollection aftSplitEntryDynObjColl = assetSplitBefDynObj.getDynamicObjectCollection("subassetsplitentry");
                for (DynamicObject aftSplitDynObj : aftSplitEntryDynObjColl) {
                    boolean isSourceCard = aftSplitDynObj.getBoolean("issourcecard");
                    if (!isSourceCard) continue;
                    DynamicObject finCard = aftSplitDynObj.getDynamicObject("aft_fincard");
                    Object pkValue = finCard.getPkValue();
                    finCardIdList.add(pkValue);
                }
            }
        }
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        if (finCardIdList.size() == 0) {
            return map;
        }
        String selectFields = Fa.comma((String[])new String[]{"id", "depremethod"});
        QFilter qFilter = new QFilter("id", "in", finCardIdList);
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selectFields, (QFilter[])qFilter.toArray())) {
            long k = dynamicObject.getLong("id");
            map.put(k, dynamicObject.getDynamicObject("depremethod"));
        }
        return map;
    }
}

