/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.storekeeper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class FaStoreKeeperSaveOp
extends AbstractOperationServicePlugIn {
    private static final int STATUS_EQUAL = 0;
    private static final int STATUS_CONTAIN = 1;
    private static final int STATUS_BECONTAINED = 2;
    private static final int STATUS_UNCONTAIN = -1;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject storeKeeperObj = dataEntity.getDataEntity();
                    QFilter qFilter = new QFilter("enable", "=", (Object)"1");
                    qFilter.and("org", "=", (Object)storeKeeperObj.getDynamicObject("org").getLong("id"));
                    qFilter.and("id", "!=", (Object)storeKeeperObj.getLong("id"));
                    QFilter[] qFilters = qFilter.toArray();
                    DynamicObject existKeeper = QueryServiceHelper.queryOne((String)"fa_storekeeper", (String)"id", (QFilter[])qFilters);
                    if (existKeeper != null) {
                        String number = storeKeeperObj.getDynamicObject("org").getString("name");
                        String errMsg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7ec4\u7ec7\"%s\"\u5df2\u8bbe\u7f6e\u5e93\u7ba1\u5458\uff0c\u8bf7\u76f4\u63a5\u4fee\u6539\u3002", (String)"FaStoreKeeperSaveOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), number);
                        this.addErrorMessage(dataEntity, errMsg);
                    }
                    DynamicObjectCollection entry = storeKeeperObj.getDynamicObjectCollection("storekeeperentry");
                    String dimensionValue = storeKeeperObj.getString("dimension");
                    if (StringUtils.isEmpty((String)dimensionValue)) {
                        return;
                    }
                    List<String> dimensionList = Arrays.asList(dimensionValue.split(","));
                    ArrayList entryDimList = new ArrayList(entry.size());
                    FaStoreKeeperSaveOp.this.initEntryDimList(entryDimList, entry, dimensionList);
                    ArrayList checkedList = new ArrayList();
                    HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
                    AtomicInteger errorIndex = new AtomicInteger(0);
                    for (int i = 0; i < entryDimList.size(); ++i) {
                        List currentRow = (List)entryDimList.get(i);
                        if (FaStoreKeeperSaveOp.this.check(checkedList, currentRow, errorIndex, dimensionList.size() - 1)) {
                            indexMap.put(checkedList.size(), i + 1);
                            continue;
                        }
                        String errMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u3001\u7b2c%2$s\u884c\u5b58\u5728\u91cd\u590d\u7684\u5e93\u623f\u7ba1\u7406\u7ef4\u5ea6\u7ec4\u5408\uff0c\u8bf7\u5220\u9664\u91cd\u590d\u6570\u636e\u3002", (String)"FaStoreKeeperSaveOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), indexMap.get(errorIndex.get()), i + 1);
                        this.addErrorMessage(dataEntity, errMsg);
                    }
                }
            }
        });
    }

    private void initEntryDimList(List<List<String>> entryDimList, DynamicObjectCollection entry, List<String> dimensionList) {
        for (DynamicObject entryItem : entry) {
            ArrayList<String> dimList = new ArrayList<String>(5);
            for (int i = 1; i < dimensionList.size(); ++i) {
                String dimension = dimensionList.get(i);
                if (FaStoreKeeperSaveOp.isBasedata(dimension).booleanValue()) {
                    DynamicObject dimensionDynamicObj = entryItem.getDynamicObject(dimension);
                    if (dimensionDynamicObj == null) continue;
                    dimList.add(i + "_" + dimensionDynamicObj.getString("id"));
                    continue;
                }
                if (FaStoreKeeperSaveOp.isMulBasedata(dimension).booleanValue()) {
                    DynamicObjectCollection dimensionCollection = entryItem.getDynamicObjectCollection(dimension);
                    for (DynamicObject dimensionItem : dimensionCollection) {
                        dimList.add(i + "_" + dimensionItem.getDynamicObject("fbasedataid").getString("id"));
                    }
                    continue;
                }
                dimList.add(i + "_" + entryItem.get(dimension).toString());
            }
            entryDimList.add(dimList);
        }
    }

    private boolean check(List<List<String>> checkedList, List<String> currentRow, AtomicInteger errorIndex, int dimensionCount) {
        if (checkedList.isEmpty()) {
            checkedList.add(currentRow);
            return true;
        }
        for (int i = 0; i < checkedList.size(); ++i) {
            List<String> currentCheckItem = checkedList.get(i);
            int containStatus = this.containRelation(currentCheckItem, currentRow, dimensionCount);
            if (containStatus == -1) continue;
            errorIndex.set(i + 1);
            return false;
        }
        checkedList.add(currentRow);
        return true;
    }

    private int containRelation(List<String> pk1, List<String> pk2, int dimesnionCount) {
        int[] result = new int[dimesnionCount];
        for (String str : pk2) {
            if (!pk1.contains(str)) continue;
            result[Integer.parseInt((String)str.substring((int)0, (int)1)) - 1] = 1;
        }
        int containCount = 0;
        for (int i = 0; i < dimesnionCount; ++i) {
            containCount += result[i];
        }
        if (containCount < dimesnionCount) {
            return -1;
        }
        return 1;
    }

    public static Boolean isMulBasedata(String propertyName) {
        boolean result = true;
        MainEntityType storeKeeperEntityType = EntityMetadataCache.getDataEntityType((String)"fa_storekeeper");
        IDataEntityType entryType = ((EntryProp)storeKeeperEntityType.getProperty("storekeeperentry")).getItemType();
        DataEntityPropertyCollection propertys = entryType.getProperties();
        IDataEntityProperty property = (IDataEntityProperty)propertys.get((Object)propertyName);
        result = property instanceof MulBasedataProp;
        return result;
    }

    public static Boolean isBasedata(String propertyName) {
        boolean result = true;
        MainEntityType storeKeeperEntityType = EntityMetadataCache.getDataEntityType((String)"fa_storekeeper");
        IDataEntityType entryType = ((EntryProp)storeKeeperEntityType.getProperty("storekeeperentry")).getItemType();
        DataEntityPropertyCollection propertys = entryType.getProperties();
        IDataEntityProperty property = (IDataEntityProperty)propertys.get((Object)propertyName);
        result = property instanceof BasedataProp;
        return result;
    }
}

