/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.workload;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.opplugin.workload.FaWorkLoadAuditValidator;

public class FaWorkLoadAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FaWorkLoadAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("depreuse");
        fieldKeys.add("period");
        fieldKeys.add("realcard");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FaWorkLoadAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<String, OrgDepreUse2Real> orgDepreUse2RealMap = new HashMap<String, OrgDepreUse2Real>();
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject org = dataEntity.getDynamicObject("org");
            long orgId = org.getLong("id");
            DynamicObject depreUse = dataEntity.getDynamicObject("depreuse");
            long depreUseId = depreUse.getLong("id");
            DynamicObject period = dataEntity.getDynamicObject("period");
            long periodId = period.getLong("id");
            DynamicObject realCard = dataEntity.getDynamicObject("realcard");
            long realCardId = realCard.getLong("id");
            String key = String.format("[%s]_[%s]_[%s]", orgId, depreUseId, periodId);
            OrgDepreUse2Real orgDepreUse2Real = (OrgDepreUse2Real)orgDepreUse2RealMap.get(key);
            if (orgDepreUse2Real == null) {
                orgDepreUse2Real = new OrgDepreUse2Real();
                orgDepreUse2Real.setOrgId(orgId);
                orgDepreUse2Real.setDepreUseId(depreUseId);
                orgDepreUse2Real.setPeriodId(periodId);
                orgDepreUse2Real.getRealCardIds().add(realCardId);
                orgDepreUse2RealMap.put(key, orgDepreUse2Real);
                continue;
            }
            orgDepreUse2Real.getRealCardIds().add(realCardId);
        }
        for (OrgDepreUse2Real orgDepreUse2Real : orgDepreUse2RealMap.values()) {
            FaFinCardDaoFactory.getInstance().copyFinCards(orgDepreUse2Real.getPeriodId(), orgDepreUse2Real.getDepreUseId(), orgDepreUse2Real.getRealCardIds().toArray(), null, null, null);
        }
        ArrayList<DynamicObject> finCards = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject realCard;
            long realCardId;
            DynamicObject period;
            long periodId;
            DynamicObject depreUse;
            long depreUseId;
            DynamicObject org = dataEntity.getDynamicObject("org");
            long orgId = org.getLong("id");
            DynamicObject finCard = this.updateFinCard(orgId, depreUseId = (depreUse = dataEntity.getDynamicObject("depreuse")).getLong("id"), periodId = (period = dataEntity.getDynamicObject("period")).getLong("id"), realCardId = (realCard = dataEntity.getDynamicObject("realcard")).getLong("id"));
            if (finCard == null) continue;
            finCards.add(finCard);
        }
        SaveServiceHelper.update((DynamicObject[])finCards.toArray(new DynamicObject[0]));
    }

    private DynamicObject updateFinCard(long orgId, long depreUseId, long periodId, long realCardId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("bizperiod", "=", (Object)periodId), new QFilter("realcardmasterid", "=", (Object)realCardId), new QFilter("originaldata", "=", (Object)Boolean.FALSE)};
        DynamicObject finCard = BusinessDataServiceHelper.loadSingle((String)"fa_card_fin", (String)"isneeddepre", (QFilter[])filters);
        if (finCard == null) {
            logger.info(String.format("\u6839\u636e\u6838\u7b97\u7ec4\u7ec7\u3010%s\u3011\u3001\u6298\u65e7\u7528\u9014\u3010%s\u3011\u3001\u671f\u95f4\u3010%s\u3011\u3001\u5b9e\u7269\u5361\u7247\u3010%s\u3011\u672a\u67e5\u5230\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\u3002", orgId, depreUseId, periodId, realCardId));
            return null;
        }
        finCard.set("isneeddepre", (Object)Boolean.TRUE);
        return finCard;
    }

    static class OrgDepreUse2Real {
        private long orgId;
        private long depreUseId;
        private long periodId;
        private List<Long> realCardIds = new ArrayList<Long>(128);

        OrgDepreUse2Real() {
        }

        public long getOrgId() {
            return this.orgId;
        }

        public void setOrgId(long orgId) {
            this.orgId = orgId;
        }

        public long getDepreUseId() {
            return this.depreUseId;
        }

        public void setDepreUseId(long depreUseId) {
            this.depreUseId = depreUseId;
        }

        public long getPeriodId() {
            return this.periodId;
        }

        public void setPeriodId(long periodId) {
            this.periodId = periodId;
        }

        public List<Long> getRealCardIds() {
            return this.realCardIds;
        }

        public void setRealCardIds(List<Long> realCardIds) {
            this.realCardIds = realCardIds;
        }
    }
}

