/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.workload;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fa.opplugin.workload.FaWorkLoadBatchSaveValidator;

public class FaWorkLoadBatchSaveOp
extends AbstractOperationServicePlugIn {
    static final String KEY_BATCH_SAVE = "key_batch_save";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("depreuse");
        fieldKeys.add("period");
        fieldKeys.add("workloadentry.realcard");
        fieldKeys.add("workloadentry.workload");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FaWorkLoadBatchSaveValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(10);
        for (DynamicObject entity : dataEntities) {
            DynamicObject org = entity.getDynamicObject("org");
            DynamicObject depreUse = entity.getDynamicObject("depreuse");
            DynamicObject period = entity.getDynamicObject("period");
            Date date = entity.getDate("date");
            DynamicObjectCollection entry = entity.getDynamicObjectCollection("workloadentry");
            for (DynamicObject row : entry) {
                DynamicObject realCard = row.getDynamicObject("realcard");
                BigDecimal workLoad = row.getBigDecimal("workload");
                DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"fa_workload");
                dyn.set("billstatus", (Object)"A");
                dyn.set("org", (Object)org);
                dyn.set("depreuse", (Object)depreUse);
                dyn.set("period", (Object)period);
                dyn.set("date", (Object)date);
                dyn.set("realcard", (Object)realCard);
                dyn.set("workload", (Object)workLoad);
                dyn.set("workloadunitid", (Object)row.getDynamicObject("workloadunitid"));
                saveData.add(dyn);
            }
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue(KEY_BATCH_SAVE, "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"fa_workload", (DynamicObject[])saveData.toArray(new DynamicObject[0]), (OperateOption)operateOption);
        if (!result.isSuccess()) {
            throw new KDBizException(result.getMessage());
        }
    }
}

