/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.workload;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.workload.FaWorkLoadAuditValidator;

public class FaWorkLoadUnAuditValidator
extends FaWorkLoadAuditValidator {
    @Override
    public void validate() {
        HashMap<String, Boolean> orgIdDepreUseIdPeriodId2haVoucher = new HashMap<String, Boolean>(16);
        HashMap<Long, Boolean> orgId2SumMutilVou = new HashMap<Long, Boolean>(this.dataEntities.length);
        for (ExtendedDataEntity entity : this.dataEntities) {
            Set billNumbers;
            boolean hasDepreSumGenVoucher;
            DynamicObject dyn = entity.getDataEntity();
            String cardNumber = dyn.getDynamicObject("realcard").getString("number");
            Optional<String> checkResult = this.checkFutureBiz(dyn);
            if (checkResult.isPresent()) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%s\uff1a\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff1a", (String)"FaWorkLoadUnAuditValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), cardNumber) + checkResult.get());
                continue;
            }
            boolean beforeCurPeriod = super.isCurPeriod(dyn);
            if (!beforeCurPeriod) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%s\uff1a\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u53ea\u80fd\u53cd\u5ba1\u6838\u5f53\u524d\u671f\u95f4\u7684\u6570\u636e\u3002", (String)"FaWorkLoadUnAuditValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), cardNumber));
            }
            boolean enableSumMutilVoucher = false;
            Long orgId = dyn.getLong("org.id");
            if (orgId2SumMutilVou.get(orgId) != null) {
                enableSumMutilVoucher = (Boolean)orgId2SumMutilVou.get(orgId);
            } else {
                enableSumMutilVoucher = SystemParamHelper.getBooleanParam((String)"enable_sum_mutil_voucher", (long)orgId, (boolean)false);
                orgId2SumMutilVou.put(orgId, enableSumMutilVoucher);
            }
            if (!enableSumMutilVoucher && (hasDepreSumGenVoucher = super.hasDepreSumGenVoucher(dyn))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%s\uff1a\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\u3002", (String)"FaWorkLoadUnAuditValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), cardNumber));
            }
            DynamicObject depreUse = dyn.getDynamicObject("depreuse");
            long depreUseId = depreUse.getLong("id");
            DynamicObject period = dyn.getDynamicObject("period");
            long periodId = period.getLong("id");
            StringBuilder sb = new StringBuilder();
            sb.append(orgId).append("_").append(depreUseId).append("_").append(periodId);
            boolean isHasvoucher = false;
            if (orgIdDepreUseIdPeriodId2haVoucher.get(sb.toString()) != null) {
                isHasvoucher = (Boolean)orgIdDepreUseIdPeriodId2haVoucher.get(sb.toString());
            } else {
                isHasvoucher = FaDepreUtil.hasVoucher((Long)orgId, (Long)depreUseId, (Long)periodId, (boolean)Boolean.FALSE);
                orgIdDepreUseIdPeriodId2haVoucher.put(sb.toString(), isHasvoucher);
            }
            if (isHasvoucher) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%s\uff1a\u5ba1\u6838\u5931\u8d25\uff0c\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\u3002", (String)"FaWorkLoadUnAuditValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), cardNumber));
            }
            DynamicObject assetBook = FaAssetBookDaoFactory.getInstance().queryMainBookByOrg((Object)orgId);
            DynamicObject curPeriodDy = assetBook.getDynamicObject("curperiod");
            Date endDate = curPeriodDy.getDate("enddate");
            HashMap<Long, String> realId2numberMap = new HashMap<Long, String>(1, 1.0f);
            realId2numberMap.put(dyn.getLong(Fa.id((String)"realcard")), dyn.getString("realcard.number"));
            Set billNos = FaChangeBillUtil.getGenVoucherChangeBillNo((Long)orgId, (Date)endDate, realId2numberMap.keySet());
            if (billNos != null && billNos.size() > 0) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u5728\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u53d8\u66f4\u5355%s\u5df2\u751f\u6210\u51ed\u8bc1\u3002", (String)"FaWorkLoadUnAuditValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNos.toString()));
            }
            if ((billNumbers = FaChangeBillUtil.checkhaveFutureRealChangeBill((Long)orgId, (Date)endDate, realId2numberMap)) == null || billNumbers.size() <= 0) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801%s\u5b58\u5728\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\uff0c\u5f00\u542f\"\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\"\u76f8\u5e94\u53c2\u6570\u6216\u5220\u9664\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u3002", (String)"FaWorkLoadUnAuditValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNumbers.toString()));
        }
    }

    private Optional<String> checkFutureBiz(DynamicObject dyn) {
        long orgId = dyn.getDynamicObject("org").getLong("id");
        HashSet<Long> realCardIdSet = new HashSet<Long>(4);
        long realCardId = dyn.getDynamicObject("realcard").getLong("id");
        realCardIdSet.add(realCardId);
        Date date = dyn.getDate("date");
        return new FutureBizChecker(null, (Object)orgId, realCardIdSet, date, BusyTypeDetailEnum.FIN_CHG).check();
    }
}

