/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.dao.factory.FaBillDaoFactory;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaBizUtils;

public class FaOpQueryUtils {
    public static final String ALGOKEY = "kd.fi.fa.utils.FaOpQueryUtils";
    public static final String TABAP = "tabap";
    public static final String SOURCEBILLID = "sourcebillid";
    public static final String AI_DAPTRACKER = "ai_daptracker";
    public static final String VOUCHERID = "voucherid";
    public static final String BILLNO = "billno";
    public static final String ID = "id";
    public static final String GL_VOUCHER = "gl_voucher";
    public static final String FA_CLRBILL = "fa_clrbill";

    public static Boolean isFieldEmpty(IDataModel model, String field) {
        DynamicObject dynObj = model.getDataEntity();
        if (dynObj == null || dynObj.get(field) == null) {
            return true;
        }
        return false;
    }

    public static String removeString_id(String str) {
        if (str.length() > 3 && str.substring(str.length() - 3, str.length()).equalsIgnoreCase("_id")) {
            return str.substring(0, str.length() - 3);
        }
        return str;
    }

    public static Boolean isZero(Object num) {
        if (Pattern.matches("(0+\\.0*)|(0+)", num.toString())) {
            return true;
        }
        return false;
    }

    public static String parseDateByFormatString(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simple = new SimpleDateFormat(format);
        return simple.format(date);
    }

    public static Object[] getSelectedPks(IFormView view) {
        Object[] pkArr = null;
        ListSelectedRowCollection selectedRows = ((IListView)view).getSelectedRows();
        if (selectedRows.size() > 0) {
            pkArr = new Object[selectedRows.size()];
            for (int i = 0; i < selectedRows.size(); ++i) {
                ListSelectedRow selectedRow = selectedRows.get(i);
                pkArr[i] = selectedRow.getPrimaryKeyValue();
            }
        } else {
            pkArr = new Object[]{};
        }
        return pkArr;
    }

    public static boolean isF7(IFormView view) {
        ListShowParameter listShowParameter = (ListShowParameter)view.getFormShowParameter();
        return listShowParameter.isLookUp();
    }

    public static void showTabForm(String formId, String formName, Object pkValue, IFormView view) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(pkValue);
        parameter.setCaption(formName);
        parameter.getOpenStyle().setTargetKey(TABAP);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId(formId);
        view.showForm((FormShowParameter)parameter);
    }

    public static Object getRowPk(Object rowPk) {
        String rowPkv = rowPk.toString();
        return FaOpQueryUtils.getVouncherId(rowPkv);
    }

    public static Object getRowRealCardNo(int rowIndex, IFormView view) {
        ListSelectedRow selectedRow = ((IListView)view).getCurrentListAllRowCollection().get(rowIndex);
        String rowPk = selectedRow.getPrimaryKeyValue().toString();
        String rowEntryPk = selectedRow.getEntryPrimaryKeyValue().toString();
        return FaOpQueryUtils.getRealCardId(rowPk, rowEntryPk);
    }

    public static String getVouncherId(String fid) {
        String voucherId = "";
        QFilter filterRe = new QFilter(SOURCEBILLID, "=", (Object)Long.parseLong(fid));
        QFilter[] filterRes = new QFilter[]{filterRe};
        ORM orm = ORM.create();
        DynamicObjectCollection listDO = orm.query(AI_DAPTRACKER, filterRes);
        DynamicObject relation = null;
        if (listDO == null || listDO.size() == 0) {
            return voucherId;
        }
        relation = (DynamicObject)listDO.get(0);
        String voucherid = relation.getString(VOUCHERID);
        return voucherid;
    }

    public static String getRealCardId(String fid, String rowEntryPk) {
        if (StringUtils.isEmpty((CharSequence)fid)) {
            return null;
        }
        ORM.create();
        DynamicObject realcardId = BusinessDataServiceHelper.loadSingle((Object)fid, (String)"fa_clearbill");
        DynamicObjectCollection entrys = (DynamicObjectCollection)realcardId.get("detail_entry");
        String realCardPk = "";
        for (DynamicObject entry : entrys) {
            if (!rowEntryPk.equals(String.valueOf(entry.getPkValue()))) continue;
            DynamicObject realCard = entry.getDynamicObject("realcard");
            realCardPk = String.valueOf(realCard.getPkValue());
            break;
        }
        return realCardPk;
    }

    public static Map<String, String> getVouncherNumber(List<String> fids) {
        if (CollectionUtils.isEmpty(fids)) {
            return null;
        }
        HashMap<String, String> returnMap = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        sb.append(" select ai.FSOURCEBILLID as id,gl.FNUMBER as vounchernumber");
        sb.append(" from t_ai_daptracker ai LEFT JOIN t_gl_voucher gl");
        sb.append(" on ai.FVOUCHERID = gl.FID");
        sb.append(" where ai.FSOURCEBILLID in (");
        for (String string : fids) {
            sb.append(string);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        try (DataSet ds = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)"fa"), (String)sb.toString(), null);){
            for (Row row : ds) {
                returnMap.put(row.getString(ID), row.getString("vounchernumber"));
            }
            HashMap<String, String> hashMap = returnMap;
            return hashMap;
        }
    }

    public static String getDefaultOrgId(List<ComboItem> items) {
        Long currOrgId = RequestContext.get().getOrgId();
        for (int i = 0; i < items.size(); ++i) {
            Long nextId;
            if (null == items.get(i) || items.get(i).getValue().length() == 0 || (nextId = Long.valueOf(Long.parseLong(items.get(i).getValue()))).longValue() != currOrgId.longValue()) continue;
            return currOrgId.toString();
        }
        String defaultStr = items.get(0).getValue();
        return defaultStr;
    }

    public static DynamicObject getPeriodByDate(Date date, long periodType) {
        String selectField = "id,periodtype.id,periodyear,periodnumber,begindate,enddate,isadjustperiod,number,name";
        DynamicObjectCollection period = FaOpQueryUtils.getPeriodByDate(date, selectField, periodType);
        if (!period.isEmpty()) {
            return (DynamicObject)period.get(0);
        }
        return null;
    }

    public static DynamicObjectCollection getPeriodByDate(Date date, String selectField, long periodType) {
        QFilter f = new QFilter("beginDate", "<=", (Object)date);
        QFilter g = new QFilter("enddate", ">=", (Object)date);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        return QueryServiceHelper.query((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t}, (String)"number");
    }

    public static DynamicObjectCollection getFincardByOrgAndDepreuse(long org, long depreuse) {
        QFilter orgFil = new QFilter("org", "=", (Object)org);
        QFilter depreuseFil = new QFilter("depreuse", "=", (Object)depreuse);
        QFilter endperiodFil = new QFilter("endperiod", "=", (Object)99999999999L);
        DynamicObjectCollection fincard = QueryServiceHelper.query((String)"fa_card_fin", (String)ID, (QFilter[])new QFilter[]{orgFil, depreuseFil, endperiodFil});
        return fincard;
    }

    public static DynamicObject getMainBookByOrg(Long orgId) {
        QFilter mainF = new QFilter("ismainbook", "=", (Object)"1");
        QFilter orgF = new QFilter("org", "=", (Object)orgId);
        DynamicObject mainBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"id,periodtype,basecurrency,curperiod,startperiod,depresystem", (QFilter[])new QFilter[]{mainF, orgF});
        return mainBook;
    }

    public static List<Long> getCurRealCard(Date date, Long orgId) {
        return FaOpQueryUtils.getCurRealCard(date, orgId, Boolean.FALSE);
    }

    public static List<Long> getCurRealCard(Date date, Long orgId, Boolean includeBef) {
        DynamicObject mainBook = FaOpQueryUtils.getMainBookByOrg(orgId);
        if (mainBook == null) {
            return null;
        }
        long periodType = mainBook.getLong("periodtype");
        DynamicObject period = FaOpQueryUtils.getPeriodByDate(date, periodType);
        if (period == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u6570\u636e\u5f02\u5e38,\u8bf7\u68c0\u67e5! \u65e5\u671f\uff1a%s", (String)"FaOpQueryUtils_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), date));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        if (!includeBef.booleanValue()) {
            filters.add(new QFilter("bizperiod", "<=", period.get(ID)));
        }
        filters.add(new QFilter("endperiod", ">=", period.get(ID)));
        QFilter[] filterArr = filters.toArray(new QFilter[0]);
        DynamicObjectCollection cards = QueryServiceHelper.query((String)"fa_card_fin", (String)"realcard", (QFilter[])filterArr);
        ArrayList<Long> cardList = new ArrayList<Long>();
        for (DynamicObject card : cards) {
            cardList.add(card.getLong("realcard"));
        }
        return cardList;
    }

    @Deprecated
    public static Set<Long> getCurRealCard(Date date, Long orgId, Boolean includeBef, Set<Long> readCardIds, BusyTypeDetailEnum busyType) {
        HashSet<Long> existsIds = new HashSet<Long>();
        DynamicObject mainBook = FaOpQueryUtils.getMainBookByOrg(orgId);
        if (mainBook == null) {
            return existsIds;
        }
        long periodType = mainBook.getLong("periodtype");
        DynamicObject period = FaOpQueryUtils.getPeriodByDate(date, periodType);
        if (period == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u6570\u636e\u5f02\u5e38,\u8bf7\u68c0\u67e5! \u65e5\u671f\uff1a%s", (String)"FaOpQueryUtils_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), date));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("endperiod", ">", period.get(ID)));
        filters.add(new QFilter("realcard", "in", readCardIds));
        filters.add(new QFilter("finaccountdate", "<=", (Object)period.getDate("enddate")));
        QFilter[] filterArr = filters.toArray(new QFilter[0]);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fa_card_fin", (String)"fa_card_fin", (String)"realcard", (QFilter[])filterArr, null);){
            while (ds.hasNext()) {
                existsIds.add(ds.next().getLong("realcard"));
            }
        }
        Set futureBizRealCards = new FutureBizChecker(null, (Object)orgId, new HashSet<Long>(readCardIds), date, busyType).checkAndReturnRealCard();
        existsIds.removeAll(futureBizRealCards);
        return existsIds;
    }

    @Deprecated
    public static Set<Long> getCurRealCard(Date date, Long orgId, Boolean includeBef, Set<Long> readCardIds) {
        return FaOpQueryUtils.getCurRealCard(date, orgId, includeBef, readCardIds, BusyTypeDetailEnum.REAL_FIN_CHG);
    }

    public static void showErrorRealCardMsg(int errCount, String msg, DynamicObject card, IFormView view) {
        if (card != null) {
            msg = card.getString(BILLNO);
        }
        String part1 = ResManager.loadKDString((String)"\u4e0b\u5217\u5361\u7247", (String)"FaOpQueryUtils_1", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        String part2 = ResManager.loadKDString((String)"\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\u6216\u8005\u662f\u672a\u6765\u671f\u95f4\u5165\u8d26\u7684\u5361\u7247\uff0c\u4e0d\u53ef\u505a\u5f53\u524d\u4e1a\u52a1", (String)"FaOpQueryUtils_2", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        String part3 = ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\uff1a", (String)"FaOpQueryUtils_3", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        if (errCount == 1) {
            view.showErrorNotification(part3 + msg + " " + part2);
        } else {
            view.showMessage(part1 + part2, part3 + msg, MessageTypes.Default);
        }
    }

    public static List<DynamicObject> getRealCard(List<String> asseNums) {
        ArrayList<DynamicObject> cardList = new ArrayList<DynamicObject>();
        if (asseNums.size() == 0) {
            return cardList;
        }
        QFilter[] filters = FaOpQueryUtils.getRealCardByAsseNumfilters(asseNums);
        DynamicObject[] realCards = FaBillDaoFactory.getInstance((String)"fa_card_real").query(filters);
        cardList = new ArrayList<DynamicObject>(Arrays.asList(realCards));
        return cardList;
    }

    private static QFilter[] getRealCardByAsseNumfilters(List<String> asseNums) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", asseNums), new QFilter("isbak", "=", (Object)Character.valueOf('0')), new QFilter("bizstatus", "=", (Object)BizStatusEnum.READY), new QFilter("billstatus", "=", (Object)BillStatus.C)};
        return filters;
    }

    public static List<DynamicObject> queryFinCards(Set<Object> realCardPKSet) {
        return FaOpQueryUtils.queryFinCardList(realCardPKSet, null);
    }

    public static List<DynamicObject> queryFinCardList(Set<Object> realCardPKSet, Set<String> curstoms) {
        HashSet realCardSet = new HashSet(realCardPKSet.size());
        realCardPKSet.forEach(r -> realCardSet.add(Long.parseLong(String.valueOf(r))));
        QFilter[] filters = new QFilter[]{new QFilter("realcardmasterid", "in", realCardSet)};
        String[] fieldArr = new String[]{ID, "realcard", "currency", "number", FaDaoOrmImpl.dot((String[])new String[]{"realcard", "usestatus", "isdepre"}), "realcardmasterid", "originalval", "accumdepre", "decval", "netamount", "preresidualval", "preusingamount", FaDaoOrmImpl.dot((String[])new String[]{"assetbook", "basecurrency"}), FaDaoOrmImpl.dot((String[])new String[]{"assetbook", "curperiod", ID}), "depreuse", "isneeddepre", "bizperiod", "endperiod", "monthdepre", "networth", "addupyeardepre", "depremethod", "assetcat", "isdynamic", "monthorigvalchg", "monthdeprechg", "yearorigvalchg"};
        HashSet<String> fieldSet = new HashSet<String>();
        fieldSet.addAll(Arrays.asList(fieldArr));
        if (curstoms != null) {
            fieldSet.addAll(curstoms);
        }
        String selector = String.join((CharSequence)",", fieldSet);
        DynamicObject[] finCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selector, (QFilter[])filters, (String)"depreuse asc");
        Set bookIdSet = Stream.of(finCards).map(v -> v.get("assetbook_id")).collect(Collectors.toSet());
        selector = FaDaoOrmImpl.comma((String[])new String[]{ID, "curperiod"});
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)selector, (QFilter[])new QFilter(ID, "in", bookIdSet).toArray());
        Map<Object, Long> bookMap = books.stream().collect(Collectors.toMap(v -> v.get(ID), v -> v.getLong("curperiod")));
        List<DynamicObject> finCardLst = Stream.of(finCards).filter(fincard -> FaOpQueryUtils.filterFinCards((Long)bookMap.get(fincard.get("assetbook_id")), fincard)).collect(Collectors.toList());
        return finCardLst;
    }

    public static List<DynamicObject> queryFinCards(Set<Object> realCardPKSet, Long depreuseId) {
        HashSet realCardSet = new HashSet(realCardPKSet.size());
        realCardPKSet.forEach(r -> realCardSet.add(Long.parseLong(String.valueOf(r))));
        QFilter[] filters = new QFilter[]{new QFilter("realcardmasterid", "in", realCardSet), new QFilter("depreuse", "=", (Object)depreuseId)};
        String selector = FaDaoOrmImpl.comma((String[])new String[]{ID, "realcard", "currency", FaDaoOrmImpl.dot((String[])new String[]{"realcard", "usestatus", "isdepre"}), "originalval", "accumdepre", "decval", "netamount", "preresidualval", "preusingamount", FaDaoOrmImpl.dot((String[])new String[]{"assetbook", "basecurrency"}), FaDaoOrmImpl.dot((String[])new String[]{"assetbook", "curperiod", ID}), "depreuse", "isneeddepre", "bizperiod", "endperiod", "monthdepre", "networth", "addupyeardepre", "yearorigvalchg", "monthorigvalchg", "monthdeprechg", "depredamount", "depremethod", "assetcat"});
        DynamicObject[] finCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selector, (QFilter[])filters);
        Set bookIdSet = Stream.of(finCards).map(v -> v.get("assetbook_id")).collect(Collectors.toSet());
        selector = FaDaoOrmImpl.comma((String[])new String[]{ID, "curperiod"});
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)selector, (QFilter[])new QFilter(ID, "in", bookIdSet).toArray());
        Map<Object, Long> bookMap = books.stream().collect(Collectors.toMap(v -> v.get(ID), v -> v.getLong("curperiod")));
        List<DynamicObject> finCardLst = Stream.of(finCards).filter(fincard -> FaOpQueryUtils.filterFinCards((Long)bookMap.get(fincard.get("assetbook_id")), fincard)).collect(Collectors.toList());
        return finCardLst;
    }

    private static boolean filterFinCards(long curPeriodId, DynamicObject fincard) {
        boolean isRight;
        DynamicObject bizPeriodDyn = fincard.getDynamicObject("bizperiod");
        long bizPeriodId = 0L;
        if (bizPeriodDyn != null) {
            bizPeriodId = fincard.getDynamicObject("bizperiod").getLong(ID);
        }
        long endPeriodId = 99999999999L;
        DynamicObject endPeriod = fincard.getDynamicObject("endperiod");
        if (endPeriod != null) {
            endPeriodId = endPeriod.getLong(ID);
        }
        boolean bl = isRight = bizPeriodId <= curPeriodId && curPeriodId < endPeriodId;
        if (isRight) {
            if (bizPeriodId < curPeriodId) {
                fincard.set("monthorigvalchg", (Object)BigDecimal.ZERO);
                fincard.set("monthdeprechg", (Object)BigDecimal.ZERO);
            }
            if (bizPeriodId / FaBizUtils.YEAR_PERIOD_L < curPeriodId / FaBizUtils.YEAR_PERIOD_L) {
                fincard.set("yearorigvalchg", (Object)BigDecimal.ZERO);
                fincard.set("addupyeardepre", (Object)BigDecimal.ZERO);
            }
        }
        return isRight;
    }

    public static DynamicObject getFinCardByNumberOrgAndDepreuse(String realNumber, long org, long depreuse) {
        QFilter realNumberFil = new QFilter("number", "=", (Object)realNumber);
        QFilter orgFil = new QFilter("org", "=", (Object)org);
        QFilter depreuseFil = new QFilter("depreuse", "=", (Object)depreuse);
        QFilter endPeriodFil = new QFilter("endperiod", "=", (Object)99999999999L);
        QFilter[] filters = new QFilter[]{realNumberFil, orgFil, depreuseFil, endPeriodFil};
        DynamicObject finCard = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)ID, (QFilter[])filters);
        return finCard;
    }

    public static void showDepreAnalyzeButton(final AbstractFormPlugin formPlugin, final String key) {
        AbstractGrid grid = (AbstractGrid)formPlugin.getControl(key);
        grid.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent p0) {
                IPageCache pageCache = formPlugin.getPageCache();
                if (pageCache.get(key) == null) {
                    pageCache.put(key, System.currentTimeMillis() + ":" + 1);
                } else {
                    String[] arr = pageCache.get(key).split(":");
                    if (Integer.parseInt(arr[1]) >= 5) {
                        if (System.currentTimeMillis() - Long.parseLong(arr[0]) < 3000L) {
                            formPlugin.getView().setVisible(Boolean.valueOf(true), new String[]{"fetchdepreinfo"});
                        }
                        pageCache.remove(key);
                    } else {
                        pageCache.put(key, arr[0] + ":" + (Integer.parseInt(arr[1]) + 1));
                    }
                }
            }

            public void cellDoubleClick(CellClickEvent p0) {
            }
        });
    }
}

