/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.dao.factory.FaBillDaoFactory;
import kd.fi.fa.business.dao.factory.FaBizDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.operate.FaOpCmdUtils;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.business.utils.FunctionMutexHelperV2Utils;
import kd.fi.fa.common.util.Fa;

public class FaOpUtils {
    private static final String AUDITDATE = "auditdate";

    public static void checkDoOperable(DynamicObject dataEntity, String entryName, String cardIdName, String entityName, BusyTypeDetailEnum busyType) {
        String dataEntrtyName = dataEntity.getDataEntityType().getName();
        Object[] newAddRealCardPKs = FaOpUtils.checkFutureBiz(dataEntity, entryName, cardIdName, FaOpUtils.getDateNameByEntryType(dataEntrtyName), busyType);
        if (FaCommonUtils.isEmpty((Object[])newAddRealCardPKs)) {
            return;
        }
        ArrayList<String> errorList = new ArrayList<String>();
        boolean isOperable = FaOpCmdUtils.isDoOperable((DynamicObject)dataEntity, (Object[])newAddRealCardPKs, errorList);
        if (!isOperable) {
            throw new KDBizException(new ErrorCode("UNKNOWN_ERR", FaOpUtils.handleError(errorList)), new Object[0]);
        }
    }

    public static void checkDoOperable(DynamicObject dataEntity, String entryName, String cardIdName, String entityName) {
        String dataEntrtyName = dataEntity.getDataEntityType().getName();
        Object[] newAddRealCardPKs = FaOpUtils.checkFutureBiz(dataEntity, entryName, cardIdName, FaOpUtils.getDateNameByEntryType(dataEntrtyName), BusyTypeDetailEnum.REAL_FIN_CHG);
        if (FaCommonUtils.isEmpty((Object[])newAddRealCardPKs)) {
            return;
        }
        ArrayList<String> errorList = new ArrayList<String>();
        boolean isOperable = FaOpCmdUtils.isDoOperable((DynamicObject)dataEntity, (Object[])newAddRealCardPKs, errorList);
        if (!isOperable) {
            throw new KDBizException(new ErrorCode("UNKNOWN_ERR", FaOpUtils.handleError(errorList)), new Object[0]);
        }
    }

    @Deprecated
    public static void checkDoOperable(DynamicObject dataEntity, String entryName, String cardIdName, String entityName, Map<Long, DynamicObject> orgAssetbook, BusyTypeDetailEnum busyType) {
        String dataEntrtyName = dataEntity.getDataEntityType().getName();
        Object[] newAddRealCardPKs = FaOpUtils.checkFutureBiz(dataEntity, entryName, cardIdName, FaOpUtils.getDateNameByEntryType(dataEntrtyName), busyType);
        if (FaCommonUtils.isEmpty((Object[])newAddRealCardPKs)) {
            return;
        }
    }

    @Deprecated
    public static void checkDoOperable(DynamicObject dataEntity, String entryName, String cardIdName, String entityName, Map<Long, DynamicObject> orgAssetbook) {
        String dataEntrtyName = dataEntity.getDataEntityType().getName();
        Object[] newAddRealCardPKs = FaOpUtils.checkFutureBiz(dataEntity, entryName, cardIdName, FaOpUtils.getDateNameByEntryType(dataEntrtyName), BusyTypeDetailEnum.REAL_FIN_CHG);
        if (FaCommonUtils.isEmpty((Object[])newAddRealCardPKs)) {
            return;
        }
    }

    public static void checkUndoOperable(DynamicObject dataEntity, String entityName, String entryName, BusyTypeDetailEnum busyType) {
        FaOpUtils.checkFutureBizWhenun(dataEntity, entryName, "realcard.masterid", AUDITDATE, busyType);
        ArrayList<String> errorList = new ArrayList<String>();
        boolean isOperable = FaOpCmdUtils.isUndoOperable((Object)dataEntity.getPkValue(), (String)entityName, errorList);
        if (!isOperable) {
            throw new KDBizException(FaOpUtils.handleError(errorList));
        }
    }

    @Deprecated
    public static void checkUndoOperable(DynamicObject dataEntity, String entityName, String entryName) {
        FaOpUtils.checkFutureBizWhenun(dataEntity, entryName, "realcard.masterid", AUDITDATE, BusyTypeDetailEnum.REAL_FIN_CHG);
        ArrayList<String> errorList = new ArrayList<String>();
        boolean isOperable = FaOpCmdUtils.isUndoOperable((Object)dataEntity.getPkValue(), (String)entityName, errorList);
        if (!isOperable) {
            throw new KDBizException(FaOpUtils.handleError(errorList));
        }
    }

    private static Object[] checkFutureBiz(DynamicObject dataEntity, String entryName, String cardIdName, String dateName, BusyTypeDetailEnum busyType) {
        Object[] realCardIds = FaOpUtils.getAllRealCardByBill(dataEntity, entryName, cardIdName);
        HashSet<Object> realCardPkSet = new HashSet<Object>(Arrays.asList(realCardIds));
        Object orgId = dataEntity.get("org.id");
        Optional checkResult = new FutureBizChecker(dataEntity.getPkValue(), orgId, realCardPkSet, dataEntity.getDate(dateName), busyType).check();
        if (checkResult.isPresent()) {
            String msg = String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff1a%s\u3002", (String)"FaOpUtils_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), checkResult.get());
            throw new KDBizException(msg);
        }
        return realCardPkSet.toArray();
    }

    private static Object[] checkFutureBizWhenun(DynamicObject dataEntity, String entryName, String cardIdName, String dateName, BusyTypeDetailEnum busyType) {
        Object[] realCardIds = FaOpUtils.getAllRealCardByBill(dataEntity, entryName, cardIdName);
        HashSet<Object> realCardPkSet = new HashSet<Object>(Arrays.asList(realCardIds));
        Object orgId = dataEntity.get("org.id");
        Optional checkResult = new FutureBizChecker(dataEntity.getPkValue(), orgId, realCardPkSet, dataEntity.getDate(dateName), busyType).checkWhenun();
        if (checkResult.isPresent()) {
            String msg = String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff1a%s\u3002", (String)"FaOpUtils_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), checkResult.get());
            throw new KDBizException(msg);
        }
        return realCardPkSet.toArray();
    }

    public static void checkFutureBizWhenUnaudit4Change(DynamicObject dataEntity, String entityName, String entryName, BusyTypeDetailEnum busyType) {
        Object[] realCardIds = FaOpUtils.getAllRealCardByBill(dataEntity, entryName, "realcard.masterid");
        HashSet<Object> realCardPkSet = new HashSet<Object>(Arrays.asList(realCardIds));
        Object orgId = dataEntity.get("org.id");
        FutureBizChecker futureBizChecker = new FutureBizChecker(dataEntity.getPkValue(), orgId, realCardPkSet, dataEntity.getDate(AUDITDATE), busyType);
        futureBizChecker.setChangeBillChangeDate(dataEntity.getDate("changedate"));
        Optional checkResult = futureBizChecker.checkWhenun();
        if (checkResult.isPresent()) {
            String msg = String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff1a%s\u3002", (String)"FaOpUtils_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), checkResult.get());
            throw new KDBizException(msg);
        }
        ArrayList<String> errorList = new ArrayList<String>();
        boolean isOperable = FaOpCmdUtils.isUndoOperable((Object)dataEntity.getPkValue(), (String)entityName, errorList);
        if (!isOperable) {
            throw new KDBizException(FaOpUtils.handleError(errorList));
        }
    }

    public static Long[] objsToLongs(Object[] objs) {
        Long[] l = new Long[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            l[i] = Long.valueOf(objs[i].toString());
        }
        return l;
    }

    public static Set<Object> getAllRealCardIdsByMasterid(Object[] masterids) {
        QFilter masterIdFilter = new QFilter("masterid", "in", (Object)masterids);
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)"id", (QFilter[])new QFilter[]{masterIdFilter});
        HashSet<Object> realCardIds = new HashSet<Object>();
        for (DynamicObject realCard : realCards) {
            realCardIds.add(realCard.getLong("id"));
        }
        return realCardIds;
    }

    public static String getDateNameByEntryType(String dataEntrtyName) {
        if ("fa_change_dept".equals(dataEntrtyName)) {
            return "changedate";
        }
        if ("fa_clearbill".equals(dataEntrtyName) || "fa_clearapplybill".equals(dataEntrtyName)) {
            return "cleardate";
        }
        if ("fa_dispatch".equals(dataEntrtyName)) {
            return "dispatchdate";
        }
        if ("fa_asset_devalue".equals(dataEntrtyName)) {
            return "businessdate";
        }
        if ("fa_recalculate".equals(dataEntrtyName)) {
            return "bizdate";
        }
        if ("fa_assetsplitbill".equals(dataEntrtyName)) {
            return "splitdate";
        }
        if ("fa_restartrealbill".equals(dataEntrtyName)) {
            return "restartdate";
        }
        return "";
    }

    public static void doOp(BeginOperationTransactionArgs e, String entityName) {
        String operationKey = e.getOperationKey();
        FunctionMutexHelperV2Utils.doFaOpWithWithOrgPcChildLock4Cmd((String)operationKey, (String)entityName, (DynamicObject[])e.getDataEntities(), null, null);
    }

    public static void undoOp(BeginOperationTransactionArgs e, String entityName) {
        String operationKey = e.getOperationKey();
        FunctionMutexHelperV2Utils.doFaOpWithWithOrgPcChildLock4Cmd((String)operationKey, (String)entityName, (DynamicObject[])e.getDataEntities(), null, null);
    }

    public static void updateBizStatus4Save(BeginOperationTransactionArgs e, String entryName, String cardIdName, BizStatusEnum bizStatus) {
        for (DynamicObject dataEntity : FaOpUtils.getDataEntities(e)) {
            FaRealCardDaoFactory.getInstance().batchUpdateBizStatus(FaOpUtils.getRealCardByBill(dataEntity, entryName, cardIdName), bizStatus);
            FaRealCardDaoFactory.getInstance().batchUpdateBizStatus(FaOpUtils.getNewDeleteRealCard(dataEntity, entryName, cardIdName), BizStatusEnum.READY);
        }
    }

    public static void updateBizStatus4Delete(BeginOperationTransactionArgs e, String entryName, String cardIdName, BizStatusEnum bizStatus) {
        for (DynamicObject dataEntity : FaOpUtils.getDataEntities(e)) {
            Boolean isSkip = FaOpUtils.skipUpdateBizStatus4Delete(dataEntity);
            if (isSkip.booleanValue()) continue;
            FaRealCardDaoFactory.getInstance().batchUpdateBizStatus(FaOpUtils.getRealCardByBill(dataEntity, entryName, cardIdName), bizStatus);
        }
    }

    private static Boolean skipUpdateBizStatus4Delete(DynamicObject dataEntity) {
        Boolean result = false;
        String billName = dataEntity.getDataEntityType().getName();
        if (billName.equalsIgnoreCase("fa_clearbill") && !FaClearSourceEnum.ADDNEW.toString().equalsIgnoreCase(dataEntity.getString("clearsource")) && !FaClearSourceEnum.INVENTORY_LOSS.toString().equalsIgnoreCase(dataEntity.getString("clearsource"))) {
            result = true;
        }
        return result;
    }

    public static void updateBizStatus(BeginOperationTransactionArgs e, String cardIdName, BizStatusEnum bizStatus) {
        for (DynamicObject dataEntity : FaOpUtils.getDataEntities(e)) {
            Object realCardPK = FaOpUtils.reloadDataIfNull(dataEntity, cardIdName);
            FaRealCardDaoFactory.getInstance().updateBizStatus(realCardPK, bizStatus);
        }
    }

    public static List<DynamicObject> getDataEntities(BeforeOperationArgs e) {
        ArrayList<DynamicObject> dobjList = new ArrayList<DynamicObject>();
        if (e.getDataEntities() != null) {
            dobjList.addAll(Arrays.asList(e.getDataEntities()));
        }
        return dobjList;
    }

    public static List<DynamicObject> getDataEntities(AfterOperationArgs e) {
        ArrayList<DynamicObject> dobjList = new ArrayList<DynamicObject>();
        if (e.getDataEntities() != null) {
            dobjList.addAll(Arrays.asList(e.getDataEntities()));
        }
        return dobjList;
    }

    public static List<DynamicObject> getDataEntities(BeginOperationTransactionArgs e) {
        ArrayList<DynamicObject> dobjList = new ArrayList<DynamicObject>();
        if (e.getDataEntities() != null) {
            dobjList.addAll(Arrays.asList(e.getDataEntities()));
        }
        return dobjList;
    }

    public static List<DynamicObject> getDataEntities(EndOperationTransactionArgs e) {
        ArrayList<DynamicObject> dobjList = new ArrayList<DynamicObject>();
        if (e.getDataEntities() != null) {
            dobjList.addAll(Arrays.asList(e.getDataEntities()));
        }
        return dobjList;
    }

    public static void depreciate(BeginOperationTransactionArgs e, String entryName) {
        Set cardIdSet = FaOpUtils.getDataEntities(e).stream().flatMap(v -> ((DynamicObjectCollection)FaOpUtils.reloadDataIfNull(v, entryName)).stream()).map(v -> Long.valueOf(v.get("fincard").toString())).collect(Collectors.toSet());
    }

    private static Object[] getAllRealCardByBill(DynamicObject dataEntity, String entryName, String cardIdName) {
        DynamicObjectCollection entries = (DynamicObjectCollection)FaOpUtils.reloadDataIfNull(dataEntity, entryName);
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            DynamicObject dobj = (DynamicObject)iter.next();
            if (dobj.get(cardIdName) != null && !"0".equals(dobj.get(cardIdName).toString())) continue;
            iter.remove();
        }
        Object[] realCardMasterIds = new Object[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject realCard = (DynamicObject)entries.get(i);
            realCardMasterIds[i] = realCard.get(cardIdName);
        }
        Set<Object> allRealCardMasterIds = FaOpUtils.getAllRealCardIdsByMasterid(realCardMasterIds);
        return allRealCardMasterIds.toArray();
    }

    private static Object[] getRealCardByBill(DynamicObject dataEntity, String entryName, String cardIdName) {
        DynamicObjectCollection entries = (DynamicObjectCollection)FaOpUtils.reloadDataIfNull(dataEntity, entryName);
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            DynamicObject dobj = (DynamicObject)iter.next();
            if (dobj.get(cardIdName) != null && !"0".equals(dobj.get(cardIdName).toString())) continue;
            iter.remove();
        }
        Object[] realCardPks = new Object[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject realCard = (DynamicObject)entries.get(i);
            realCardPks[i] = realCard.get(cardIdName);
        }
        return realCardPks;
    }

    private static Object[] getNewAddRealCard(DynamicObject dataEntity, String entryName, String cardIdName) {
        Object[] realCardPKs = FaOpUtils.getRealCardByBill(dataEntity, entryName, cardIdName);
        return FaOpUtils.filterNewAddRealCard(dataEntity, realCardPKs);
    }

    private static Object[] getNewDeleteRealCard(DynamicObject dataEntity, String entryName, String cardIdName) {
        Object[] realCardPKs = FaOpUtils.getRealCardByBill(dataEntity, entryName, cardIdName);
        return FaOpUtils.filterNewDeleteRealCard(dataEntity, realCardPKs);
    }

    private static Object[] filterNewAddRealCard(DynamicObject dataEntity, Object[] realCardPKs) {
        Object pk = dataEntity.getPkValue();
        if (pk != null && !FaOpUtils.isNewAddBill(dataEntity)) {
            Object[] dbRealCardPKs = FaOpUtils.queryRealCardByPK(pk, dataEntity.getDataEntityType().getName());
            return FaCommonUtils.filter((Object[])dbRealCardPKs, (Object[])realCardPKs);
        }
        return realCardPKs;
    }

    private static Object[] filterNewDeleteRealCard(DynamicObject dataEntity, Object[] realCardPKs) {
        Object pk = dataEntity.getPkValue();
        if (pk == null || FaOpUtils.isNewAddBill(dataEntity)) {
            return new Object[0];
        }
        if (pk != null && !FaOpUtils.isNewAddBill(dataEntity)) {
            Object[] dbRealCardPKs = FaOpUtils.queryRealCardByPK(pk, dataEntity.getDataEntityType().getName());
            return FaCommonUtils.filter((Object[])realCardPKs, (Object[])dbRealCardPKs);
        }
        return realCardPKs;
    }

    private static boolean isNewAddBill(DynamicObject dataEntity) {
        return !FaBillDaoFactory.getInstance((String)dataEntity.getDataEntityType().getName()).isExist(dataEntity.getPkValue());
    }

    private static Object[] queryRealCardByPK(Object pk, String entityName) {
        Object[] dbRealCardPKs = FaBizDaoFactory.getInstance((String)entityName).queryRealCardByPK(pk);
        return dbRealCardPKs;
    }

    public static Object reloadDataIfNull(DynamicObject dataEntity, String prop) {
        Object value = null;
        try {
            value = dataEntity.get(prop);
        }
        catch (ORMDesignException oRMDesignException) {
            // empty catch block
        }
        if (value == null) {
            Object pk = dataEntity.getPkValue();
            DynamicObject bill = FaBillDaoFactory.getInstance((String)dataEntity.getDataEntityType().getName()).queryOne(pk);
            value = bill.get(prop);
        }
        return value;
    }

    public static Object reloadDataIfNull(DynamicObject dataEntity) {
        Object pk = dataEntity.getPkValue();
        if (pk == null || (Long)pk == 0L) {
            return dataEntity;
        }
        return FaBillDaoFactory.getInstance((String)dataEntity.getDataEntityType().getName()).queryOne(pk);
    }

    private static String handleError(List<String> errorList) {
        StringBuilder sb = new StringBuilder(errorList.size() * 2);
        for (String error : errorList) {
            sb.append(sb.length() > 0 ? "\r\n" : "");
            sb.append(error);
        }
        return sb.toString();
    }

    public static String checkAssetBookStruts(long org) {
        QFilter orgf = new QFilter("org", "=", (Object)org);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"fa_assetbook", (String)"status,name", (QFilter[])new QFilter[]{orgf});
        for (DynamicObject dyn : dyns) {
            String status = dyn.getString("status");
            if (!status.equals("B")) continue;
            return String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\uff1a%s\u672a\u542f\u7528\uff0c\u8bf7\u542f\u7528\u540e\u518d\u8bd5", (String)"FaOpUtils_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), dyn.getString("name"));
        }
        return null;
    }

    public static String checkAssetBookStruts(List<DynamicObject> assetBooks) {
        for (DynamicObject assetBook : assetBooks) {
            String status = assetBook.getString("status");
            if (!status.equals("B")) continue;
            return String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\uff1a%s\u672a\u542f\u7528\uff0c\u8bf7\u542f\u7528\u540e\u518d\u8bd5", (String)"FaOpUtils_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), assetBook.getString("name"));
        }
        return null;
    }

    public static String checkAllAssetBookStruts(List<Long> orgIds, Map<Long, DynamicObject> orgAssetbook) {
        QFilter orgf = new QFilter("org", "in", orgIds);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"fa_assetbook", (String)"status,org,name,periodtype_id,ismainbook,curperiod", (QFilter[])new QFilter[]{orgf});
        for (DynamicObject dyn : dyns) {
            String status = dyn.getString("status");
            Long org = dyn.getLong("org");
            if ("B".equals(status)) {
                return String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\uff1a%s\u672a\u542f\u7528\uff0c\u8bf7\u542f\u7528\u540e\u518d\u8bd5", (String)"FaOpUtils_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), dyn.getString("name"));
            }
            boolean isMainBook = dyn.getBoolean("ismainbook");
            if (!isMainBook) continue;
            orgAssetbook.put(org, dyn);
        }
        return null;
    }

    public static boolean checkFinCard(DynamicObject realCardObj) {
        Object rCardPk = realCardObj.getPkValue();
        return QueryServiceHelper.exists((String)"fa_card_fin", (QFilter[])new QFilter("realcard", "=", rCardPk).toArray());
    }

    public static String checkAssetBookDate(DynamicObject dataEntity, String orgName, String dateName) {
        Date billDate = dataEntity.getDate(dateName);
        long orgId = dataEntity.getDynamicObject(orgName).getLong("id");
        ArrayList<String> assetBookNames = new ArrayList<String>();
        DynamicObject[] assetBookObjs = (DynamicObject[])ThreadCache.get((Object)("FaOpUtils.checkAssetBookDate" + orgId), () -> FaAssetBookDaoFactory.getInstance().queryAllBookByOrg((Object)orgId));
        if (billDate != null) {
            for (DynamicObject assetBook : assetBookObjs) {
                String status = assetBook.getString("status");
                if (!status.equalsIgnoreCase("C")) continue;
                DynamicObject curPeriodDy = assetBook.getDynamicObject("curperiod");
                Date startDate = curPeriodDy.getDate("begindate");
                Date endDate = curPeriodDy.getDate("enddate");
                if (!billDate.after(endDate) && !billDate.before(startDate)) continue;
                assetBookNames.add(assetBook.getDynamicObject("depreuse").getString("name"));
            }
        }
        if (assetBookNames == null || assetBookNames.size() == 0) {
            return "";
        }
        return Fa.join(assetBookNames, (String)",");
    }

    public static DynamicObject getDyn(ORM orm, Object properties, int type) {
        DynamicObject dynamicObject = null;
        if (type == 1) {
            dynamicObject = orm.newDynamicObject(String.valueOf(properties));
        } else if (type == 2) {
            dynamicObject = orm.newDynamicObject((DynamicObjectType)properties);
        }
        return dynamicObject;
    }

    public static int count(String properties, String entity, QFilter filter) {
        int count = ORM.create().count(properties, entity, new QFilter[]{filter});
        return count;
    }

    public static void updateMasterIdByRealCard4Entries(DynamicObject[] dataEntities, String entryFieldName, String realCardFieldName) {
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        for (DynamicObject dObj : dataEntities) {
            DynamicObjectCollection entries = dObj.getDynamicObjectCollection(entryFieldName);
            if (CollectionUtils.isEmpty((Collection)entries)) continue;
            for (DynamicObject row : entries) {
                DynamicObject realCard = row.getDynamicObject(realCardFieldName);
                row.set("realcardmasterid", (Object)realCard.getLong("masterid"));
            }
        }
    }
}

