/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;

public class FaAssetChangeBillItemUpgradeService
implements IUpgradeService {
    private static DBRoute fa = DBRoute.of((String)"fa");

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle handle = TX.requiresNew();){
            try {
                Map<String, Long> changeItemMap = this.addAssetChangeItem(result);
                this.addChangeItemMapping(changeItemMap, result);
                this.addChangeType(changeItemMap, result);
                this.processChangeBillChgItem(result);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog(e.getMessage());
                handle.markRollback();
            }
        }
        return result;
    }

    private void addChangeType(Map<String, Long> changeItemMap, UpgradeResult result) {
        this.assetNameChangeType(changeItemMap);
        this.supplierChangeType(changeItemMap);
        this.unitAndAssetAmountChangeType(changeItemMap);
        result.setLog("t_fa_changetype add success!");
        result.setSuccess(true);
    }

    private void assetNameChangeType(Map<String, Long> changeItemMap) {
        Long assetNameItemId = changeItemMap.get("assetname");
        String changeItem = Fa.dot((String[])new String[]{"changetypeentry", "changeitem"});
        DynamicObjectCollection changeTypeCollection = QueryServiceHelper.query((String)"fa_change_type", (String)"id", (QFilter[])new QFilter[]{new QFilter(changeItem, "=", (Object)assetNameItemId)});
        Boolean needAdd = true;
        Integer updateChangeTypeId = 0;
        if (!changeTypeCollection.isEmpty()) {
            Set ids = changeTypeCollection.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
            Map changeTypeLoadMap = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"fa_change_type");
            for (Map.Entry changeTypeLoad : changeTypeLoadMap.entrySet()) {
                DynamicObject changeType = (DynamicObject)changeTypeLoad.getValue();
                DynamicObjectCollection changeTypeEntry = changeType.getDynamicObjectCollection("changetypeentry");
                if (changeTypeEntry.size() != 1) continue;
                needAdd = false;
                updateChangeTypeId = changeTypeLoad.getKey();
                break;
            }
        }
        if (needAdd.booleanValue()) {
            String deleteSql = "DELETE FROM t_fa_changetype WHERE FID = 1292598444866831360";
            String insertSql = ResManager.loadKDString((String)"INSERT INTO t_fa_changetype(FID,FCREATETIME,FEFTSCOPE,FMODIFIERID,FENABLE,FMODIFYTIME,FMASTERID,FSTATUS,FCREATORID,FNUMBER,FISSYSTEM,FNAME) VALUES (1292598444866831360,{ts'2018-08-08  18:08:08'},',A,',1,'1',{ts'2018-08-08  18:08:08'},1292598444866831360,'C',1,'020','1','\u8d44\u4ea7\u540d\u79f0\u53d8\u66f4')", (String)"FaAssetChangeBillItemUpgradeService_0", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            DB.execute((DBRoute)fa, (String)deleteSql);
            DB.execute((DBRoute)fa, (String)insertSql);
            String deleteEntrySql = "DELETE FROM t_fa_changetype_entry WHERE FENTRYID = 1292598444883608576";
            String insertEntrySql = "INSERT INTO t_fa_changetype_entry(FID,FCHANGEITEMID,FENTRYID,FSEQ) VALUES (1292598444866831360," + assetNameItemId + ",1292598444883608576,1)";
            DB.execute((DBRoute)fa, (String)deleteEntrySql);
            DB.execute((DBRoute)fa, (String)insertEntrySql);
            String deleteCNSql = "DELETE FROM t_fa_changetype_l WHERE FPKID = '20RPFR4Q464I'";
            String name1 = ResManager.loadKDString((String)"\u8d44\u4ea7\u540d\u79f0\u53d8\u66f4", (String)"FaAssetChangeBillItemUpgradeService_1", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            String insertCNSql = "INSERT INTO t_fa_changetype_l(FID,FPKID,FLOCALEID,FNAME) VALUES (1292598444866831360,'20RPFR4Q464I','zh_CN','" + name1 + "')";
            DB.execute((DBRoute)fa, (String)deleteCNSql);
            DB.execute((DBRoute)fa, (String)insertCNSql);
            String deleteTWSql = "DELETE FROM t_fa_changetype_l WHERE FPKID = '20RPFR4Q464J'";
            String name2 = ResManager.loadKDString((String)"\u8cc7\u7522\u540d\u7a31\u8b8a\u66f4", (String)"FaAssetChangeBillItemUpgradeService_2", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            String insertTWSql = "INSERT INTO t_fa_changetype_l(FID,FPKID,FLOCALEID,FNAME) VALUES (1292598444866831360,'20RPFR4Q464J','zh_TW','" + name2 + "')";
            DB.execute((DBRoute)fa, (String)deleteTWSql);
            DB.execute((DBRoute)fa, (String)insertTWSql);
        } else {
            String updateSql = "update t_fa_changetype set fissystem = '1' where fid =" + updateChangeTypeId;
            DB.execute((DBRoute)fa, (String)updateSql);
        }
    }

    private void supplierChangeType(Map<String, Long> changeItemMap) {
        Long supplierItemId = changeItemMap.get("supplier");
        String changeItem = Fa.dot((String[])new String[]{"changetypeentry", "changeitem"});
        DynamicObjectCollection changeTypeCollection = QueryServiceHelper.query((String)"fa_change_type", (String)Fa.comma((String[])new String[]{"id", changeItem}), (QFilter[])new QFilter[]{new QFilter(changeItem, "=", (Object)supplierItemId)});
        Boolean needAdd = true;
        Integer updateChangeTypeId = 0;
        if (!changeTypeCollection.isEmpty()) {
            Set ids = changeTypeCollection.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
            Map changeTypeLoadMap = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"fa_change_type");
            for (Map.Entry changeTypeLoad : changeTypeLoadMap.entrySet()) {
                DynamicObject changeType = (DynamicObject)changeTypeLoad.getValue();
                DynamicObjectCollection changeTypeEntry = changeType.getDynamicObjectCollection("changetypeentry");
                if (changeTypeEntry.size() != 1) continue;
                needAdd = false;
                updateChangeTypeId = changeTypeLoad.getKey();
                break;
            }
        }
        if (needAdd.booleanValue()) {
            String deleteSql = "DELETE FROM t_fa_changetype WHERE FID = 1292599011827637248";
            String insertSql = ResManager.loadKDString((String)"INSERT INTO t_fa_changetype(FID,FCREATETIME,FEFTSCOPE,FMODIFIERID,FENABLE,FMODIFYTIME,FMASTERID,FSTATUS,FCREATORID,FNUMBER,FISSYSTEM,FNAME) VALUES (1292599011827637248,{ts'2018-08-08  18:08:08'},',A,',1,'1',{ts'2018-08-08  18:08:08'},1292599011827637248,'C',1,'021','1','\u4f9b\u5e94\u5546\u53d8\u66f4')", (String)"FaAssetChangeBillItemUpgradeService_3", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            DB.execute((DBRoute)fa, (String)deleteSql);
            DB.execute((DBRoute)fa, (String)insertSql);
            String deleteEntrySql = "DELETE FROM t_fa_changetype_entry WHERE FENTRYID = 1292599011836025856";
            String insertEntrySql = "INSERT INTO t_fa_changetype_entry(FID,FCHANGEITEMID,FENTRYID,FSEQ) VALUES (1292599011827637248," + supplierItemId + ",1292599011836025856,1)";
            DB.execute((DBRoute)fa, (String)deleteEntrySql);
            DB.execute((DBRoute)fa, (String)insertEntrySql);
            String name1 = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u53d8\u66f4", (String)"FaAssetChangeBillItemUpgradeService_4", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            String deleteCNSql = "DELETE FROM t_fa_changetype_l WHERE FPKID = '20RPJW9J1AYS'";
            String insertCNSql = "INSERT INTO t_fa_changetype_l(FID,FPKID,FLOCALEID,FNAME) VALUES (1292599011827637248,'20RPJW9J1AYS','zh_CN','" + name1 + "')";
            DB.execute((DBRoute)fa, (String)deleteCNSql);
            DB.execute((DBRoute)fa, (String)insertCNSql);
            String name2 = ResManager.loadKDString((String)"\u4f9b\u61c9\u5546\u8b8a\u66f4", (String)"FaAssetChangeBillItemUpgradeService_5", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            String deleteTWSql = "DELETE FROM t_fa_changetype_l WHERE FPKID = '20RPJW9J1AYT'";
            String insertTWSql = "INSERT INTO t_fa_changetype_l(FID,FPKID,FLOCALEID,FNAME) VALUES (1292599011827637248,'20RPJW9J1AYT','zh_TW','" + name2 + "')";
            DB.execute((DBRoute)fa, (String)deleteTWSql);
            DB.execute((DBRoute)fa, (String)insertTWSql);
        } else {
            String updateSql = "update t_fa_changetype set fissystem = '1' where fid =" + updateChangeTypeId;
            DB.execute((DBRoute)fa, (String)updateSql);
        }
    }

    private void unitAndAssetAmountChangeType(Map<String, Long> changeItemMap) {
        Long unitItemId = changeItemMap.get("unit");
        Long assetAmountItemId = changeItemMap.get("assetamount");
        String changeItem = Fa.dot((String[])new String[]{"changetypeentry", "changeitem"});
        DynamicObjectCollection changeTypeCollection = QueryServiceHelper.query((String)"fa_change_type", (String)"id", (QFilter[])new QFilter[]{new QFilter(changeItem, "in", (Object)new Object[]{unitItemId, assetAmountItemId})});
        Boolean needAdd = true;
        Integer updateChangeTypeId = 0;
        if (!changeTypeCollection.isEmpty()) {
            Set ids = changeTypeCollection.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
            Map changeTypeLoadMap = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"fa_change_type");
            for (Map.Entry changeTypeLoad : changeTypeLoadMap.entrySet()) {
                Set changeItemIds;
                DynamicObject changeType = (DynamicObject)changeTypeLoad.getValue();
                DynamicObjectCollection changeTypeEntry = changeType.getDynamicObjectCollection("changetypeentry");
                if (changeTypeEntry.size() != 2 || !(changeItemIds = changeTypeEntry.stream().map(v -> v.getDynamicObject("changeitem").getLong("id")).collect(Collectors.toSet())).contains(unitItemId) || !changeItemIds.contains(assetAmountItemId)) continue;
                needAdd = false;
                updateChangeTypeId = changeTypeLoad.getKey();
                break;
            }
        }
        if (needAdd.booleanValue()) {
            String deleteSql = "DELETE FROM t_fa_changetype WHERE FID = 1292620812477595648";
            String insertSql = ResManager.loadKDString((String)"INSERT INTO t_fa_changetype(FID,FCREATETIME,FEFTSCOPE,FMODIFIERID,FENABLE,FMODIFYTIME,FMASTERID,FSTATUS,FCREATORID,FNUMBER,FISSYSTEM,FNAME) VALUES (1292620812477595648,{ts'2018-08-08  18:08:08'},',A,',1,'1',{ts'2018-08-08  18:08:08'},1292620812477595648,'C',1,'022','1','\u8ba1\u91cf\u5355\u4f4d\u53d8\u66f4')", (String)"FaAssetChangeBillItemUpgradeService_6", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            DB.execute((DBRoute)fa, (String)deleteSql);
            DB.execute((DBRoute)fa, (String)insertSql);
            String deleteEntrySql1 = "DELETE FROM t_fa_changetype_entry WHERE FENTRYID = 1292620813031243776";
            String insertEntrySql1 = "INSERT INTO t_fa_changetype_entry(FID,FCHANGEITEMID,FENTRYID,FSEQ) VALUES (1292620812477595648," + assetAmountItemId + ",1292620813031243776,1)";
            DB.execute((DBRoute)fa, (String)deleteEntrySql1);
            DB.execute((DBRoute)fa, (String)insertEntrySql1);
            String deleteEntrySql2 = "DELETE FROM t_fa_changetype_entry WHERE FENTRYID = 1292620813031243777";
            String insertEntrySql2 = "INSERT INTO t_fa_changetype_entry(FID,FCHANGEITEMID,FENTRYID,FSEQ) VALUES (1292620812477595648," + unitItemId + ",1292620813031243777,2)";
            DB.execute((DBRoute)fa, (String)deleteEntrySql2);
            DB.execute((DBRoute)fa, (String)insertEntrySql2);
            String deleteCNSql = "DELETE FROM t_fa_changetype_l WHERE FPKID = '20RTMR//LFSL'";
            String insertCNSql = "INSERT INTO t_fa_changetype_l(FID,FPKID,FLOCALEID,FNAME) VALUES (1292620812477595648,'20RTMR//LFSL','zh_CN','" + ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u53d8\u66f4", (String)"FaAssetChangeBillItemUpgradeService_7", (String)"fi-fa-upgradeservice", (Object[])new Object[0]) + "')";
            DB.execute((DBRoute)fa, (String)deleteCNSql);
            DB.execute((DBRoute)fa, (String)insertCNSql);
            String deleteTWSql = "DELETE FROM t_fa_changetype_l WHERE FPKID = '20RTMR//LFSM'";
            String insertTWSql = "INSERT INTO t_fa_changetype_l(FID,FPKID,FLOCALEID,FNAME) VALUES (1292620812477595648,'20RTMR//LFSM','zh_TW','" + ResManager.loadKDString((String)"\u8a08\u91cf\u55ae\u4f4d\u8b8a\u66f4", (String)"FaAssetChangeBillItemUpgradeService_8", (String)"fi-fa-upgradeservice", (Object[])new Object[0]) + "')";
            DB.execute((DBRoute)fa, (String)deleteTWSql);
            DB.execute((DBRoute)fa, (String)insertTWSql);
        } else {
            String updateSql = "update t_fa_changetype set fissystem = '1' where fid =" + updateChangeTypeId;
            DB.execute((DBRoute)fa, (String)updateSql);
        }
    }

    private void addChangeItemMapping(Map<String, Long> changeItemMap, UpgradeResult result) {
        Long supplierItemId = changeItemMap.get("supplier");
        String delete = "DELETE FROM t_fa_change_mapping WHERE FID in (1274609991038346240, 1274610595227837440, 1274501902389925888, 1274611230505509888)";
        DB.execute((DBRoute)fa, (String)delete);
        String supplierSql = "INSERT INTO t_fa_change_mapping(FID,FCREATETIME,FMODIFIERID,FENABLE,FLEASEITEMID,FMODIFYTIME,FPRESET,FMASTERID,FSTATUS,FCREATORID,FCARDITEMID) VALUES (1274609991038346240,{ts'2018-08-08  18:08:08'},1,'1',1272535191096833024,{ts'2018-08-08  18:08:08'},'1',1274609991038346240,'C',1," + supplierItemId + ")";
        DB.execute((DBRoute)fa, (String)supplierSql);
        Long assetAmountId = changeItemMap.get("assetamount");
        String assetAmountSql = "INSERT INTO t_fa_change_mapping(FID,FCREATETIME,FMODIFIERID,FENABLE,FLEASEITEMID,FMODIFYTIME,FPRESET,FMASTERID,FSTATUS,FCREATORID,FCARDITEMID) VALUES (1274610595227837440,{ts'2018-08-08  18:08:08'},1,'1',1272535515031319552,{ts'2018-08-08  18:08:08'},'1',1274610595227837440,'C',1," + assetAmountId + ")";
        DB.execute((DBRoute)fa, (String)assetAmountSql);
        Long assetNameId = changeItemMap.get("assetname");
        String assetNameSql = "INSERT INTO t_fa_change_mapping(FID,FCREATETIME,FMODIFIERID,FENABLE,FLEASEITEMID,FMODIFYTIME,FPRESET,FMASTERID,FSTATUS,FCREATORID,FCARDITEMID) VALUES (1274501902389925888,{ts'2018-08-08  18:08:08'},1,'1',1271703849987533824,{ts'2018-08-08  18:08:08'},'1',1274501902389925888,'C',1," + assetNameId + ")";
        DB.execute((DBRoute)fa, (String)assetNameSql);
        Long unitId = changeItemMap.get("unit");
        String unitSql = "INSERT INTO t_fa_change_mapping(FID,FCREATETIME,FMODIFIERID,FENABLE,FLEASEITEMID,FMODIFYTIME,FPRESET,FMASTERID,FSTATUS,FCREATORID,FCARDITEMID) VALUES (1274611230505509888,{ts'2018-08-08  18:08:08'},1,'1',1272535733713885184,{ts'2018-08-08  18:08:08'},'1',1274611230505509888,'C',1," + unitId + ")";
        DB.execute((DBRoute)fa, (String)unitSql);
        result.setLog("t_fa_change_mapping add success!");
        result.setSuccess(true);
    }

    private void processChangeBillChgItem(UpgradeResult result) {
        StringBuilder sql = new StringBuilder("select a.fid, c.fchangeitemid");
        sql.append(" from t_fa_changebill A").append(" inner join t_fa_changetype B on A.fnewchangetype = B.FID").append(" inner join t_fa_changetype_entry c on c.fid = b.fid").append(" where A.fnewchangetype > 0").append(" and not exists (select 1 from t_fa_changebill_chgitem d where d.fid = a.fid)");
        List queryResult = (List)DB.query((DBRoute)fa, (String)sql.toString(), rs -> {
            ArrayList<Long[]> resultList = new ArrayList<Long[]>(10);
            while (rs.next()) {
                Long[] data = new Long[]{rs.getLong("fid"), rs.getLong("fchangeitemid")};
                resultList.add(data);
            }
            return resultList;
        });
        int size = queryResult.size();
        if (size > 0) {
            String insertSql = "INSERT INTO t_fa_changebill_chgitem(FPKID,FID,fbasedataid) VALUES (?,?,?)";
            ArrayList<Object[]> params = new ArrayList<Object[]>(size);
            long[] pks = DB.genLongIds((String)"t_fa_changebill_chgitem", (int)size);
            int index = 0;
            for (Long[] data : queryResult) {
                Object[] param = new Object[]{pks[index++], data[0], data[1]};
                params.add(param);
            }
            int[] executeBatch = DB.executeBatch((DBRoute)fa, (String)insertSql, params);
            result.setLog("fa_changebill_chgitem update success count" + executeBatch.length);
        } else {
            result.setLog("fa_changebill_chgitem do not need update");
        }
        result.setSuccess(true);
    }

    private Map<String, Long> addAssetChangeItem(UpgradeResult result) {
        HashSet<String> numberSet = new HashSet<String>(8);
        numberSet.add("assetname");
        numberSet.add("unit");
        numberSet.add("assetamount");
        numberSet.add("supplier");
        QFilter[] filter = new QFilter[]{new QFilter("topic", "=", (Object)"fa_card_real"), new QFilter("number", "in", (Object)new Object[]{"assetname", "unit", "assetamount", "supplier"})};
        DynamicObjectCollection changeItemCollection = QueryServiceHelper.query((String)"fa_change_item", (String)Fa.comma((String[])new String[]{"id", "number"}), (QFilter[])filter);
        HashMap<String, Long> changeItemM = new HashMap<String, Long>(8);
        for (DynamicObject changeItem : changeItemCollection) {
            changeItemM.put(changeItem.getString("number"), changeItem.getLong("id"));
        }
        HashMap<String, Long> changeItemMap = new HashMap<String, Long>(8);
        for (String number : numberSet) {
            Long id = (Long)changeItemM.get(number);
            if (id != null) {
                changeItemMap.put(number, id);
                this.updateChangeItem(id);
                continue;
            }
            this.addChangeItem(number, changeItemMap);
        }
        this.processHistoryItem();
        result.setLog("fa_change_item add or update success!");
        result.setSuccess(true);
        return changeItemMap;
    }

    private void addChangeItem(String number, Map<String, Long> changeItemMap) {
        if ("assetname".equals(number)) {
            String executeSql = ResManager.loadKDString((String)"INSERT INTO t_fa_change_item(FID,FMASTERID,FSTATUS,FNUMBER,FISGENVOUCHER,FNAME,FTOPIC,FCREATETIME,FBACKFIELD,FMODIFIERID,FENABLE,FMODIFYTIME,FPRESET,FISCHANGE,FCREATORID) VALUES (1274498257128569856,1274498257128569856,'C','assetname','0','\u8d44\u4ea7\u540d\u79f0','fa_card_real',{ts'2018-08-08  18:08:08'},' ',1,'1',{ts'2018-08-08  18:08:08'},'1','0',1)", (String)"FaAssetChangeBillItemUpgradeService_9", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            changeItemMap.put(number, 1274498257128569856L);
            DB.execute((DBRoute)fa, (String)executeSql);
            String name1 = ResManager.loadKDString((String)"\u8d44\u4ea7\u540d\u79f0", (String)"FaAssetChangeBillItemUpgradeService_10", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            String name2 = ResManager.loadKDString((String)"\u8cc7\u7522\u540d\u7a31", (String)"FaAssetChangeBillItemUpgradeService_11", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            DB.execute((DBRoute)fa, (String)("INSERT INTO t_fa_change_item_L(FID,FPKID,FLOCALEID,FNAME) VALUES (1274498257128569856,'2+J+I+JWIMI9','zh_CN','" + name1 + "')"));
            DB.execute((DBRoute)fa, (String)("INSERT INTO t_fa_change_item_L(FID,FPKID,FLOCALEID,FNAME) VALUES (1274498257128569856,'2+J+I+JWIMI8','zh_TW','" + name2 + "')"));
        } else if ("unit".equals(number)) {
            String executeSql = ResManager.loadKDString((String)"INSERT INTO t_fa_change_item(FID,FMASTERID,FSTATUS,FNUMBER,FISGENVOUCHER,FNAME,FTOPIC,FCREATETIME,FBACKFIELD,FMODIFIERID,FENABLE,FMODIFYTIME,FPRESET,FISCHANGE,FCREATORID) VALUES (1221815374228588544,1221815374228588544,'C','unit','0','\u8ba1\u91cf\u5355\u4f4d','fa_card_real',{ts'2018-08-08  18:08:08'},' ',1,'1',{ts'2018-08-08  18:08:08'},'1','0',1)", (String)"FaAssetChangeBillItemUpgradeService_12", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            changeItemMap.put(number, 1221815374228588544L);
            DB.execute((DBRoute)fa, (String)executeSql);
            String name1 = ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"FaAssetChangeBillItemUpgradeService_13", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            String name2 = ResManager.loadKDString((String)"\u8a08\u91cf\u55ae\u4f4d", (String)"FaAssetChangeBillItemUpgradeService_14", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            DB.execute((DBRoute)fa, (String)("INSERT INTO t_fa_change_item_L(FID,FPKID,FLOCALEID,FNAME) VALUES (1221815374228588544,'1U1KYQ4O8EJL','zh_CN','" + name1 + "')"));
            DB.execute((DBRoute)fa, (String)("INSERT INTO t_fa_change_item_L(FID,FPKID,FLOCALEID,FNAME) VALUES (1221815374228588544,'1U1KYQ4O8EJM','zh_TW','" + name2 + "')"));
        } else if ("assetamount".equals(number)) {
            String executeSql = ResManager.loadKDString((String)"INSERT INTO t_fa_change_item(FID,FMASTERID,FSTATUS,FNUMBER,FISGENVOUCHER,FNAME,FTOPIC,FCREATETIME,FBACKFIELD,FMODIFIERID,FENABLE,FMODIFYTIME,FPRESET,FISCHANGE,FCREATORID) VALUES (1272537949975730176,1272537949975730176,'C','assetamount','0','\u8d44\u4ea7\u6570\u91cf','fa_card_real',{ts'2018-08-08  18:08:08'},' ',1,'1',{ts'2018-08-08  18:08:08'},'1','0',1)", (String)"FaAssetChangeBillItemUpgradeService_15", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            changeItemMap.put(number, 1272537949975730176L);
            DB.execute((DBRoute)fa, (String)executeSql);
            String name1 = ResManager.loadKDString((String)"\u8d44\u4ea7\u6570\u91cf", (String)"FaAssetChangeBillItemUpgradeService_16", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            String name2 = ResManager.loadKDString((String)"\u8cc7\u7522\u6578\u91cf", (String)"FaAssetChangeBillItemUpgradeService_17", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            DB.execute((DBRoute)fa, (String)("INSERT INTO t_fa_change_item_L(FID,FPKID,FLOCALEID,FNAME) VALUES (1272537949975730176,'2+=L89=DVNL1','zh_CN','" + name1 + "')"));
            DB.execute((DBRoute)fa, (String)("INSERT INTO t_fa_change_item_L(FID,FPKID,FLOCALEID,FNAME) VALUES (1272537949975730176,'2+=L89=DVNL2','zh_TW','" + name2 + "')"));
        } else {
            String executeSql = ResManager.loadKDString((String)"INSERT INTO t_fa_change_item(FID,FMASTERID,FSTATUS,FNUMBER,FISGENVOUCHER,FNAME,FTOPIC,FCREATETIME,FBACKFIELD,FMODIFIERID,FENABLE,FMODIFYTIME,FPRESET,FISCHANGE,FCREATORID) VALUES (1272538092808497152,1272538092808497152,'C','supplier','0','\u4f9b\u5e94\u5546','fa_card_real',{ts'2018-08-08  18:08:08'},' ',1,'1',{ts'2018-08-08  18:08:08'},'1','0',1)", (String)"FaAssetChangeBillItemUpgradeService_18", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            changeItemMap.put(number, 1272538092808497152L);
            DB.execute((DBRoute)fa, (String)executeSql);
            String name1 = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"FaAssetChangeBillItemUpgradeService_19", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            String name2 = ResManager.loadKDString((String)"\u4f9b\u61c9\u5546", (String)"FaAssetChangeBillItemUpgradeService_20", (String)"fi-fa-upgradeservice", (Object[])new Object[0]);
            DB.execute((DBRoute)fa, (String)("INSERT INTO t_fa_change_item_L(FID,FPKID,FLOCALEID,FNAME) VALUES (1272538092808497152,'2+=L9=WHA8/8','zh_CN','" + name1 + "')"));
            DB.execute((DBRoute)fa, (String)("INSERT INTO t_fa_change_item_L(FID,FPKID,FLOCALEID,FNAME) VALUES (1272538092808497152,'2+=L9=WHA8/9','zh_TW','" + name2 + "')"));
        }
    }

    private void processHistoryItem() {
        StringBuilder sql = new StringBuilder("select fid,fpreset,fnumber,ftopic from t_fa_change_item");
        sql.append(" where ftopic = 'fa_card_real'").append(" and fnumber in ('assetcat', 'headusedept', 'headuseperson', 'realaccountdate', 'storeplace', 'usestatus')");
        List realChangeItemCollection = (List)DB.query((DBRoute)fa, (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws Exception {
                ArrayList<Object[]> result = new ArrayList<Object[]>(16);
                while (rs.next()) {
                    Object[] param = new Object[]{rs.getLong("fid"), rs.getString("fnumber"), rs.getBoolean("fpreset")};
                    result.add(param);
                }
                return result;
            }
        });
        if (realChangeItemCollection != null && realChangeItemCollection.size() > 0) {
            HashMap<String, Long> realCardUpdateMap = new HashMap<String, Long>(realChangeItemCollection.size());
            for (Object[] item : realChangeItemCollection) {
                boolean preset = (Boolean)item[2];
                if (preset) continue;
                String number = (String)item[1];
                long id = (Long)item[0];
                realCardUpdateMap.put(number, id);
            }
            if (realCardUpdateMap.size() > 0) {
                ArrayList ids = new ArrayList(realCardUpdateMap.values());
                SqlBuilder updateSql = new SqlBuilder();
                updateSql.append("update t_fa_change_item set fpreset = '1' where ", new Object[0]);
                updateSql.appendIn("fid", ids);
                DB.execute((DBRoute)fa, (SqlBuilder)updateSql);
            }
        }
        sql = new StringBuilder("select fid,fpreset,fnumber,ftopic from t_fa_change_item");
        sql.append(" where ftopic = 'fa_card_fin'").append(" and fnumber in ('depremethod', 'originalval', 'preresidualval', 'preusingamount')");
        List finChangeItemCollection = (List)DB.query((DBRoute)fa, (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws Exception {
                ArrayList<Object[]> result = new ArrayList<Object[]>(16);
                while (rs.next()) {
                    Object[] param = new Object[]{rs.getLong("fid"), rs.getString("fnumber"), rs.getBoolean("fpreset")};
                    result.add(param);
                }
                return result;
            }
        });
        if (finChangeItemCollection != null && finChangeItemCollection.size() > 0) {
            HashMap<String, Long> finCardUpdateMap = new HashMap<String, Long>(finChangeItemCollection.size());
            for (Object[] item : finChangeItemCollection) {
                boolean preset = (Boolean)item[2];
                if (preset) continue;
                String number = (String)item[1];
                long id = (Long)item[0];
                finCardUpdateMap.put(number, id);
            }
            if (finCardUpdateMap.size() > 0) {
                ArrayList ids = new ArrayList(finCardUpdateMap.values());
                SqlBuilder updateSql = new SqlBuilder();
                updateSql.append("update t_fa_change_item set fpreset = '1' where ", new Object[0]);
                updateSql.appendIn("fid", ids);
                DB.execute((DBRoute)fa, (SqlBuilder)updateSql);
            }
        }
    }

    private void updateChangeItem(Long id) {
        String updateSql = "update t_fa_change_item set fpreset = '1' where fid = " + id;
        DB.execute((DBRoute)fa, (String)updateSql);
    }
}

