/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class FaAssetSplitBizLockUpgradeService
implements IUpgradeService {
    private static final DBRoute FA = DBRoute.of((String)"fa");
    private static final String NO_ENTITY_NAME = "NOENTITYNAME";
    private static final String SPLIT_ENTRY_NAME = "fa_assetsplitbill";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle handle = TX.requiresNew();){
            try {
                ArrayList<Object[]> params = new ArrayList<Object[]>(16);
                HashSet<Long> needDeleteIds = new HashSet<Long>(16);
                HashSet<Long> insertCardIds = new HashSet<Long>(16);
                String querySql = "select a.fid, a.frealcardid, a.fcreatetime, b.fsrcbillid, b.fsrcbillentityname from t_fa_assetsplitbill a left join t_fa_card_biz_ctr b on a.frealcardid = b.fid where a.fbillstatus != 'C' and (b.fsrcbillid = 0 or b.fsrcbillid is null)";
                DataSet dataSet = DB.queryDataSet((String)FaAssetSplitBizLockUpgradeService.class.getName(), (DBRoute)FA, (String)querySql);
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    String srcBillEntityName = next.getString("fsrcbillentityname");
                    Long realCardId = next.getLong("frealcardid");
                    if (NO_ENTITY_NAME.equals(srcBillEntityName)) {
                        needDeleteIds.add(realCardId);
                    }
                    if (!insertCardIds.add(realCardId)) continue;
                    Object[] param = new Object[]{realCardId, next.getLong("fid"), SPLIT_ENTRY_NAME, next.getDate("fcreatetime")};
                    params.add(param);
                }
                if (!needDeleteIds.isEmpty()) {
                    SqlBuilder deleteSql = new SqlBuilder();
                    deleteSql.appendIn("delete from t_fa_card_biz_ctr where fid ", needDeleteIds.toArray());
                    DB.execute((DBRoute)FA, (SqlBuilder)deleteSql);
                }
                if (!params.isEmpty()) {
                    String insertSql = "insert into t_fa_card_biz_ctr (fid, fsrcbillid, fsrcbillentityname, fmodifytime) values (?, ?, ?, ?)";
                    DB.executeBatch((DBRoute)FA, (String)insertSql, params);
                }
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog("assetSplitBizLockUpdateFailed :" + e.getMessage());
                handle.markRollback();
            }
        }
        return result;
    }
}

