/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;

public class FaCurperiodSplitBizParamUpgradeService
implements IUpgradeService {
    private static Log log = LogFactory.getLog(FaCurperiodSplitBizParamUpgradeService.class);
    private static String SQL_INSERT = "INSERT INTO t_fa_billparam (fid, forgid, fcreatedate, fparam, fvalue, fenable, fsyspre, fbizcloudid, fbizappid, fparamtypeid, fcanmodify) VALUES(?, ?, ?, 'split.currentperiod.enable', 'false', '1', '1', '83bfebc8000002ac', '83bfebc800001aac', 1819718086002160640, '0');";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            Set<Long> orgs = this.queryOrgsFromBook();
            Set<Long> existOrgs = this.alreadyExistOrgs();
            orgs.removeAll(existOrgs);
            if (CollectionUtils.isEmpty(orgs)) {
                log.info("FaCurperiodSplitBizParamUpgradeService : \u6682\u65e0\u9700\u8981\u5347\u7ea7\u53c2\u6570[split.currentperiod.enable]\u7684\u7ec4\u7ec7\uff08\u6709\u53ef\u80fd\u8d26\u7c3f\u8868\u65e0\u6570\u636e \u6216 \u4e4b\u524d\u5df2\u7ecf\u5347\u7ea7\u6dfb\u52a0\u8fc7\u4e00\u6b21\u53c2\u6570\uff09");
                return result;
            }
            log.info("FaCurperiodSplitBizParamUpgradeService : \u6267\u884c\u53c2\u6570\u5347\u7ea7\uff0c\u7ec4\u7ec7\u6570[{}]", (Object)orgs.size());
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(orgs.size());
            long[] ids = DB.genLongIds((String)"t_fa_billparam", (int)orgs.size());
            int i = 0;
            for (Long orgId : orgs) {
                paramsList.add(new Object[]{ids[i], orgId, new Date()});
                ++i;
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)SQL_INSERT, paramsList);
        }
        catch (Exception e) {
            log.error("FaCurperiodSplitBizParamUpgradeService error is : ", (Throwable)e);
            result.setSuccess(false);
            result.setErrorInfo(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private Set<Long> queryOrgsFromBook() {
        HashSet<Long> orgs = new HashSet<Long>(16);
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select forgid from t_fa_assetbook;", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql).distinct();){
            for (Row row : dataSet) {
                orgs.add(row.getLong("forgid"));
            }
        }
        return orgs;
    }

    private Set<Long> alreadyExistOrgs() {
        HashSet<Long> orgs = new HashSet<Long>(16);
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select forgid from t_fa_billparam where fparam = 'split.currentperiod.enable';", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql);){
            for (Row row : dataSet) {
                orgs.add(row.getLong("forgid"));
            }
        }
        return orgs;
    }
}

