/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.ExceptionUtils;

public class FaDepreAdjustAddBillNoUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.fa.upgradeservice.FaDepreAdjustAddBillNoUpgradeService");
    private static final DecimalFormat SERIAL_NUMBER = new DecimalFormat("0000");
    private static final String SPLIT = "_split_";
    private static final String KEY = "bas/coderule/2AXGUS6G03P+";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            String queryDepreAdjust = "select a.fid fid, a.forgid forgid, c.fnumber depreusenumber, b.fnumber periodnumber from t_fa_depreadjustbill a inner join t_bd_period b on a.fperiodid = b.fid inner join t_fa_depreuse c on a.fdepreuseid = c.fid where trim(a.fbillno) = ''";
            DataSet depreAdjust = DB.queryDataSet((String)"queryDepreAdjustbill", (DBRoute)DBRoute.of((String)"fa"), (String)queryDepreAdjust);
            if (depreAdjust.isEmpty()) {
                return result;
            }
            ArrayList<TempData> updateData = new ArrayList<TempData>(512);
            HashSet<Object> orgIds = new HashSet<Object>(64);
            for (Row row : depreAdjust) {
                Long id = row.getLong("fid");
                Long orgId = row.getLong("forgid");
                String depreUseNumber = row.getString("depreusenumber");
                String periodNumber = row.getString("periodnumber");
                TempData tempData = new TempData(id, orgId, depreUseNumber, periodNumber);
                updateData.add(tempData);
                orgIds.add(orgId);
            }
            SqlBuilder orgSql = new SqlBuilder();
            orgSql.append("select fid, fnumber from t_org_org where ", new Object[0]);
            orgSql.appendIn("fid ", orgIds.toArray());
            DataSet orgNumberDataSet = DB.queryDataSet((String)"queryOrg", (DBRoute)DBRoute.basedata, (SqlBuilder)orgSql);
            HashMap<Long, String> orgToNumber = new HashMap<Long, String>(orgIds.size());
            for (Row row : orgNumberDataSet) {
                Long id = row.getLong("fid");
                String number = row.getString("fnumber");
                orgToNumber.put(id, number);
            }
            ArrayList<Object[]> updateParam = new ArrayList<Object[]>(updateData.size());
            HashMap<String, Integer> billMaxSerial = new HashMap<String, Integer>(updateData.size());
            ArrayList<Object[]> insertParam = new ArrayList<Object[]>(updateData.size());
            for (TempData tempData : updateData) {
                Long orgId = tempData.getOrgId();
                String orgNumber = (String)orgToNumber.get(orgId);
                String depreUseNumber = tempData.getDepreUseNumber();
                String periodNumber = tempData.getPeriodNumber();
                String billNo = orgNumber + "-" + depreUseNumber + "-" + periodNumber + "-";
                Integer serial = (Integer)billMaxSerial.get(billNo);
                if (serial == null) {
                    serial = 0;
                }
                Integer n = serial;
                Integer n2 = serial = Integer.valueOf(serial + 1);
                billMaxSerial.put(billNo, serial);
                billNo = billNo + SERIAL_NUMBER.format(serial);
                updateParam.add(new Object[]{billNo, tempData.getId()});
                String key = KEY + orgNumber + SPLIT + depreUseNumber + SPLIT + periodNumber;
                insertParam.add(new Object[]{DBServiceHelper.genStringId(), DBServiceHelper.genStringId(), key, 0, serial});
            }
            String updateSql = "update t_fa_depreadjustbill set fbillno = ? where fid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)updateSql, updateParam);
            String consumeSql = "insert into t_signer_record(FID, FENTRYID, FKEY, FVERSION, FCONSUMESEQ) VALUES (?, ?, ?, ?, ?)";
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)consumeSql, insertParam);
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_ERROR");
            result.setErrorInfo("UPGRADE_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    static class TempData {
        Long id;
        Long orgId;
        String depreUseNumber;
        String periodNumber;

        public TempData(Long id, Long orgId, String depreUseNumber, String periodNumber) {
            this.id = id;
            this.orgId = orgId;
            this.depreUseNumber = depreUseNumber;
            this.periodNumber = periodNumber;
        }

        public Long getId() {
            return this.id;
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public String getDepreUseNumber() {
            return this.depreUseNumber;
        }

        public String getPeriodNumber() {
            return this.periodNumber;
        }
    }
}

