/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class FaDepreSplitDetailEntryCopyFieldsUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(FaDepreSplitDetailEntryCopyFieldsUpgradeService.class);
    private static final String ALGO_KEY = "kd.fi.fa.upgradeservice.FaDepreSplitDetailEntryCopyFieldsUpgradeService";
    private static final DBRoute DB_ROUTE_FA = DBRoute.of((String)"fa");

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        SqlBuilder queryDepreSum = new SqlBuilder();
        queryDepreSum.append("select forgid, fdepreuseid, fperiodid from t_fa_depre;", new Object[0]);
        DataSet depreSumDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE_FA, (SqlBuilder)queryDepreSum);
        ArrayList<Object> batchInfoMap = new ArrayList<Object>();
        for (Row row : depreSumDataSet) {
            HashMap<String, Long> map = new HashMap<String, Long>(4);
            map.put("orgId", row.getLong("forgid"));
            map.put("depreUseId", row.getLong("fdepreuseid"));
            map.put("periodId", row.getLong("fperiodid"));
            batchInfoMap.add(map);
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                logger.info("\u6298\u65e7\u5206\u644a\u660e\u7ec6\u5347\u7ea7(FaDepreSplitDetailEntryCopyFieldsUpgradeService)==>\u5f00\u59cb\u5347\u7ea7\u6570\u636e");
                for (Map map : batchInfoMap) {
                    long orgId = (Long)map.get("orgId");
                    long depreUseId = (Long)map.get("depreUseId");
                    long periodId = (Long)map.get("periodId");
                    this.upgradeBatch(orgId, depreUseId, periodId);
                }
                logger.info("\u6298\u65e7\u5206\u644a\u660e\u7ec6\u5347\u7ea7(FaDepreSplitDetailEntryCopyFieldsUpgradeService)==>\u6240\u6709\u6570\u636e\u5347\u7ea7\u5b8c\u6210");
                result.setLog("fa_depresplitdetail update success");
                result.setSuccess(true);
            }
            catch (Exception e) {
                logger.error("\u6298\u65e7\u5206\u644a\u660e\u7ec6\u5347\u7ea7(FaDepreSplitDetailEntryCopyFieldsUpgradeService)==>\u5347\u7ea7\u5931\u8d25", (Throwable)e);
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog("fa_depresplitdetail update failed :" + e.getMessage());
                handle.markRollback();
            }
        }
        return result;
    }

    private void upgradeBatch(long orgId, long depreUseId, long periodId) {
        logger.info(String.format("\u6298\u65e7\u5206\u644a\u660e\u7ec6\u5347\u7ea7(FaDepreSplitDetailEntryCopyFieldsUpgradeService)==>\u5f00\u59cb\u5904\u7406\u4e00\u6279\u6570\u636e\uff0corgId=[%s]\uff0cdepreUseId=[%s]\uff0cperiodId=[%s]", orgId, depreUseId, periodId));
        SqlBuilder querySplitDetail = new SqlBuilder();
        querySplitDetail.append(" select fdetailsid, forgid, fdepreuseid, fperiodid, fassetcatid ", new Object[0]);
        querySplitDetail.append(" from t_fa_depresplitdetail ", new Object[0]);
        querySplitDetail.append(" where forgid = ? and fdepreuseid = ? and fperiodid = ?;", new Object[]{orgId, depreUseId, periodId});
        DataSet splitDetail = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE_FA, (SqlBuilder)querySplitDetail);
        String updateSql = "update t_fa_depredetailentry set forgid = ?, fdepreuseid = ?, fperiodid = ?, fassetcatid = ? where fdetailsid = ?;";
        int paramMaxSize = 1000;
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(paramMaxSize);
        for (Row row : splitDetail) {
            Object[] param = new Object[]{row.getLong("forgid"), row.getLong("fdepreuseid"), row.getLong("fperiodid"), row.getLong("fassetcatid"), row.getLong("fdetailsid")};
            updateParams.add(param);
            if (updateParams.size() != paramMaxSize) continue;
            DB.executeBatch((DBRoute)DB_ROUTE_FA, (String)updateSql, updateParams);
            updateParams.clear();
        }
        if (!updateParams.isEmpty()) {
            DB.executeBatch((DBRoute)DB_ROUTE_FA, (String)updateSql, updateParams);
        }
        logger.info("\u6298\u65e7\u5206\u644a\u660e\u7ec6\u5347\u7ea7(FaDepreSplitDetailEntryCopyFieldsUpgradeService)==>\u672c\u6279\u6570\u636e\u5904\u7406\u5b8c\u6210");
    }
}

