/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.business.depretask.DepreSplitSum;
import kd.fi.fa.business.enums.SplitMode;

public class FaDepreSplitDetailUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.fa.upgradeservice.FaDepreSplitDetailUpgradeService");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.exec();
            result.setSuccess(true);
            log.info("UPGRADE_CHANGEBILL_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_CHANGEBILL_ERROR");
            result.setErrorInfo("UPGRADE_CHANGEBILL_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void exec() {
        boolean exists = false;
        boolean metadataNotExist = false;
        try {
            exists = QueryServiceHelper.exists((String)"fa_depresplitdetail", (QFilter[])new QFilter("id", "!=", (Object)0L).toArray());
        }
        catch (Exception e) {
            metadataNotExist = true;
        }
        if (exists || metadataNotExist) {
            return;
        }
        String sql = "select forg,fdepreuseid,fbizperiodid from t_fa_card_fin where forg > 0 and fdepreuseid > 0 and fbizperiodid > 0  group by forg,fdepreuseid,fbizperiodid";
        try (DataSet ds = DB.queryDataSet((String)"FaDepreSplitDetailUpgradeService", (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
            DepreSplitSum depreSplit = new DepreSplitSum();
            for (Row row : ds) {
                Long orgId = row.getLong("forg");
                Long depreuseId = row.getLong("fdepreuseid");
                Long periodId = row.getLong("fbizperiodid");
                depreSplit.updateDepreSplit(orgId, depreuseId, periodId, false, null, SplitMode.DETAILADDREVERSE);
            }
        }
    }
}

