/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class FaDepreSumAssTypeEntryUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(FaDepreSumAssTypeEntryUpgradeService.class);
    private static final String ALGO_KEY = "kd.fi.fa.upgradeservice.FaDepreSumAssTypeEntryUpgradeService";
    private static final DBRoute DB_ROUTE_FA = DBRoute.of((String)"fa");

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        SqlBuilder queryDepreSum = new SqlBuilder();
        queryDepreSum.append("select forgid, fdepreuseid, fperiodid from t_fa_depre;", new Object[0]);
        DataSet depreSumDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE_FA, (SqlBuilder)queryDepreSum);
        ArrayList<Object> batchInfoMap = new ArrayList<Object>();
        for (Row row : depreSumDataSet) {
            HashMap<String, Long> map = new HashMap<String, Long>(4);
            map.put("orgId", row.getLong("forgid"));
            map.put("depreUseId", row.getLong("fdepreuseid"));
            map.put("periodId", row.getLong("fperiodid"));
            batchInfoMap.add(map);
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                logger.info("\u6298\u65e7\u6c47\u603b\u5347\u7ea7(FaDepreSumAssTypeEntryUpgradeService)==>\u5f00\u59cb\u5347\u7ea7\u6570\u636e");
                for (Map map : batchInfoMap) {
                    long orgId = (Long)map.get("orgId");
                    long depreUseId = (Long)map.get("depreUseId");
                    long periodId = (Long)map.get("periodId");
                    this.upgradeBatch(orgId, depreUseId, periodId);
                }
                logger.info("\u6298\u65e7\u6c47\u603b\u5347\u7ea7(FaDepreSumAssTypeEntryUpgradeService)==>\u6240\u6709\u6570\u636e\u5347\u7ea7\u5b8c\u6210");
                result.setLog("fa_depre_sum update success");
                result.setSuccess(true);
            }
            catch (Exception e) {
                logger.error("\u6298\u65e7\u6c47\u603b\u5347\u7ea7(FaDepreSumAssTypeEntryUpgradeService)==>\u5347\u7ea7\u5931\u8d25", (Throwable)e);
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog("fa_depre_sum update failed :" + e.getMessage());
                handle.markRollback();
            }
        }
        return result;
    }

    private void upgradeBatch(long orgId, long depreUseId, long periodId) {
        logger.info(String.format("\u6298\u65e7\u6c47\u603b\u5347\u7ea7(FaDepreSumAssTypeEntryUpgradeService)==>\u5f00\u59cb\u5904\u7406\u4e00\u6279\u6570\u636e\uff0corgId=[%s]\uff0cdepreUseId=[%s]\uff0cperiodId=[%s]", orgId, depreUseId, periodId));
        SqlBuilder queryDepreSum = new SqlBuilder();
        queryDepreSum.append("select fid from t_fa_depre where forgid = ? and fdepreuseid = ? and fperiodid = ?;", new Object[]{orgId, depreUseId, periodId});
        DataSet depreSumDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE_FA, (SqlBuilder)queryDepreSum);
        if (!depreSumDataSet.hasNext()) {
            logger.info("\u6298\u65e7\u6c47\u603b\u5347\u7ea7(FaDepreSumAssTypeEntryUpgradeService)==>\u672c\u6279\u6570\u636e\u672a\u67e5\u5230\u5bf9\u5e94\u7684\u6298\u65e7\u6c47\u603b\uff0c\u65e0\u9700\u5347\u7ea7");
        }
        long depreSumId = depreSumDataSet.next().getLong("fid");
        SqlBuilder queryAllAssType = new SqlBuilder();
        queryAllAssType.append("select c.fasstype from t_fa_depredetailsubentry c where c.fentryid in ( ", new Object[0]);
        queryAllAssType.append("    select b.fentryid ", new Object[0]);
        queryAllAssType.append("    from t_fa_depresplitdetail a ", new Object[0]);
        queryAllAssType.append("    left join t_fa_depredetailentry b on a.fdetailsid = b.fdetailsid ", new Object[0]);
        queryAllAssType.append("    where a.forgid = ? and a.fdepreuseid = ? and a.fperiodid = ? ", new Object[]{orgId, depreUseId, periodId});
        queryAllAssType.append(");", new Object[0]);
        DataSet allAssType = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE_FA, (SqlBuilder)queryAllAssType);
        HashSet<String> assTypeSet = new HashSet<String>();
        for (Row row : allAssType) {
            String assType = row.getString("fasstype");
            if (assType == null) continue;
            assTypeSet.add(assType);
        }
        if (assTypeSet.isEmpty()) {
            logger.info("\u6298\u65e7\u6c47\u603b\u5347\u7ea7(FaDepreSumAssTypeEntryUpgradeService)==>\u672c\u6279\u6570\u636e\u672a\u67e5\u5230\u5206\u644a\u7ef4\u5ea6\uff0c\u65e0\u9700\u5347\u7ea7");
            return;
        }
        SqlBuilder deleteHisData = new SqlBuilder();
        deleteHisData.append("delete from t_fa_depresum_assentry where fid = ?;", new Object[]{depreSumId});
        boolean isDelete = DB.execute((DBRoute)DB_ROUTE_FA, (SqlBuilder)deleteHisData);
        if (isDelete) {
            logger.info("\u6298\u65e7\u6c47\u603b\u5347\u7ea7(FaDepreSumAssTypeEntryUpgradeService)==>\u5df2\u5220\u9664\u5386\u53f2\u6570\u636e");
        }
        long[] ids = DB.genLongIds((String)"t_fa_depresum_assentry", (int)assTypeSet.size());
        int i = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(assTypeSet.size());
        for (String assType : assTypeSet) {
            Object[] param = new Object[]{depreSumId, ids[i], ++i, assType};
            insertParams.add(param);
        }
        String insert = "insert into t_fa_depresum_assentry(fid, fentryid, fseq, fasstype) values (?, ?, ?, ?);";
        int[] result = DB.executeBatch((DBRoute)DB_ROUTE_FA, (String)insert, insertParams);
        logger.info(String.format("\u6298\u65e7\u6c47\u603b\u5347\u7ea7(FaDepreSumAssTypeEntryUpgradeService)==>\u672c\u6279\u6570\u636e\u5904\u7406\u5b8c\u6bd5\uff0c\u5171\u63d2\u5165[%s]\u6761\u6570\u636e", result.length));
    }
}

