/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;

public class FaDynamicCardUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.fa.upgradeservice.FaDynamicCardUpgradeService");
    public static final String ENTITYNAME_CARD_DYNAMIC = "fa_card_dynamic";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.exec();
            result.setSuccess(true);
            log.info("UPGRADE_CHANGEBILL_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_CHANGEBILL_ERROR");
            result.setErrorInfo("UPGRADE_CHANGEBILL_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void exec() {
        String sql = "select t1.frealcardid,t1.fassetbookid,t1.fperiodid,t3.fdepreuse fdepreuseid,  case t2.fentityname   when 'fa_change_originval' then 'fa_change_dept'  when 'fa_change_assetcat' then 'fa_change_dept'  when 'fa_change_period' then 'fa_change_dept'  when 'fa_change_usestatus' then 'fa_change_dept'  else t2.fentityname  end fentityname,  t2.fchangebillid from (select frealcardmasterid frealcardid,fassetbookid,min(fperiodid) fperiodid,min(fid) fid from t_fa_changerecord where frealcardmasterid > 0 group by frealcardmasterid,fassetbookid) t1 inner join t_fa_changerecord t2 on t1.fid=t2.fid inner join t_fa_assetbook t3 on t1.fassetbookid=t3.fid;";
        try (DataSet ds = DB.queryDataSet((String)"FaDynamicCardUpgradeService", (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)ENTITYNAME_CARD_DYNAMIC);
            ArrayList<DynamicObject> dynCardLst = new ArrayList<DynamicObject>();
            for (Row row : ds) {
                DynamicObject dynCard = new DynamicObject((DynamicObjectType)type);
                dynCard.set("realcard", row.get("frealcardid"));
                dynCard.set("assetbook", row.get("fassetbookid"));
                dynCard.set("period", row.get("fperiodid"));
                dynCard.set("depreuse", row.get("fdepreuseid"));
                dynCard.set("entityname", row.get("fentityname"));
                dynCard.set("changebillid", row.get("fchangebillid"));
                dynCardLst.add(dynCard);
            }
            SaveServiceHelper.save((DynamicObject[])dynCardLst.toArray(new DynamicObject[0]));
        }
    }
}

