/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class FaFinCardImportTemplateUpgradeService
implements IUpgradeService {
    private static final DBRoute DB_ROUT_SYS = DBRoute.of((String)"sys");
    private static final String QUERY_IMPORT_TEMPLATE = "select fid from t_bas_importtemplate where fbizobject in ('fa_card_fin', 'fa_initcard_fin');";
    private static final String QUERY_BILL_HEAD = "select fid, fentryid from t_bas_importtemplateentry where fid in (%s) and ffieldkey = 'billhead';";
    private static final String QUERY_ENTRY = "select fid, fentryid from t_bas_importtemplateentry where fid in (%s) and ffieldkey = 'id';";
    private static final String UPDATE = "update t_bas_importtemplateentry set fisimport = '1' where fentryid in (%s);";
    private static final String INSERT = "INSERT INTO t_bas_importtemplateentry(fid,fisimport,fimportprop,fisfield,fparententryid,fentryid,ffieldkey,fseq,fmustinput,fdescription,fexportprop,ffieldname) VALUES (?,'1',' ','1',?,?,'id',3,'0',' ',' ',NULL); ";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result;
        block46: {
            result = new UpgradeResult();
            try (TXHandle handle = TX.requiresNew();){
                HashSet<String> ids = new HashSet<String>(4);
                try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DB_ROUT_SYS, (String)QUERY_IMPORT_TEMPLATE);){
                    dataSet.forEach(v -> ids.add(v.getLong("fid").toString()));
                }
                if (ids.isEmpty()) {
                    dataSet = result;
                    return dataSet;
                }
                String idStr = String.join((CharSequence)", ", ids);
                HashMap entryMap = new HashMap(4);
                try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DB_ROUT_SYS, (String)String.format(QUERY_ENTRY, idStr));){
                    dataSet.forEach(v -> entryMap.put(v.getLong("fid").toString(), v.getLong("fentryid").toString()));
                }
                try {
                    if (entryMap.isEmpty()) {
                        this.insert(ids, result);
                        break block46;
                    }
                    if (ids.size() == entryMap.size()) {
                        HashSet<String> entryIds = new HashSet<String>(entryMap.values());
                        this.update(entryIds, result);
                        break block46;
                    }
                    HashSet<String> idsCopy = new HashSet<String>(ids);
                    idsCopy.retainAll(entryMap.keySet());
                    HashSet<String> entryIds = new HashSet<String>(idsCopy.size());
                    idsCopy.forEach(v -> entryIds.add((String)entryMap.get(v)));
                    this.update(entryIds, result);
                    ids.removeAll(entryMap.keySet());
                    this.insert(ids, result);
                }
                catch (Exception e) {
                    result.setSuccess(false);
                    result.setErrorInfo(e.getMessage());
                    result.setLog("sql execute failed :" + e.getMessage());
                    handle.markRollback();
                }
            }
        }
        return result;
    }

    private void update(Set<String> entryIds, UpgradeResult result) {
        String entryIdStr = String.join((CharSequence)", ", entryIds);
        boolean execute = DB.execute((DBRoute)DB_ROUT_SYS, (String)String.format(UPDATE, entryIdStr));
        result.setSuccess(execute);
    }

    private void insert(Set<String> ids, UpgradeResult result) {
        String idStr = String.join((CharSequence)", ", ids);
        HashMap billHeadMap = new HashMap(4);
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DB_ROUT_SYS, (String)String.format(QUERY_BILL_HEAD, idStr));){
            dataSet.forEach(v -> billHeadMap.put(v.getLong("fid"), v.getLong("fentryid")));
        }
        long[] newEntryIds = DB.genLongIds((String)"t_bas_importtemplateentry", (int)ids.size());
        ArrayList<Object[]> param = new ArrayList<Object[]>(4);
        int i = 0;
        for (Map.Entry entry : billHeadMap.entrySet()) {
            param.add(new Object[]{entry.getKey(), entry.getValue(), newEntryIds[i++]});
        }
        int[] ints = DB.executeBatch((DBRoute)DB_ROUT_SYS, (String)INSERT, param);
        result.setSuccess(true);
        result.setLog("update count:" + ints.length);
    }
}

