/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.fa.common.util.DateUtil;

public class FaFixLeaseLiabBalanceService
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ArrayList<Object[]> updateParams;
        Throwable throwable;
        TXHandle handle;
        DBRoute faRoute;
        Object[] result;
        block29: {
            Object[] param;
            block30: {
                block31: {
                    HashMap<Long, Date> terminationDateMap;
                    ArrayList<Long> contractIds;
                    block26: {
                        Iterator iterator;
                        block27: {
                            block28: {
                                result = new UpgradeResult();
                                faRoute = DBRoute.of((String)"fa");
                                handle = TX.requiresNew();
                                throwable = null;
                                String queryTerminationContract = "select fid, fleaseterminationdate from t_fa_lease_contract_new where fbizstatus = 'B' and fisbak = '0' and fleaseenddate > fleaseterminationdate and fisexempt = '0';";
                                DataSet terminationContract = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)faRoute, (String)queryTerminationContract);
                                contractIds = new ArrayList<Long>(32);
                                terminationDateMap = new HashMap<Long, Date>(32);
                                for (Row row : terminationContract) {
                                    Long contractId = row.getLong("fid");
                                    contractIds.add(contractId);
                                    Date terminationDate = row.getDate("fleaseterminationdate");
                                    terminationDateMap.put(contractId, terminationDate);
                                }
                                if (!contractIds.isEmpty()) break block26;
                                result.setSuccess(true);
                                result.setLog("haven't termination contract, needn't update data.");
                                iterator = result;
                                if (handle == null) break block27;
                                if (throwable == null) break block28;
                                try {
                                    handle.close();
                                }
                                catch (Throwable row) {
                                    throwable.addSuppressed(row);
                                }
                                break block27;
                            }
                            handle.close();
                        }
                        return iterator;
                    }
                    SqlBuilder queryInterestDetail = new SqlBuilder();
                    queryInterestDetail.append("select a.fleasecontractid, b.fdate, b.fendbalance, b.fleaseliabint ", new Object[0]);
                    queryInterestDetail.append("from t_fa_interest_detail a left join t_fa_interest_detail_e b ", new Object[0]);
                    queryInterestDetail.append("on a.fid = b.fid ", new Object[0]);
                    queryInterestDetail.append("where ", new Object[0]);
                    queryInterestDetail.appendIn("a.fleasecontractid ", contractIds);
                    queryInterestDetail.append(" and b.fsourcetype != 'B' ", new Object[0]);
                    queryInterestDetail.append("order by a.fleasecontractid, b.fdate asc;", new Object[0]);
                    DataSet interestDetail = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)faRoute, (SqlBuilder)queryInterestDetail);
                    updateParams = new ArrayList<Object[]>(contractIds.size());
                    long lastContractId = -1L;
                    long curContractId = -1L;
                    BigDecimal leaseLiabOriBalance = BigDecimal.ZERO;
                    BigDecimal leaseLiabBalance = BigDecimal.ZERO;
                    for (Row row : interestDetail) {
                        Long contractId = row.getLong("fleasecontractid");
                        if (curContractId == -1L) {
                            curContractId = contractId;
                        }
                        if (contractId != curContractId) {
                            Object[] param2 = new Object[]{leaseLiabOriBalance, leaseLiabBalance, curContractId};
                            updateParams.add(param2);
                            lastContractId = curContractId;
                            curContractId = contractId;
                            leaseLiabOriBalance = BigDecimal.ZERO;
                            leaseLiabBalance = BigDecimal.ZERO;
                        }
                        Date terminationDate = (Date)terminationDateMap.get(contractId);
                        Date date = row.getDate("fdate");
                        if (DateUtil.compareDate((Date)date, (Date)terminationDate) < 0) continue;
                        if (DateUtil.isSameDay((Date)date, (Date)terminationDate)) {
                            BigDecimal endBalance;
                            leaseLiabOriBalance = endBalance = row.getBigDecimal("fendbalance");
                            leaseLiabBalance = endBalance;
                            continue;
                        }
                        BigDecimal leaseLiabInt = row.getBigDecimal("fleaseliabint");
                        leaseLiabOriBalance = leaseLiabOriBalance.add(leaseLiabInt);
                    }
                    if (lastContractId != curContractId) {
                        param = new Object[]{leaseLiabOriBalance, leaseLiabBalance, curContractId};
                        updateParams.add(param);
                    }
                    if (!updateParams.isEmpty()) break block29;
                    result.setSuccess(true);
                    result.setLog("haven't update params, needn't update data.");
                    param = result;
                    if (handle == null) break block30;
                    if (throwable == null) break block31;
                    try {
                        handle.close();
                    }
                    catch (Throwable row) {
                        throwable.addSuppressed(row);
                    }
                    break block30;
                }
                handle.close();
            }
            return param;
        }
        try {
            try {
                String updateContract = "update t_fa_lease_contract_new set fleaseliaboribalance = ?, fleaseliabbalance = ? where fid = ?;";
                int[] successNum = DB.executeBatch((DBRoute)faRoute, (String)updateContract, updateParams);
                result.setLog("contract update success count: " + successNum.length);
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog("contract update failed :" + e.getMessage());
                handle.markRollback();
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        catch (Throwable throwable3) {
            throw throwable3;
        }
        finally {
            if (handle != null) {
                if (throwable != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    handle.close();
                }
            }
        }
        return result;
    }
}

