/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.sql.ResultSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.business.utils.FaHisFinIsneeddepreUpgradeUtil;

public class FaHisFinIsneeddepreUpgradeService
implements IUpgradeService,
ResultSetHandler<Long> {
    private static final Log log = LogFactory.getLog((String)"kd.fi.fa.upgradeservice.FaHisFinIsneeddepreUpgradeService");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            Long startTime = System.currentTimeMillis();
            String finCountSql = "select count(fid) counts from t_fa_card_fin where 1=1";
            Long allCounts = (Long)DB.query((DBRoute)FaConstants.faDBRoute, (String)finCountSql, (ResultSetHandler)this);
            if (allCounts > 8000000L) {
                result.setSuccess(true);
                log.info("FaHisFinIsneeddepreUpgradeService_largethan500_SUCCESS");
                return result;
            }
            FaHisFinIsneeddepreUpgradeUtil.hisFinIsneeddepreUpgrade();
            result.setSuccess(true);
            log.info("FaHisFinIsneeddepreUpgradeService_SUCCESS");
            Long endTime = System.currentTimeMillis();
            Long totalTime = (endTime - startTime) / 1000L;
            log.info(String.format("FaHisFinIsneeddepreUpgradeService\u603b\u5171\u8017\u65f6\uff1a%s s", totalTime));
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("FaHisFinIsneeddepreUpgradeService_ERROR");
            result.setErrorInfo("FaHisFinIsneeddepreUpgradeService_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    public Long handle(ResultSet rs) throws Exception {
        try {
            if (rs.next()) {
                Long counts;
                Long l = counts = Long.valueOf(rs.getLong("counts"));
                return l;
            }
            Long counts = 0L;
            return counts;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }
}

