/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.botp.ConvertDataService;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.ExceptionUtils;

public class FaInitLeaseContractBotpUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.fa.upgradeservice.FaInitLeaseContractBotpUpgradeService");

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            SqlBuilder sqlQuery = new SqlBuilder();
            sqlQuery.append("select fid, fsrcbillid, fcreatetime from t_fa_card_real where fsourceflag = 'INITLEASECONTRACT' and fisbak = '1'", new Object[0]);
            List initRealCards = (List)DB.query((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlQuery, resultSet -> {
                ArrayList list = new ArrayList(1024);
                while (resultSet.next()) {
                    HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>(8);
                    map.put("id", Long.valueOf(resultSet.getLong("fid")));
                    map.put("srcbillid", Long.valueOf(resultSet.getLong("fsrcbillid")));
                    map.put("createtime", resultSet.getDate("fcreatetime"));
                    list.add(map);
                }
                return list;
            });
            ConvertDataService reader = new ConvertDataService();
            TableDefine leaseTableDefine = reader.loadTableDefine("fa_lease_contract", "fa_lease_contract");
            TableDefine realCardTableDefine = reader.loadTableDefine("fa_card_real", "fa_card_real");
            Long leaseTableId = leaseTableDefine.getTableId();
            Long realCardTableId = realCardTableDefine.getTableId();
            if (!initRealCards.isEmpty()) {
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("select ftbillid from t_botp_billtracker where ", new Object[0]);
                sqlBuilder.append("fstableid = ?", new Object[]{leaseTableId});
                sqlBuilder.append(" and fttableid = ?", new Object[]{realCardTableId});
                sqlBuilder.appendIn(" and ftbillid", initRealCards.stream().map(v -> v.get("id")).distinct().toArray());
                Set realCards = (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, rs -> {
                    HashSet<Long> ids = new HashSet<Long>(200);
                    while (rs.next()) {
                        ids.add(rs.getLong("ftbillid"));
                    }
                    return ids;
                });
                if (!realCards.isEmpty()) {
                    initRealCards.removeIf(realCard -> realCards.contains(realCard.get("id")));
                }
            }
            if (!initRealCards.isEmpty()) {
                long[] ids = DBServiceHelper.genLongIds((String)"T_BOTP_BILLTRACKER", (int)initRealCards.size());
                ArrayList<Object[]> params = new ArrayList<Object[]>(initRealCards.size());
                for (int i = 0; i < initRealCards.size(); ++i) {
                    Object[] objs = new Object[]{ids[i], leaseTableId, ((Map)initRealCards.get(i)).get("srcbillid"), realCardTableId, ((Map)initRealCards.get(i)).get("id"), ((Map)initRealCards.get(i)).get("createtime")};
                    params.add(objs);
                }
                String sql = "INSERT INTO T_BOTP_BILLTRACKER (FID, FSTABLEID, FSBILLID, FTTABLEID, FTBILLID, FCREATETIME) VALUES (?, ?, ?, ?, ?, ?)";
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, params);
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_ERROR");
            result.setErrorInfo("UPGRADE_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }
}

