/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.business.utils.FaFindPeriodHelper;

public class FaLeaseInit4AssetBookUpgradeService
implements IUpgradeService {
    private static final DBRoute FA = DBRoute.of((String)"fa");

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle h = TX.required();){
            try {
                this.upgrade();
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo("FaLeaseInit4AssetBookUpgradeService_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                h.markRollback();
            }
        }
        return result;
    }

    private void upgrade() {
        SqlBuilder leaseSql = new SqlBuilder();
        leaseSql.append("select forgid, fsysswitchdate from t_fa_lease_contract_new group by forgid, fsysswitchdate having forgid not in (select forgid from t_fa_lease_init)", new Object[0]);
        DataSet leaseDataSet = DB.queryDataSet((String)(this.getClass().getName() + "_query_lease"), (DBRoute)FA, (SqlBuilder)leaseSql);
        if (leaseDataSet.isEmpty()) {
            return;
        }
        HashMap<Long, Date> org2SysSwitchDateMap = new HashMap<Long, Date>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (Row row : leaseDataSet) {
            Long orgId = row.getLong("forgid");
            orgIds.add(orgId);
            Date sysSwitchDate = row.getDate("fsysswitchdate");
            if (sysSwitchDate == null) continue;
            org2SysSwitchDateMap.put(orgId, sysSwitchDate);
        }
        Map<Long, Object[]> org2NumberAndName = this.queryOrgData(orgIds);
        HashMap<Long, Object[]> org2LeaseInitObject = new HashMap<Long, Object[]>(orgIds.size());
        HashMap<Long, Set<Long>> periodType2OrgSet = new HashMap<Long, Set<Long>>(2);
        HashMap<Long, Long> orgId2LeaseInitIdMap = new HashMap<Long, Long>(orgIds.size());
        this.genLeaseInitData(org2SysSwitchDateMap, orgIds, org2NumberAndName, org2LeaseInitObject, periodType2OrgSet, orgId2LeaseInitIdMap);
        if (org2LeaseInitObject.isEmpty()) {
            return;
        }
        this.updateEnablePeriodAndSysSwitchDate(org2SysSwitchDateMap, org2LeaseInitObject, periodType2OrgSet);
        String insertSql = "insert into t_fa_lease_init (fid, fnumber, fname, fstatus, fcreatorid, fmodifierid, fenable, fcreatetime, fmodifytime, fmasterid, forgid, fperiodtypeid, fenableperiodid, fcurrentperiodid, fsystemswitchday, fbasecurrencyid, fdepresystemid, fexchangetableid) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        DB.executeBatch((DBRoute)FA, (String)insertSql, new ArrayList(org2LeaseInitObject.values()));
        ArrayList<Object[]> leaseInitLanguageObject = new ArrayList<Object[]>(orgIds.size());
        Set leaseInitOrgIds = org2LeaseInitObject.keySet();
        SqlBuilder orgLSql = new SqlBuilder();
        orgLSql.append("select fid, fpkid, flocaleid, fname from t_org_org_l where ", new Object[0]);
        orgLSql.appendIn("fid", leaseInitOrgIds.toArray());
        DataSet orgLDataSet = DB.queryDataSet((String)(this.getClass().getName() + "_query_org_l"), (DBRoute)DBRoute.base, (SqlBuilder)orgLSql);
        for (Row orgL : orgLDataSet) {
            Long orgId = orgL.getLong("fid");
            String pkId = orgL.getString("fpkid");
            String localeId = orgL.getString("flocaleid");
            String name = orgL.getString("fname");
            Long id = (Long)orgId2LeaseInitIdMap.get(orgId);
            Object[] objL = new Object[]{pkId, id, localeId, name};
            leaseInitLanguageObject.add(objL);
        }
        String insertLeaseInitL = "insert into t_fa_lease_init_l (fpkid, fid, flocaleid, fname) values (?, ?, ?, ?)";
        DB.executeBatch((DBRoute)FA, (String)insertLeaseInitL, leaseInitLanguageObject);
    }

    private void genLeaseInitData(Map<Long, Date> org2SysSwitchDateMap, Set<Long> orgIds, Map<Long, Object[]> org2NumberAndName, Map<Long, Object[]> org2LeaseInitObject, Map<Long, Set<Long>> periodType2OrgSet, Map<Long, Long> orgId2LeaseInitIdMap) {
        SqlBuilder assetBookSql = new SqlBuilder();
        assetBookSql.append("select a.fismainbook, a.forgid, a.fbasecurrencyid, a.fdepresystemid, a.fdepresystemid, a.fexchangetableid, a.facctperiodtypeid, a.fenableperiodid, a.fcurrentperiodid, a.fcreatorid, a.fmodifierid, a.fcreatetime, a.fmodifytime, a.fmodifytime, b.fbegindate", new Object[0]);
        assetBookSql.append(" from t_fa_assetbook a left join t_bd_period b on a.fenableperiodid = b.fid and a.facctperiodtypeid = b.ftypeid", new Object[0]);
        assetBookSql.appendIn(" where forgid", orgIds.toArray());
        assetBookSql.append(" and fismainbook = '1'", new Object[0]);
        DataSet assetBookDataSet = DB.queryDataSet((String)(this.getClass().getName() + "_query_assetBook"), (DBRoute)FA, (SqlBuilder)assetBookSql);
        long[] ids = DBServiceHelper.genLongIds((String)"t_fa_lease_init", (int)orgIds.size());
        int i = 0;
        for (Row row : assetBookDataSet) {
            Long orgId = row.getLong("forgid");
            Long baseCurrencyId = row.getLong("fbasecurrencyid");
            Long depreSystemId = row.getLong("fdepresystemid");
            Long exchangeTableId = row.getLong("fexchangetableid");
            Long periodTypeId = row.getLong("facctperiodtypeid");
            Long enablePeriodId = row.getLong("fenableperiodid");
            Long currentPeriodId = row.getLong("fcurrentperiodid");
            Long creatorId = row.getLong("fcreatorid");
            Long modifierId = row.getLong("fmodifierid");
            Date createTime = row.getDate("fcreatetime");
            Date modifyTime = row.getDate("fmodifytime");
            Date enablePeriodBeginDate = row.getDate("fbegindate");
            if (org2SysSwitchDateMap.containsKey(orgId)) {
                Set orgSet = periodType2OrgSet.computeIfAbsent(periodTypeId, k -> new HashSet(16));
                orgSet.add(orgId);
            }
            Object[] orgNumberAndName = org2NumberAndName.get(orgId);
            long id = ids[i];
            Object[] obj = new Object[]{id, orgNumberAndName[0], orgNumberAndName[1], "C", creatorId, modifierId, "1", createTime, modifyTime, id, orgId, periodTypeId, enablePeriodId, currentPeriodId, enablePeriodBeginDate, baseCurrencyId, depreSystemId, exchangeTableId};
            org2LeaseInitObject.put(orgId, obj);
            orgId2LeaseInitIdMap.put(orgId, id);
            ++i;
        }
    }

    private void updateEnablePeriodAndSysSwitchDate(Map<Long, Date> org2SysSwitchDateMap, Map<Long, Object[]> org2LeaseInitObject, Map<Long, Set<Long>> periodType2OrgSet) {
        if (org2SysSwitchDateMap.isEmpty()) {
            return;
        }
        HashMap<Long, Long> org2PeriodMap = new HashMap<Long, Long>(org2SysSwitchDateMap.size());
        for (Map.Entry<Long, Set<Long>> entry : periodType2OrgSet.entrySet()) {
            Long periodTypeId = entry.getKey();
            Set<Long> orgIdSet = entry.getValue();
            FaFindPeriodHelper faFindPeriodHelper = new FaFindPeriodHelper(periodTypeId);
            for (Long orgId : orgIdSet) {
                Long periodIdByDate = faFindPeriodHelper.findPeriodIdByDate(org2SysSwitchDateMap.get(orgId));
                org2PeriodMap.put(orgId, periodIdByDate);
            }
        }
        for (Map.Entry<Long, Set<Long>> entry : org2PeriodMap.entrySet()) {
            Long orgId = entry.getKey();
            Long periodId = (Long)((Object)entry.getValue());
            Object[] obj = org2LeaseInitObject.get(orgId);
            obj[12] = periodId;
            long currentPeriodId = (Long)obj[13];
            if (currentPeriodId < periodId) {
                obj[13] = periodId;
            }
            obj[14] = org2SysSwitchDateMap.get(orgId);
        }
    }

    private Map<Long, Object[]> queryOrgData(Set<Long> orgIds) {
        SqlBuilder orgSql = new SqlBuilder();
        orgSql.append("select fid, fname, fnumber from t_org_org where ", new Object[0]);
        orgSql.appendIn("fid", orgIds.toArray());
        DataSet orgDataSet = DB.queryDataSet((String)(this.getClass().getName() + "_query_org"), (DBRoute)DBRoute.base, (SqlBuilder)orgSql);
        HashMap<Long, Object[]> org2NumberAndName = new HashMap<Long, Object[]>(orgIds.size());
        for (Row row : orgDataSet) {
            Long orgId = row.getLong("fid");
            String name = row.getString("fname");
            String number = row.getString("fnumber");
            Object[] obj = new Object[]{number, name};
            org2NumberAndName.put(orgId, obj);
        }
        return org2NumberAndName;
    }
}

