/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.fa.business.utils.FaFindPeriodHelper;
import kd.fi.fa.upgradeservice.ClearBill;
import kd.fi.fa.upgradeservice.TermRecords;

public class FaLeaseTermRecordsUpgradeService
implements IUpgradeService {
    private static final String ALGO_KEY = FaLeaseTermRecordsUpgradeService.class.getName();
    private static final DBRoute DB_ROUT_FA = DBRoute.of((String)"fa");
    private final Map<Long, FaFindPeriodHelper> findPeriodHelperMap = new HashMap<Long, FaFindPeriodHelper>(16);
    private final Map<Long, Long> periodTypeIdMap = new HashMap<Long, Long>(16);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle handle = TX.requiresNew();){
            try {
                this.upgrade();
                result.setLog("lease termination records update success");
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog("lease termination records update failed :" + e.getMessage());
                handle.markRollback();
            }
        }
        return result;
    }

    private void upgrade() {
        Long id;
        Long clearBillId;
        String queryExistTermRecords = "select fid, fleasecontractid from t_fa_lease_term_records where fundotermination = '0';";
        DataSet existTermRecordsDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUT_FA, (String)queryExistTermRecords);
        HashSet<Long> hasTermRecordsContractIdSet = new HashSet<Long>(16);
        for (Row row : existTermRecordsDataSet) {
            Long leaseContractId = row.getLong("fleasecontractid");
            hasTermRecordsContractIdSet.add(leaseContractId);
        }
        String queryTerminationContractSql = "select fid, forgid, fleaseterminationdate, frenewalcontractid, fclearbillid, fmodifierid, fmodifytime from t_fa_lease_contract_new where fisbak = '0' and fbizstatus = 'B';";
        DataSet terminationContractDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUT_FA, (String)queryTerminationContractSql);
        ArrayList<Long> clearBillIdList = new ArrayList<Long>(10);
        HashMap<Long, Long> contractClearBillMap = new HashMap<Long, Long>(16);
        ArrayList<Long> renewalContractIdList = new ArrayList<Long>(10);
        HashMap<Long, Long> renewalContractMap = new HashMap<Long, Long>(16);
        ArrayList<TermRecords> termRecordsList = new ArrayList<TermRecords>(10);
        for (Row row : terminationContractDataSet) {
            Long leaseContractId = row.getLong("fid");
            if (hasTermRecordsContractIdSet.contains(leaseContractId)) continue;
            Iterator leaseTerminationDate = row.getDate("fleaseterminationdate");
            Long renewalContractId = row.getLong("frenewalcontractid");
            clearBillId = row.getLong("fclearbillid");
            Long modifierId = row.getLong("fmodifierid");
            Date modifyTime = row.getDate("fmodifytime");
            TermRecords termRecords = new TermRecords(leaseContractId, (Date)((Object)leaseTerminationDate), modifierId, modifyTime);
            termRecordsList.add(termRecords);
            if (renewalContractId != 0L) {
                renewalContractIdList.add(renewalContractId);
                renewalContractMap.put(leaseContractId, renewalContractId);
            }
            if (clearBillId != 0L) {
                clearBillIdList.add(clearBillId);
                contractClearBillMap.put(leaseContractId, clearBillId);
                continue;
            }
            termRecords.setAmortizationDate((Date)((Object)leaseTerminationDate));
            Long orgId = row.getLong("forgid");
            Long amortizationPeriodId = this.findPeriodId(orgId, (Date)((Object)leaseTerminationDate));
            termRecords.setAmortizationPeriodId(amortizationPeriodId);
        }
        if (!clearBillIdList.isEmpty()) {
            SqlBuilder queryClearBillSql = new SqlBuilder();
            queryClearBillSql.append("select fid, fcleardate, fclearperiodid, fchangemodeid from t_fa_clrbill where ", new Object[0]);
            queryClearBillSql.appendIn(" fid ", clearBillIdList);
            DataSet clearBillDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUT_FA, (SqlBuilder)queryClearBillSql);
            HashMap<Long, ClearBill> clearBillMap = new HashMap<Long, ClearBill>(16);
            for (Row row : clearBillDataSet) {
                id = row.getLong("fid");
                Date clearDate = row.getDate("fcleardate");
                Long clearPeriodId = row.getLong("fclearperiodid");
                Long changeModeId = row.getLong("fchangemodeid");
                ClearBill clearBill = new ClearBill(id, clearDate, clearPeriodId, changeModeId);
                clearBillMap.put(id, clearBill);
            }
            if (!clearBillMap.isEmpty()) {
                for (TermRecords records : termRecordsList) {
                    ClearBill clearBill;
                    clearBillId = (Long)contractClearBillMap.get(records.getLeaseContractId());
                    if (clearBillId == null || (clearBill = (ClearBill)clearBillMap.get(clearBillId)) == null) continue;
                    records.setAmortizationDate(clearBill.getClearDate());
                    records.setAmortizationPeriodId(clearBill.getClearPeriodId());
                    records.setChangeModeId(clearBill.getChangeModeId());
                }
            }
        }
        if (!renewalContractIdList.isEmpty()) {
            SqlBuilder queryRenewalContractSql = new SqlBuilder();
            queryRenewalContractSql.append("select fid, fleaseenddate from t_fa_lease_contract_new where ", new Object[0]);
            queryRenewalContractSql.appendIn(" fid ", renewalContractIdList);
            DataSet renewalContractDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUT_FA, (SqlBuilder)queryRenewalContractSql);
            HashMap<Long, Date> renewalEndDateMap = new HashMap<Long, Date>(16);
            for (Row row : renewalContractDataSet) {
                id = row.getLong("fid");
                Date leaseEndDate = row.getDate("fleaseenddate");
                renewalEndDateMap.put(id, leaseEndDate);
            }
            if (!renewalEndDateMap.isEmpty()) {
                for (TermRecords records : termRecordsList) {
                    Long renewalContractId = (Long)renewalContractMap.get(records.getLeaseContractId());
                    if (renewalContractId == null) continue;
                    records.setRenewalEndDate((Date)renewalEndDateMap.get(renewalContractId));
                }
            }
        }
        if (termRecordsList.isEmpty()) {
            return;
        }
        long[] ids = DB.genLongIds((String)"famortizationperiodid", (int)termRecordsList.size());
        String insertRecordsSql = "INSERT INTO t_fa_lease_term_records (fid, fleasecontractid, fleaseterminationdate, fchangemodeid, frenewalenddate, ftermoperuserid, fundotermination, famortizationdate, famortizationperiodid, ftermoperdate) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        int i = 0;
        for (TermRecords records : termRecordsList) {
            Object[] param = new Object[]{ids[i++], records.getLeaseContractId(), records.getLeaseTerminationDate(), records.getChangeModeId(), records.getRenewalEndDate(), records.getTermOperUserId(), "0", records.getAmortizationDate(), records.getAmortizationPeriodId(), records.getTermOperDate()};
            paramList.add(param);
        }
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)DB_ROUT_FA, (String)insertRecordsSql, paramList);
        }
    }

    private Long findPeriodId(long orgId, Date date) {
        Long periodTypeId = this.getPeriodTypeId(orgId);
        FaFindPeriodHelper helper = this.findPeriodHelperMap.computeIfAbsent(periodTypeId, v -> new FaFindPeriodHelper(periodTypeId));
        return helper.findPeriodIdByDate(date);
    }

    private Long getPeriodTypeId(long orgId) {
        if (this.periodTypeIdMap.containsKey(orgId)) {
            return this.periodTypeIdMap.get(orgId);
        }
        String queryLeaseInitSql = "select fid, forgid, fperiodtypeid from t_fa_lease_init;";
        DataSet leaseInitDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUT_FA, (String)queryLeaseInitSql);
        for (Row row : leaseInitDataSet) {
            Long orgIdQuery = row.getLong("forgid");
            Long periodTypeId = row.getLong("fperiodtypeid");
            this.periodTypeIdMap.put(orgIdQuery, periodTypeId);
        }
        return this.periodTypeIdMap.get(orgId);
    }
}

