/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.fa.business.enums.lease.TransitionPlan;
import kd.fi.fa.business.lease.utils.LeaseUtil;

public class FaLeaseTransitionPlanUpgradeService
implements IUpgradeService {
    private static final String DB_ROUT_FA = "fa";
    private static final String QUERY_ALL_LEASE_CONTRACT = "SELECT FID, FLEASESTARTDATE, FFREELEASESTARTDATE, FISEXEMPT FROM T_FA_LEASE_CONTRACT_NEW;";
    private static final String UPDATE_LEASE_CONTRACT = "UPDATE T_FA_LEASE_CONTRACT_NEW SET FLEASETERMSTARTDATE = ?, FTRANSITIONPLAN = ? WHERE FID = ?;";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        List updateDatas;
        DBRoute fa;
        Throwable throwable;
        TXHandle handle;
        UpgradeResult result;
        block17: {
            UpgradeResult upgradeResult;
            block18: {
                block19: {
                    result = new UpgradeResult();
                    handle = TX.requiresNew();
                    throwable = null;
                    fa = DBRoute.of((String)DB_ROUT_FA);
                    updateDatas = (List)DB.query((DBRoute)fa, (String)QUERY_ALL_LEASE_CONTRACT, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

                        public List<Object[]> handle(ResultSet rs) throws Exception {
                            ArrayList<Object[]> result = new ArrayList<Object[]>(16);
                            while (rs.next()) {
                                java.sql.Date leaseStartDate = rs.getDate("FLEASESTARTDATE");
                                java.sql.Date freeLeaseStartDate = rs.getDate("FFREELEASESTARTDATE");
                                java.sql.Date leaseTermStartDate = freeLeaseStartDate != null ? freeLeaseStartDate : leaseStartDate;
                                if (leaseStartDate == null) continue;
                                boolean isExempt = rs.getBoolean("FISEXEMPT");
                                boolean isStock = LeaseUtil.isStockContract((Date)leaseTermStartDate, (boolean)isExempt);
                                Object[] param = new Object[]{leaseTermStartDate, isStock ? TransitionPlan.B.name() : "", rs.getLong("FID")};
                                result.add(param);
                            }
                            return result;
                        }
                    });
                    if (updateDatas != null && !updateDatas.isEmpty()) break block17;
                    result.setSuccess(true);
                    result.setLog("haven't lease contract need update.");
                    upgradeResult = result;
                    if (handle == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                handle.close();
            }
            return upgradeResult;
        }
        try {
            try {
                int[] successNum = DB.executeBatch((DBRoute)fa, (String)UPDATE_LEASE_CONTRACT, (List)updateDatas);
                result.setLog("lease contract update success count: " + successNum.length);
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog("lease contract update failed :" + e.getMessage());
                handle.markRollback();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (handle != null) {
                if (throwable != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    handle.close();
                }
            }
        }
        return result;
    }
}

