/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.common.util.Fa;

public class FaMonthOrigvalChgUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(FaMonthOrigvalChgUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.updateFinMonOriginal();
            result.setSuccess(true);
            log.info("UPDATE FMONTHORIGVALCHG T_FA_CARD_FIN SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPDATE FMONTHORIGVALCHG T_FA_CARD_FIN ERROR");
            result.setErrorInfo("UPDATE FMONTHORIGVALCHG T_FA_CARD_FIN ERROR !" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void updateFinMonOriginal() {
        List orgListTemp;
        Long depreUseIdTemp;
        String selectFields = Fa.comma((String[])new String[]{"org", "depreuse"});
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)selectFields, null);
        HashMap<Long, ArrayList<Long>> depreUseId2OrgIdListMap = new HashMap<Long, ArrayList<Long>>(2, 1.0f);
        for (DynamicObject book : books) {
            Long depreUseId = book.getLong("depreuse");
            Long orgId = book.getLong("org");
            ArrayList<Long> orgIdList = (ArrayList<Long>)depreUseId2OrgIdListMap.get(depreUseId);
            if (orgIdList == null) {
                orgIdList = new ArrayList<Long>(books.size());
                depreUseId2OrgIdListMap.put(depreUseId, orgIdList);
            }
            orgIdList.add(orgId);
        }
        HashMap depreUseId2OrgIdGroupList = new HashMap();
        boolean isManyOrg = false;
        if (books.size() > 1000) {
            isManyOrg = true;
            for (Map.Entry entry : depreUseId2OrgIdListMap.entrySet()) {
                depreUseIdTemp = (Long)entry.getKey();
                orgListTemp = (List)entry.getValue();
                ArrayList orgListBatch = new ArrayList(orgListTemp.size() / 10 + 1);
                ArrayList<Long> orgListTemp2 = new ArrayList<Long>(10);
                orgListBatch.add(orgListTemp2);
                for (Long orgTemp : orgListTemp) {
                    if (orgListTemp2.size() == 10) {
                        orgListTemp2 = new ArrayList(10);
                        orgListBatch.add(orgListTemp2);
                    }
                    orgListTemp2.add(orgTemp);
                }
                depreUseId2OrgIdGroupList.put(depreUseIdTemp, orgListBatch);
            }
        }
        if (isManyOrg) {
            for (Map.Entry entry : depreUseId2OrgIdGroupList.entrySet()) {
                depreUseIdTemp = (Long)entry.getKey();
                List orgListBatch = (List)entry.getValue();
                for (List orgListTemp2 : orgListBatch) {
                    this.updateInitFinMonthOrigvalChg4Many(orgListTemp2, depreUseIdTemp);
                }
            }
        } else {
            for (Map.Entry entry : depreUseId2OrgIdListMap.entrySet()) {
                depreUseIdTemp = (Long)entry.getKey();
                orgListTemp = (List)entry.getValue();
                for (Long orgTemp : orgListTemp) {
                    this.updateInitFinMonthOrigvalChg4One(orgTemp, depreUseIdTemp);
                }
            }
        }
    }

    private void updateInitFinMonthOrigvalChg4One(Long orgId, Long depreUseId) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("update T_FA_CARD_FIN set ", new Object[0]).append("fmonthorigvalchg = 0,", new Object[0]).append("fyearorigvalchg = 0", new Object[0]).append(" where ", new Object[0]).append("forg = ?", new Object[]{orgId}).append(" and fdepreuseid = ?", new Object[]{depreUseId}).append(" and fbizperiodid = 0", new Object[0]).append(" and fmonthorigvalchg != 0", new Object[0]);
        DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
    }

    private void updateInitFinMonthOrigvalChg4Many(List<Long> orgIdList, Long depreUseId) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("update T_FA_CARD_FIN set ", new Object[0]).append("fmonthorigvalchg = 0,", new Object[0]).append("fyearorigvalchg = 0", new Object[0]).append(" where ", new Object[0]).appendIn("forg ", orgIdList.toArray()).append(" and fdepreuseid = ?", new Object[]{depreUseId}).append(" and fbizperiodid = 0", new Object[0]).append(" and fmonthorigvalchg != 0", new Object[0]);
        DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
    }
}

