/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.ExceptionUtils;

public class FaPurchaseAssetNameUpgradeService
implements IUpgradeService {
    private static final DBRoute FA = DBRoute.of((String)"fa");

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle h = TX.requiresNew();){
            try {
                this.upgrade();
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo("FaPurchaseAssetNameUpgradeService_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                h.markRollback();
            }
        }
        return result;
    }

    private void upgrade() {
        this.insertDataUpgrade();
        this.updateUpgrade();
    }

    private void updateUpgrade() {
        String updateSql = "update t_fa_purchasebillentry_l b set fname = (select fname from t_fa_purchasebillentry a where b.fentryid = a.fentryid) where b.fname = ' '";
        DB.update((DBRoute)FA, (String)updateSql);
    }

    private void insertDataUpgrade() {
        String needInsertDataSql = "select a.fentryid, a.fname from t_fa_purchasebillentry a left join t_fa_purchasebillentry_l b on a.fentryid = b.fentryid where b.fname is null";
        DataSet needInsertDataSet = DB.queryDataSet((String)(this.getClass().getName() + "_query_hasMuliLangData"), (DBRoute)FA, (String)needInsertDataSql);
        HashMap<Long, String> entryId2NameMap = new HashMap<Long, String>(64);
        for (Row row : needInsertDataSet) {
            entryId2NameMap.put(row.getLong("fentryid"), row.getString("fname"));
        }
        if (!entryId2NameMap.isEmpty()) {
            ArrayList<Object[]> purchaseLangList = new ArrayList<Object[]>(entryId2NameMap.size());
            String[] pkIds = DBServiceHelper.genStringIds((String)"t_fa_purchasebillentry_l", (int)entryId2NameMap.size());
            int i = 0;
            for (Map.Entry entry : entryId2NameMap.entrySet()) {
                Object[] objL = new Object[]{pkIds[i], entry.getKey(), "zh_CN", entry.getValue()};
                purchaseLangList.add(objL);
                ++i;
            }
            String insertPurchaseLangL = "insert into t_fa_purchasebillentry_l (fpkid, fentryid, flocaleid, fname) values (?, ?, ?, ?)";
            DB.executeBatch((DBRoute)FA, (String)insertPurchaseLangL, purchaseLangList);
        }
    }
}

