/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.sql.Date;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.common.util.Fa;

public class FaRealCardInsertPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(FaRealCardInsertPlugin.class);
    private static final String REALCARDENTITY = "realcardentity";
    private static final String CURCARDID = "curcardid";
    private static final String REALCURPROGRESS = "realcurprogress";
    private static final String ASSETUNIT = "assetunit";
    private static final String ASSETCAT = "assetcat";
    private static final String ASSCAT = "asscat";
    private static final String CURASSETINDEX = "curassetindex";
    private static final String ASSETBOOK = "assetbook";
    private static final String MONTHQTY = "monthqty";
    private static final String CURMONTHINDEX = "curmonthindex";
    private static final String QTY = "qty";
    private static final String TOTALQTY = "totalqty";
    private static final String PREFIX = "prefix";
    private static final String DYNAMICPROPORTION = "dynamicproportion";
    private static final String DYQTY = "dyqty";
    private static final String GEN_CARD_TIME = "gencardtime";
    private static final DecimalFormat df = new DecimalFormat("000");
    private static final DecimalFormat df1 = new DecimalFormat("000000");
    private static final DecimalFormat df2 = new DecimalFormat("00000000");
    private int originalVal;
    private static final int BASEACCUMDEPRE = 25;
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final DBRoute FA = DBRoute.of((String)"fa");
    private static final DBRoute SYS = DBRoute.basedata;
    private static final ThreadPool THREADPOOL = ThreadPools.newFixedThreadPool((String)"kd.fi.fa.upgradeservice.FaRealCardInsertPlugin", (int)10);
    private static final int BATCH_SIZE = 1000;
    private static final String INSERT_REAL_CARDS = "INSERT INTO t_fa_card_real(FORIGINALDATA,FUNITID,FMASTERID,FASSETQTY,FISSTORAGED,FCREATETIME,FREMARK,FNUMBERRECOVERY,FSOURCEENTRYID,FHASVOUCHER,FUSEDATE,FBARCODE,FPRICE,FHEADUSEPERSONID,FISMULTIDEPT,FJUSTREALCARD,FSRCBILLENTITYNAME,FBARCODERECOVERY,FORGID,FORIGINMETHODID,FASSETUNITID,FSTOREPLACEID,FMODIFIERID,FREALACCOUNTDATE,FISINITIALCARD,FISFACILITY,FAUDITORID,FINITCHANGEFLAG,FASSETNAME,FBILLNORECOVERY,FSRCBILLID,FAUDITDATE,FASSETCATID,FHEADUSEDEPTID,FMODEL,FBIZSTATUS,FID,FSOURCEENTRYSPLITSEQ,FISBAK,FPICTUREPATH,FMATERIALGROUPID,FUSESTATUSID,FNUMBER,FBILLSTATUS,FBILLNO,FSOURCEBILLNUMBER,FISCANCEL,FSOURCEFLAG,FMODIFYTIME,FCREATORID,FSUPPLIERID) VALUES ('1',11,?,6.000000,'0',?,' ',' ',0,'0',?,' ',0.000000,0,' ','0',' ',' ',?,2,?,?,1,?,'1','0',0,0,?,' ',0,NULL,?,?,' ','READY',?,0,'0',' ',0,10002,?,'C',?,' ','0','INITIAL',?,1,?)";
    private static final String INSERT_REAL_L = "INSERT INTO t_fa_card_real_l(FID,FPKID,FLOCALEID,FASSETNAME) VALUES (?,?,'zh_CN',?)";
    private static final String INSERT_ASSET_FIN_ENTRY = "insert into t_fa_asset_finentry(fid, fentryid, fseq, ffincardid, foriginalfincardid) values (?, ?, ?, ?, ?)";
    private static final String INSERT_FIN_CARDS = "INSERT INTO t_fa_card_fin(FBIZPERIODID,FISNEEDDEPRE,FCREATETIME,FENDPERIODID,FREALCARDID,FHASVOUCHER,FINCOMETAX,FORG,FISDYNAMIC,FCLEARPERIODID,FFINACCOUNTDATE,FDEPREPOLICYID,FACCUMDEPRE,FCHANGEBILLID,FMODIFIERID,FYEARORIGVALCHG,FAUDITORID,FMONTHORIGVALCHG,FDEPREUSEID,FDECVAL,FINCOMEDEDUCT,FAUDITDATE,FASSETCATID, FDEPREDEPTID,FMONTHDEPRECHG,FPERIODID, FCURRENCYRATE,FID,FDEPREDAMOUNT,FNUMBER,FASSETBOOKID, FBILLSTATUS,FNETWORTH,FBILLNO,FWORKLOADUNITID,FNETAMOUNT,FMODIFYTIME, FPRERESIDUALVAL,FMONTHWORKLOAD,FDEPRERATE,FCREATORID,FREALCARDMASTERID,FORIGINALVAL,FADDUPYEARDEPRE,FADDIDEPREAMOUNT,FCURRENCYID,FPREUSINGAMOUNT,FORIGINALAMOUNT,FDEPREMETHODID,FMONTHDEPRE,FBASECURRENCYID) VALUES (0,'1', ?,99999999999, ?,'1',0.000000, ?,' ',0, ?, 0, ?,0,1, 0.000000 ,0,0.000000, ?,0.000000,'0',NULL, ?, ?,0.000000,0, 1.000000 , ?, ?,?, ?,'C', ?, ?, 0, ?, ?, ?,0,0,1,?,?,?,?,?,?,?,?,0,?)";
    private static final ConvertDataService READER = new ConvertDataService();
    private static final long REAL_TABLE_ID = READER.loadTableDefine("fa_card_real", "fa_card_real").getTableId();
    private static final long FIN_TABLE_ID = READER.loadTableDefine("fa_card_fin", "fa_card_fin").getTableId();
    private static final String INSERT_FIN_LK = "INSERT INTO t_fa_card_fin_lk(FID,FSBILLID,FPKID,FSEQ,FSID,FSTABLEID) VALUES (?,?,?,1,?," + REAL_TABLE_ID + ")";
    private static final String INSERT_FIN_TC = "INSERT INTO t_fa_card_fin_tc(FID,FSBILLID,FTBILLID,FTID,FSID,FTTABLEID,FSTABLEID) VALUES (?,?,?,?,?," + FIN_TABLE_ID + "," + REAL_TABLE_ID + ")";
    private static final String INSERT_DYNAMIC = "INSERT INTO t_fa_card_dynamic(FID,FASSETBOOKID,FCHANGEBILLID,FREALCARDID,FDEPREUSEID,FPERIODID,FENTITYNAME,FDATE) VALUES (?,?,?,?,?,0,'fa_dyndepre',?)";
    private static final String INSERT_BOTP = "INSERT INTO t_botp_billtracker(FID,FSBILLID,FCREATETIME,FTBILLID,FTTABLEID,FSTABLEID) VALUES (?,?,?,?," + FIN_TABLE_ID + "," + REAL_TABLE_ID + ")";
    private static final String DELETE_BOTP = "DELETE FROM t_botp_billtracker where ?<=fsbillid and fsbillid <=?";
    private static final String DELETE_REAL = "DELETE FROM t_fa_card_real where fid >= ? and fid <= ?";
    private static final String DELETE_REAL_L = "DELETE FROM t_fa_card_real_l where fid >= ? and fid <= ?";
    private static final String DELETE_ASSET_FIN_ENTRY = "DELETE FROM t_fa_asset_finentry where fid >= ? and fid <= ?";
    private static final String DELETE_FIN = "DELETE FROM t_fa_card_fin where frealcardmasterid >= ? and frealcardmasterid <= ?";
    private static final String DELETE_FIN_LK = "DELETE FROM t_fa_card_fin_lk where fsbillid >= ? and fsbillid <= ?";
    private static final String DELETE_FIN_TC = "DELETE FROM t_fa_card_fin_tc where fsbillid >= ? and fsbillid <= ?";
    private static final String DELETE_DYNAMIC_CARD = "DELETE FROM t_fa_card_dynamic where frealcardid >= ? and frealcardid <= ?";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain", "advcontoolbarap"});
        MulBasedataEdit assetbookEdit = (MulBasedataEdit)this.getControl(ASSETBOOK);
        assetbookEdit.addBeforeF7SelectListener(evt -> {
            IDataModel model = this.getModel();
            DynamicObjectCollection entrys = model.getEntryEntity(REALCARDENTITY);
            DynamicObject entry = (DynamicObject)entrys.get(evt.getRow());
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            List filters = parameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("org", "=", (Object)entry.getDynamicObject(ASSETUNIT).getLong("id")));
        });
    }

    public void afterCreateNewData(EventObject e) {
        String sql = "select max(fprefix) fprefix from t_fa_card_insert";
        DataSet dataSet = DB.queryDataSet((String)"query exists max prefix", (DBRoute)FA, (String)sql);
        int max = 1;
        if (dataSet.hasNext()) {
            max = dataSet.next().getInteger("fprefix") + 1;
        }
        this.getModel().setValue(PREFIX, (Object)max);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(REALCARDENTITY);
        if (TOTALQTY.equals(key) || ASSETCAT.equals(key) || MONTHQTY.equals(key)) {
            int index = e.getChangeSet()[0].getRowIndex();
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
            int monthqty = dynamicObject.getInt(MONTHQTY);
            long totalqty = dynamicObject.getLong(TOTALQTY);
            model.setValue(QTY, (Object)(totalqty / (long)monthqty));
        } else if (DYNAMICPROPORTION.equals(key) || QTY.equals(key)) {
            int index = e.getChangeSet()[0].getRowIndex();
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
            int dynamicproportion = dynamicObject.getInt(DYNAMICPROPORTION);
            int qty = dynamicObject.getInt(QTY);
            model.setValue(DYQTY, (Object)(dynamicproportion * qty / 100));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("deletedata".equals(key)) {
            IDataModel model = this.getModel();
            int index = model.getEntryCurrentRowIndex(REALCARDENTITY);
            DynamicObject dynamicObject = (DynamicObject)model.getEntryEntity(REALCARDENTITY).get(index);
            this.deleteLastData(dynamicObject, index);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("insertreal".equals(key)) {
            this.insertCards();
        }
        if ("deletecard".equals(key)) {
            this.deleteCards();
        }
        if ("bar_save".equals(key) || "bar_submit".equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection(REALCARDENTITY);
            for (DynamicObject entry : entryEntity) {
                int monthqty = entry.getInt(MONTHQTY);
                long totalqty = entry.getLong(TOTALQTY) == 0L ? 1L : entry.getLong(TOTALQTY);
                entry.set(QTY, (Object)(totalqty / (long)monthqty));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
            this.getView().updateView();
        }
    }

    private void deleteCards() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject load = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (DynamicObjectType)dataEntity.getDynamicObjectType());
        DynamicObjectCollection realEntity = load.getDynamicObjectCollection(REALCARDENTITY);
        for (int j = 0; j < realEntity.size(); ++j) {
            DynamicObject dynamicObject = (DynamicObject)realEntity.get(j);
            long curCardid = dynamicObject.getLong(CURCARDID);
            int qty = dynamicObject.getInt(QTY);
            int prefix = (Integer)this.getModel().getValue(PREFIX);
            long startId = this.splicingCardId(prefix, j, 0L);
            long endId = this.splicingCardId(prefix, j, 99999999L);
            Object[] param = new Object[]{startId, endId};
            DB.execute((DBRoute)SYS, (String)DELETE_BOTP, (Object[])param);
            DB.execute((DBRoute)FA, (String)DELETE_REAL, (Object[])param);
            DB.execute((DBRoute)FA, (String)DELETE_REAL_L, (Object[])param);
            DB.execute((DBRoute)FA, (String)DELETE_FIN, (Object[])param);
            DB.execute((DBRoute)FA, (String)DELETE_ASSET_FIN_ENTRY, (Object[])param);
            DB.execute((DBRoute)FA, (String)DELETE_FIN_LK, (Object[])param);
            DB.execute((DBRoute)FA, (String)DELETE_FIN_TC, (Object[])param);
            DB.execute((DBRoute)FA, (String)DELETE_DYNAMIC_CARD, (Object[])param);
            dynamicObject.set(REALCURPROGRESS, (Object)0);
            dynamicObject.set(CURCARDID, (Object)0);
            dynamicObject.set(CURASSETINDEX, (Object)0);
            dynamicObject.set(CURMONTHINDEX, (Object)0);
            dynamicObject.set(GEN_CARD_TIME, (Object)0);
        }
        load.set("gencardstatus", (Object)"0");
        load.set("totalgencardtime", (Object)0);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{load});
        this.getView().updateView();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertCards() {
        long beginTime = System.currentTimeMillis();
        IDataModel model = this.getModel();
        Object pkValue = model.getDataEntity().getPkValue();
        String querySql = "select fgencardstatus from t_fa_card_insert where fid = " + pkValue;
        DataSet billStatusDataSet = DB.queryDataSet((String)"query bill status", (DBRoute)FA, (String)querySql);
        if (!billStatusDataSet.hasNext()) {
            logger.error("\u627e\u4e0d\u5230\u5355\u636e");
            return;
        }
        String genCardStatus = billStatusDataSet.next().getString("fgencardstatus");
        if (!"0".equals(genCardStatus)) {
            logger.info("\u5355\u636e\u72b6\u6001\u4e3a:" + genCardStatus);
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            String updateStatus = "update t_fa_card_insert set fgencardstatus = ? where fid = ?";
            Object[] param = new Object[]{"1", pkValue};
            DB.execute((DBRoute)FA, (String)updateStatus, (Object[])param);
        }
        DynamicObjectCollection realEntity = model.getEntryEntity(REALCARDENTITY);
        int j = 0;
        while (j < realEntity.size()) {
            DynamicObject dynamicObject = (DynamicObject)realEntity.get(j);
            if (dynamicObject.getInt(REALCURPROGRESS) != 100) {
                this.insertCard(dynamicObject, j, beginTime);
            }
            ++j;
        }
        return;
    }

    private void deleteLastData(DynamicObject dynamicObject, int j) {
        long curCardid = dynamicObject.getLong(CURCARDID);
        int qty = dynamicObject.getInt(QTY);
        int prefix = (Integer)this.getModel().getValue(PREFIX);
        long startid = this.splicingCardId(prefix, j, curCardid - (long)qty + 1L);
        long endid = this.splicingCardId(prefix, j, curCardid - 1L);
        Object[] param = new Object[]{startid, endid};
        DB.execute((DBRoute)SYS, (String)DELETE_BOTP, (Object[])param);
    }

    private void insertCard(DynamicObject dynamicObject, int j, long beginTime) {
        THREADPOOL.execute(() -> {
            logger.info("\u5206\u5f55\u7b2c" + (j + 1) + "\u884c\u5f00\u59cb\u51c6\u5907\u63d2\u5165\u6570\u636e...");
            long startTime = System.currentTimeMillis();
            Object entryPkValue = dynamicObject.getPkValue();
            int prefix = (Integer)this.getModel().getValue(PREFIX);
            DynamicObject assetunit = dynamicObject.getDynamicObject(ASSETUNIT);
            long assetunitId = assetunit.getLong("id");
            String assetunitNumber = assetunit.getString("number");
            long assetCatId = dynamicObject.getDynamicObject(ASSCAT).getLong("id");
            int monthqty = dynamicObject.getInt(MONTHQTY);
            int total = dynamicObject.getInt(TOTALQTY);
            int qty = dynamicObject.getInt(QTY);
            int dyqty = dynamicObject.getInt(DYQTY);
            long supplierId = dynamicObject.getLong(Fa.id((String)"supplier"));
            long curCardid = dynamicObject.getLong(CURCARDID);
            ArrayList<Long> assetbookIds = new ArrayList<Long>(2);
            HashMap<Long, Long> assetbookAndDepreuse = new HashMap<Long, Long>(2);
            HashMap<Long, Integer> bookId2YearPeriod = new HashMap<Long, Integer>(2);
            HashMap<Long, Long> bookId2CurrencyId = new HashMap<Long, Long>(2);
            java.util.Date mainBookEnableData = new java.util.Date();
            HashMap<Long, Boolean> bookId2DepTime = new HashMap<Long, Boolean>(2);
            HashMap<Long, Integer> bookId2DepMonth = new HashMap<Long, Integer>(2);
            HashMap<Long, Long> bookId2DepMethod = new HashMap<Long, Long>(2);
            HashMap<Long, BigDecimal> bookId2NetRate = new HashMap<Long, BigDecimal>(2);
            HashMap<Long, Integer> bookId2CurrencyRate = new HashMap<Long, Integer>(2);
            Map load = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)assetunitId)});
            logger.info("\u5206\u5f55\u7b2c" + (j + 1) + "\u884c\u67e5\u8be2\u8d26\u7c3f\u6570\u91cf\uff1a" + load.size());
            if (load.size() == 0) {
                return;
            }
            for (DynamicObject v : load.values()) {
                long bookId = v.getLong("id");
                assetbookIds.add(bookId);
                assetbookAndDepreuse.put(bookId, v.getLong(Fa.id((String)"depreuse")));
                bookId2CurrencyId.put(bookId, v.getLong(Fa.id((String)"basecurrency")));
                bookId2YearPeriod.put(bookId, v.getDynamicObject("startperiod").getInt("periodnumber"));
                logger.info("\u5206\u5f55\u7b2c" + (j + 1) + "\u884c\u5373\u5c06\u5f00\u59cb\u67e5\u8be2\u653f\u7b56");
                DynamicObject deprepolicy = null;
                try {
                    deprepolicy = AssetPolicyUtil.getByDepreSystemAndCat((Object)v.getDynamicObject("depresystem").getPkValue(), (Object)assetCatId);
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    logger.error("\u5206\u5f55\u7b2c" + (j + 1) + "\u884c\u67e5\u8be2\u653f\u7b56\u7ed3\u675f\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + msg);
                }
                String logMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1s\u884c\u67e5\u8be2\u653f\u7b56\u7ed3\u675f\uff0c\u8d26\u7c3f\u653f\u7b56id\uff1a%2s\uff0c\u8d44\u4ea7\u7c7b\u522bid\uff1a%3s,\u67e5\u8be2\u7ed3\u679c\u5206\u5f55id\uff1a%4s\u3002", (String)"FaRealCardInsertPlugin_0", (String)"fi-fa-upgradeservice", (Object[])new Object[0]), j + 1, v.getLong(Fa.id((String)"depresystem")), assetCatId, deprepolicy == null ? Integer.valueOf(0) : deprepolicy.getPkValue());
                logger.info(logMsg);
                bookId2DepTime.put(bookId, "NEW".equals(deprepolicy.getString("depretime")));
                bookId2DepMonth.put(bookId, deprepolicy.getInt("expectuse") * 12);
                bookId2DepMethod.put(bookId, deprepolicy.getLong(Fa.id((String)"depremethod")));
                bookId2NetRate.put(bookId, deprepolicy.getBigDecimal("netresidualvalrate"));
                bookId2CurrencyRate.put(bookId, v.getDynamicObject("basecurrency").getInt("amtprecision"));
                if (!v.getBoolean("ismainbook")) continue;
                mainBookEnableData = v.getDynamicObject("startperiod").getDate("enddate");
            }
            logger.info("\u5206\u5f55\u7b2c" + (j + 1) + "\u884cmainBookEnableData\uff1a" + mainBookEnableData.toString());
            DynamicObject storeplace = QueryServiceHelper.queryOne((String)"fa_storeplace", (String)"id", (QFilter[])new QFilter[0]);
            logger.info("\u5206\u5f55\u7b2c" + (j + 1) + "\u884c\u67e5\u8be2\u5b58\u653e\u5730\u70b9\u7ed3\u675f\uff0c\u5b58\u653e\u5730\u70b9id\uff1a" + storeplace);
            Calendar calendar = Calendar.getInstance();
            int count = 0;
            for (int k = 0; k < monthqty; ++k) {
                calendar.setTime(mainBookEnableData);
                calendar.add(2, -(k + 1));
                Date sqldate = new Date(calendar.getTimeInMillis());
                ArrayList<Object[]> realParams = new ArrayList<Object[]>(qty);
                ArrayList<Object[]> realLParams = new ArrayList<Object[]>(qty);
                ArrayList<Object[]> finParams = new ArrayList<Object[]>(qty * assetbookAndDepreuse.size());
                ArrayList<Object[]> assetFinEntryParams = new ArrayList<Object[]>(qty * assetbookAndDepreuse.size());
                ArrayList<Object[]> tcParams = new ArrayList<Object[]>(qty * assetbookAndDepreuse.size());
                ArrayList<Object[]> lkParams = new ArrayList<Object[]>(qty * assetbookAndDepreuse.size());
                ArrayList<Object[]> dynamicCardParams = new ArrayList<Object[]>(dyqty * assetbookAndDepreuse.size());
                ArrayList<Object[]> botpParams = new ArrayList<Object[]>(qty * assetbookAndDepreuse.size());
                long[] finEntryIds = DBServiceHelper.genLongIds((String)"t_fa_asset_finentry", (int)(qty * assetbookAndDepreuse.size()));
                long[] lkids = DBServiceHelper.genLongIds((String)"t_fa_card_fin_lk", (int)(qty * assetbookAndDepreuse.size()));
                long[] tcids = DBServiceHelper.genLongIds((String)"t_fa_card_fin_tc", (int)(qty * assetbookAndDepreuse.size()));
                long[] botpids = DBServiceHelper.genLongIds((String)"t_botp_billtracker", (int)(qty * assetbookAndDepreuse.size()));
                long[] dyids = DBServiceHelper.genLongIds((String)"t_fa_card_dynamic", (int)(dyqty * assetbookAndDepreuse.size()));
                String[] realLids = DBServiceHelper.genStringIds((String)"t_fa_card_real_l", (int)qty);
                logger.info("\u5206\u5f55\u7b2c" + (j + 1) + "\u884c,\u7b2c" + (k + 1) + "\u4e2a\u6708\u5f00\u59cb\u51c6\u5907\u6570\u636e...");
                try {
                    for (int i = 0; i < qty; ++i) {
                        Object[] param = new Object[15];
                        long realId = this.splicingCardId(prefix, j, curCardid);
                        String number = assetunitNumber + prefix + "-" + j + "-" + curCardid;
                        param[0] = realId;
                        param[1] = sqldate;
                        param[2] = sqldate;
                        param[3] = assetunitId;
                        param[4] = assetunitId;
                        param[5] = storeplace.getLong("id");
                        param[6] = sqldate;
                        param[7] = "test" + j + "-" + curCardid;
                        param[8] = assetCatId;
                        param[9] = assetunitId;
                        param[10] = realId;
                        param[11] = number;
                        param[12] = number;
                        param[13] = sqldate;
                        param[14] = supplierId;
                        realParams.add(param);
                        Object[] realLparam = new Object[]{realId, realLids[i], "test" + curCardid};
                        realLParams.add(realLparam);
                        for (int u = 0; u < assetbookAndDepreuse.size(); ++u) {
                            int yearPeriod;
                            int valCoefficient = RANDOM.nextInt(29) + 1;
                            long assetbookId = (Long)assetbookIds.get(u);
                            long depreuseId = (Long)assetbookAndDepreuse.get(assetbookId);
                            Object[] finparam = new Object[26];
                            Object[] tcparam = new Object[5];
                            Object[] lkparam = new Object[4];
                            Object[] botpparam = new Object[4];
                            Object[] assetFinParam = new Object[5];
                            int idIndex = i * assetbookAndDepreuse.size() + u;
                            long finId = this.splicingCardId(prefix, j, curCardid + (long)(total * u));
                            Integer depMonth = (Integer)bookId2DepMonth.get(assetbookId);
                            int originalVal = 25 * depMonth * valCoefficient;
                            BigDecimal rate = (BigDecimal)bookId2NetRate.get(assetbookId);
                            BigDecimal preResidualVal = new BigDecimal(originalVal).multiply(rate).divide(new BigDecimal(100), (int)((Integer)bookId2CurrencyRate.get(assetbookId)), RoundingMode.HALF_DOWN);
                            BigDecimal monthDepre = new BigDecimal(originalVal).subtract(preResidualVal).divide(new BigDecimal(depMonth), (int)((Integer)bookId2CurrencyRate.get(assetbookId)), RoundingMode.HALF_DOWN);
                            int depreamount = k;
                            boolean depTime = (Boolean)bookId2DepTime.get(assetbookId);
                            if (depTime) {
                                ++depreamount;
                            }
                            BigDecimal accumdepre = monthDepre.multiply(new BigDecimal(depreamount));
                            BigDecimal networth = new BigDecimal(originalVal).subtract(accumdepre);
                            BigDecimal addUpYearDep = depreamount == 0 ? BigDecimal.ZERO : ((yearPeriod = (Integer)bookId2YearPeriod.get(assetbookId) - 1) > depreamount ? monthDepre.multiply(new BigDecimal(depreamount)) : monthDepre.multiply(new BigDecimal(yearPeriod)));
                            finparam[0] = sqldate;
                            finparam[1] = realId;
                            finparam[2] = assetunitId;
                            finparam[3] = sqldate;
                            finparam[4] = accumdepre;
                            finparam[5] = depreuseId;
                            finparam[6] = assetCatId;
                            finparam[7] = assetunitId;
                            finparam[8] = finId;
                            finparam[9] = depreamount;
                            finparam[10] = number;
                            finparam[11] = assetbookId;
                            finparam[12] = networth;
                            finparam[13] = number;
                            finparam[14] = networth;
                            finparam[15] = sqldate;
                            finparam[16] = preResidualVal;
                            finparam[17] = realId;
                            finparam[18] = originalVal;
                            finparam[19] = addUpYearDep;
                            finparam[20] = 0;
                            finparam[21] = bookId2CurrencyId.get(assetbookId);
                            finparam[22] = bookId2DepMonth.get(assetbookId);
                            finparam[23] = originalVal;
                            finparam[24] = bookId2DepMethod.get(assetbookId);
                            finparam[25] = bookId2CurrencyId.get(assetbookId);
                            finParams.add(finparam);
                            assetFinParam[0] = realId;
                            assetFinParam[1] = finEntryIds[idIndex];
                            assetFinParam[2] = u + 1;
                            assetFinParam[3] = finId;
                            assetFinParam[4] = finId;
                            assetFinEntryParams.add(assetFinParam);
                            lkparam[0] = finId;
                            lkparam[1] = realId;
                            lkparam[2] = lkids[idIndex];
                            lkparam[3] = realId;
                            lkParams.add(lkparam);
                            tcparam[0] = tcids[idIndex];
                            tcparam[1] = realId;
                            tcparam[2] = finId;
                            tcparam[3] = finId;
                            tcparam[4] = realId;
                            tcParams.add(tcparam);
                            if (i < dyqty) {
                                Object[] dyparam = new Object[]{dyids[idIndex], assetbookId, assetbookId, realId, depreuseId, sqldate};
                                dynamicCardParams.add(dyparam);
                            }
                            botpparam[0] = botpids[idIndex];
                            botpparam[1] = realId;
                            botpparam[2] = sqldate;
                            botpparam[3] = finId;
                            botpParams.add(botpparam);
                        }
                        ++curCardid;
                        if (++count != 1000) continue;
                        this.saveCards(realParams, realLParams, assetFinEntryParams, finParams, tcParams, lkParams, dynamicCardParams, botpParams, assetunitNumber, (int)(curCardid * 100L / (long)total), entryPkValue, k);
                        count = 0;
                    }
                }
                catch (Exception e) {
                    logger.error("\u5206\u5f55\u7b2c" + (j + 1) + "\u884c,\u7b2c" + (k + 1) + "\u4e2a\u6708\u5f00\u59cb\u51c6\u5907\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage());
                    throw e;
                }
                if (!realParams.isEmpty()) {
                    this.saveCards(realParams, realLParams, assetFinEntryParams, finParams, tcParams, lkParams, dynamicCardParams, botpParams, assetunitNumber, (int)(curCardid * 100L / (long)total), entryPkValue, k);
                }
                logger.info("\u5206\u5f55\u7b2c" + (j + 1) + "\u884c,\u7b2c" + (k + 1) + "\u4e2a\u6708\u6570\u636e\u9020\u6570\u5b8c\u6210");
            }
            long endTime = System.currentTimeMillis();
            long useTime = (endTime - startTime) / 1000L;
            String updateSql = "update t_fa_card_insert_real set fgencardtime = ?, frealcurprogress = 100 where fentryid = ?";
            Object[] params = new Object[]{useTime, entryPkValue};
            DB.execute((DBRoute)FA, (String)updateSql, (Object[])params);
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            String querySql = "select a.fid from t_fa_card_insert a left join t_fa_card_insert_real b on a.fid = b.fid where a.fid = " + pkValue + " and b.frealcurprogress != 100";
            DataSet dataSet = DB.queryDataSet((String)"query card is gen over", (DBRoute)FA, (String)querySql);
            if (!dataSet.hasNext()) {
                updateSql = "update t_fa_card_insert set ftotalgencardtime = ?, fgencardstatus = ? where fid = ?";
                Object[] param = new Object[3];
                useTime = (endTime - beginTime) / 1000L;
                param[0] = useTime;
                param[1] = "2";
                param[2] = pkValue;
                DB.execute((DBRoute)FA, (String)updateSql, (Object[])param);
            }
        });
    }

    private void saveCards(List<Object[]> result, List<Object[]> realLresult, List<Object[]> assetFinParams, List<Object[]> finresult, List<Object[]> tcresult, List<Object[]> lkresult, List<Object[]> dynamicresult, List<Object[]> botpresult, String assetunitNumber, int curprogress, Object entryPkValue, int monthqtyIndex) {
        String loginfo = "";
        try {
            DB.executeBatch((DBRoute)SYS, (String)INSERT_BOTP, botpresult);
            loginfo = "InsertCard assetunitNumber:  " + assetunitNumber + "  monthIndex" + monthqtyIndex + "  sysSaveSuccess";
            botpresult.clear();
        }
        catch (Exception e) {
            loginfo = e.getMessage();
            throw e;
        }
        finally {
            logger.info("InsertCardErrorReason: " + loginfo);
        }
        try {
            DB.executeBatch((DBRoute)FA, (String)INSERT_REAL_CARDS, result);
            DB.executeBatch((DBRoute)FA, (String)INSERT_REAL_L, realLresult);
            DB.executeBatch((DBRoute)FA, (String)INSERT_ASSET_FIN_ENTRY, assetFinParams);
            DB.executeBatch((DBRoute)FA, (String)INSERT_FIN_CARDS, finresult);
            DB.executeBatch((DBRoute)FA, (String)INSERT_FIN_TC, tcresult);
            DB.executeBatch((DBRoute)FA, (String)INSERT_FIN_LK, lkresult);
            if (dynamicresult.size() > 0) {
                DB.executeBatch((DBRoute)FA, (String)INSERT_DYNAMIC, dynamicresult);
            }
            Object[] params = new Object[]{curprogress, entryPkValue};
            DB.execute((DBRoute)FA, (String)"update t_fa_card_insert_real set frealcurprogress = ? where fentryid = ?", (Object[])params);
            loginfo = "InsertCard assetunitNumber:   " + assetunitNumber + "  monthIndex" + monthqtyIndex + "  fiSaveSuccess";
            result.clear();
            realLresult.clear();
            assetFinParams.clear();
            finresult.clear();
            tcresult.clear();
            lkresult.clear();
            dynamicresult.clear();
        }
        catch (Exception e) {
            loginfo = e.getMessage();
            throw e;
        }
        finally {
            logger.info("InsertCardErrorReason: " + loginfo);
        }
    }

    private Long splicingCardId(int prefix, int index, long curCount) {
        String cardId = df.format(prefix) + df1.format(index) + df2.format(curCount);
        return Long.parseLong(cardId);
    }
}

