/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class FaRentSettleBillNoUpgradeService
implements IUpgradeService {
    private static final String DB_ROUT_FA = "fa";
    private static final String QUERY_LEASE_CONTRACT = "select fid, fnumber from t_fa_lease_contract_new";
    private static final String QUERY_RENT_SETTLE = "select fid, fleasecontractid, fbillno from t_fa_lease_rent_settle;";
    private static final String UPDATE_RENT_SETTLE = "update t_fa_lease_rent_settle set fbillno = ? where fid = ?;";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        List rentSettles;
        DBRoute fa;
        Throwable throwable;
        TXHandle handle;
        UpgradeResult result;
        block17: {
            UpgradeResult upgradeResult;
            block18: {
                block19: {
                    result = new UpgradeResult();
                    handle = TX.requiresNew();
                    throwable = null;
                    fa = DBRoute.of((String)DB_ROUT_FA);
                    final Map idNumberMap = (Map)DB.query((DBRoute)fa, (String)QUERY_LEASE_CONTRACT, (ResultSetHandler)new ResultSetHandler<Map<Long, String>>(){

                        public Map<Long, String> handle(ResultSet rs) throws Exception {
                            HashMap<Long, String> result = new HashMap<Long, String>(16);
                            while (rs.next()) {
                                long id = rs.getLong("fid");
                                String number = rs.getString("fnumber");
                                result.put(id, number);
                            }
                            return result;
                        }
                    });
                    rentSettles = (List)DB.query((DBRoute)fa, (String)QUERY_RENT_SETTLE, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

                        public List<Object[]> handle(ResultSet rs) throws Exception {
                            ArrayList<Object[]> result = new ArrayList<Object[]>(360);
                            while (rs.next()) {
                                long id = rs.getLong("fid");
                                String rentSettleNo = rs.getString("fbillno");
                                long leaseContractId = rs.getLong("fleasecontractid");
                                String contractNum = (String)idNumberMap.get(leaseContractId);
                                if (contractNum == null) continue;
                                int len = contractNum.length();
                                String seq = rentSettleNo.substring(len + 1);
                                DecimalFormat format = new DecimalFormat("000");
                                seq = format.format(Integer.valueOf(seq));
                                rentSettleNo = contractNum + "-" + seq;
                                Object[] param = new Object[]{rentSettleNo, id};
                                result.add(param);
                            }
                            return result;
                        }
                    });
                    if (rentSettles != null && !rentSettles.isEmpty()) break block17;
                    result.setSuccess(true);
                    result.setLog("haven't rent settle need update.");
                    upgradeResult = result;
                    if (handle == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                handle.close();
            }
            return upgradeResult;
        }
        try {
            try {
                int[] successNum = DB.executeBatch((DBRoute)fa, (String)UPDATE_RENT_SETTLE, (List)rentSettles);
                result.setLog("rent settle update success count: " + successNum.length);
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog("rent settle update failed :" + e.getMessage());
                handle.markRollback();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (handle != null) {
                if (throwable != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    handle.close();
                }
            }
        }
        return result;
    }
}

