/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.ExceptionUtils;

public class FaSplitAftAssetNameUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.fa.upgradeservice.FaSplitAftAssetNameUpgradeService");

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            String updateSql = "update t_fa_assetsplitentry_d as a set fassetname = (select c.fassetname from t_fa_assetsplitentry as b inner join t_fa_card_real as c on b.frealcardid = c.fid where a.fentryid = b.fentryid) where trim(a.fassetname)  = ''";
            DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)updateSql);
            String querySql = "select b.fdetailid, c.flocaleid, c.fassetname from t_fa_assetsplitentry a inner join t_fa_assetsplitentry_d b on a.fentryid = b.fentryid inner join t_fa_card_real_l c on a.frealcardid = c.fid";
            List insertData = (List)DB.query((DBRoute)DBRoute.of((String)"fa"), (String)querySql, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet resultSet) throws Exception {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(1024);
                    while (resultSet.next()) {
                        HashMap<String, Object> map = new HashMap<String, Object>(8);
                        map.put("fdetailid", resultSet.getLong("fdetailid"));
                        map.put("flocaleid", resultSet.getString("flocaleid"));
                        map.put("fassetname", resultSet.getString("fassetname"));
                        list.add(map);
                    }
                    return list;
                }
            });
            if (insertData.size() > 0) {
                String[] ids = DBServiceHelper.genStringIds((String)"T_FA_ASSETSPLITENTRY_D_L", (int)insertData.size());
                ArrayList<Object[]> params = new ArrayList<Object[]>(insertData.size());
                for (int i = 0; i < insertData.size(); ++i) {
                    Object[] objs = new Object[]{ids[i], ((Map)insertData.get(i)).get("fdetailid"), ((Map)insertData.get(i)).get("flocaleid"), ((Map)insertData.get(i)).get("fassetname")};
                    params.add(objs);
                }
                String sql = "INSERT INTO T_FA_ASSETSPLITENTRY_D_L (FPKID,FDETAILID,FLOCALEID,FASSETNAME) VALUES (?,?,?,?)";
                DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)sql, params);
            }
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_ERROR");
            result.setErrorInfo("UPGRADE_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }
}

