/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.ThrowableHelper;

public class FaUpdateLeaseInterestVersionServiceImpl
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ArrayList<Long> contractList;
        HashMap effectiveDateMap;
        ArrayList<Object[]> updateParams;
        int paramMaxSize;
        SimpleDateFormat dateFormat;
        String updateInterestDetailEntry;
        Throwable throwable;
        TXHandle handle;
        DBRoute faRoute;
        UpgradeResult result;
        block29: {
            Row row2;
            block30: {
                block31: {
                    result = new UpgradeResult();
                    faRoute = DBRoute.of((String)"fa");
                    String DATE_FORMAT = "yyyyMMdd";
                    handle = TX.required();
                    throwable = null;
                    String queryLeaseChangeBils = "select C.fbefcontractid,C.faftcontractid,C.feffectivedate,AFTL.fversion aftversion,AFTL.fsettlesharesrcid aftsettlesharesrcid,NEWL.fid newcontractid,NEWL.fnumber,NEWL.fversion newversion from t_fa_lease_change_bill C left join t_fa_lease_chg_items TS on C.fid =TS.fid left join t_fa_change_item T on T.fid = TS.fbasedataid left join t_fa_lease_contract_new AFTL on C.faftcontractid = AFTL.fid left join t_fa_lease_contract_new NEWL on C.fleasecontractid= NEWL.fid where T.fnumber in ('payruleentryentity','discountrate') and T.ftopic = 'fa_lease_contract'and C.fbillstatus = 'C'order by C.fcreatetime;";
                    updateInterestDetailEntry = "update t_fa_interest_detail_e set fcontractversion = ? where fentryid = ?;";
                    dateFormat = new SimpleDateFormat("yyyyMMdd");
                    paramMaxSize = 1000;
                    DataSet leaseChangeBilDs = DB.queryDataSet((String)"FaUpdateLeaseInterestVersionServiceImpl", (DBRoute)faRoute, (String)queryLeaseChangeBils);
                    HashSet<Long> contracts = new HashSet<Long>(32);
                    updateParams = new ArrayList<Object[]>(32);
                    effectiveDateMap = new HashMap(32);
                    for (Row row2 : leaseChangeBilDs) {
                        List allLeaseChangeEffectiveDates;
                        Long aftcontractid = row2.getLong("faftcontractid");
                        String aftversion = row2.getString("aftversion");
                        Date effectiveDate = row2.getDate("feffectivedate");
                        Long newContractId = row2.getLong("newcontractid");
                        String newversion = row2.getString("newversion");
                        contracts.add(aftcontractid);
                        contracts.add(newContractId);
                        String effectiveDateVersion = dateFormat.format(effectiveDate);
                        ArrayList<Date> aftEffectiveDateList = (ArrayList<Date>)effectiveDateMap.get(aftcontractid);
                        ArrayList<Date> newEffectiveDateList = (ArrayList<Date>)effectiveDateMap.get(newContractId);
                        if (newversion == null) {
                            newversion = "";
                        }
                        if (newversion.compareTo(effectiveDateVersion) >= 0) {
                            if (newEffectiveDateList == null) {
                                newEffectiveDateList = new ArrayList<Date>(16);
                            }
                            newEffectiveDateList.add(effectiveDate);
                            effectiveDateMap.put(newContractId, newEffectiveDateList);
                        }
                        if (aftEffectiveDateList == null) {
                            aftEffectiveDateList = new ArrayList<Date>(16);
                        }
                        if ((allLeaseChangeEffectiveDates = (List)effectiveDateMap.get(newContractId)) == null) continue;
                        for (Date date : allLeaseChangeEffectiveDates) {
                            String newDate = dateFormat.format(date);
                            if (aftversion.compareTo(newDate) < 0) continue;
                            aftEffectiveDateList.add(date);
                            effectiveDateMap.put(aftcontractid, aftEffectiveDateList);
                        }
                    }
                    contractList = new ArrayList<Long>(32);
                    contractList.addAll(contracts);
                    if (!contractList.isEmpty()) break block29;
                    row2 = result;
                    if (handle == null) break block30;
                    if (throwable == null) break block31;
                    try {
                        handle.close();
                    }
                    catch (Throwable aftcontractid) {
                        throwable.addSuppressed(aftcontractid);
                    }
                    break block30;
                }
                handle.close();
            }
            return row2;
        }
        try {
            try {
                SqlBuilder queryInterestDetail = new SqlBuilder();
                queryInterestDetail.append("select D.fid,E.fdate,E.fentryid,L.fid contractId,L.fnumber from t_fa_interest_detail_e E left join t_fa_interest_detail D on E.fid = D.fid left join t_fa_lease_contract_new L on D.fleasecontractid = L.fid where", new Object[0]);
                queryInterestDetail.appendIn("L.fid", contractList);
                DataSet queryInterestDetailDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)faRoute, (SqlBuilder)queryInterestDetail);
                for (Row row : queryInterestDetailDs) {
                    List dates;
                    Long interestEntryId = row.getLong("fentryid");
                    Long contractId = row.getLong("contractId");
                    Date date = row.getDate("fdate");
                    if (!effectiveDateMap.containsKey(contractId) || (dates = (List)effectiveDateMap.get(contractId)) == null || dates.size() == 0) continue;
                    dates.sort(Comparator.naturalOrder());
                    String updateVersion = "0";
                    Date dataEffectivMax = (Date)dates.get(dates.size() - 1);
                    if (DateUtil.compareDate((Date)date, (Date)dataEffectivMax) > 0) {
                        updateVersion = dateFormat.format(dataEffectivMax);
                    }
                    for (int i = 0; i < dates.size(); ++i) {
                        int x = i + 1;
                        Date dateNow = (Date)dates.get(i);
                        if (x < dates.size()) {
                            Date dateNext = (Date)dates.get(x);
                            if (DateUtil.compareDate((Date)date, (Date)dateNow) > 0 && DateUtil.compareDate((Date)date, (Date)dateNext) < 0) {
                                updateVersion = dateFormat.format(dateNow);
                            }
                        }
                        if (DateUtil.compareDate((Date)date, (Date)dateNow) != 0) continue;
                        updateVersion = dateFormat.format(dateNow);
                    }
                    Object[] param = new Object[]{updateVersion, interestEntryId};
                    updateParams.add(param);
                    if (updateParams.size() != paramMaxSize) continue;
                    DB.executeBatch((DBRoute)faRoute, (String)updateInterestDetailEntry, updateParams);
                    updateParams.clear();
                }
                if (!updateParams.isEmpty()) {
                    DB.executeBatch((DBRoute)faRoute, (String)updateInterestDetailEntry, updateParams);
                }
                handle.commit();
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog("interestDetail update failed :" + ThrowableHelper.toString((Throwable)e));
                handle.markRollback();
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        catch (Throwable throwable3) {
            throw throwable3;
        }
        finally {
            if (handle != null) {
                if (throwable != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    handle.close();
                }
            }
        }
        return result;
    }
}

