/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.upgradeservice.util.FaPermissionUpgradeServiceImpl;

public class FaUpdatePermissionItemUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(FaUpdatePermissionItemUpgradeService.class);
    private static final String FA = "83bfebc800001aac";
    private static final String SELECT = "47150e89000000ac";
    private static final String UPDATE = "4715a0df000000ac";
    private static final String GENERATEVOUCHER = "/LRTO/JV2TYZ";
    private static final String TRACEVOUCHER = "0F5H0E/N0+8K";
    private static final String PREVIEWVOUCHER = "0DYOZWNS6+NX";
    private static final String DELETEVOUCHER = "/LSMQBAL/70Y";
    private static final String DELETEFINCARD = "06DO6U/WKDXC";
    private static final String UPSELECT = "0K6+MBJ9Z/Y3";
    private static final String SWITCHDYNAMICALGORITHM = "2T+HKDQ5PE08";
    private static final String TRACEFINCARD = "2T+=XTA8/=I/";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.updatePermission("fa_depre_sum", SELECT, GENERATEVOUCHER, TRACEVOUCHER, PREVIEWVOUCHER, DELETEVOUCHER);
            this.updatePermission("fa_asset_devalue", SELECT, GENERATEVOUCHER, TRACEVOUCHER, PREVIEWVOUCHER, DELETEVOUCHER);
            this.updatePermission("fa_card_fin", SELECT, UPSELECT, PREVIEWVOUCHER, TRACEVOUCHER);
            this.updatePermission("fa_initcard_real", SELECT, DELETEFINCARD, TRACEFINCARD);
            this.updatePermission("fa_initcard_fin", SELECT, UPSELECT);
            this.updatePermission("fa_initcard_fin", UPDATE, SWITCHDYNAMICALGORITHM);
            this.updatePermission("fa_change_dept", SELECT, UPSELECT);
            log.info("UPGRADE_PERMISSION_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_PERMISSION_ERROR");
            result.setErrorInfo("UPGRADE_PERMISSION_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void updatePermission(String entityName, String permItem, String ... newPermItem) {
        FaPermissionUpgradeServiceImpl upgradeService = new FaPermissionUpgradeServiceImpl();
        ArrayList<String> existPermInfoList = new ArrayList<String>(1);
        existPermInfoList.add(String.join((CharSequence)"_split_", permItem, entityName, FA));
        List<String> newPermItemList = Arrays.asList(newPermItem);
        upgradeService.addPermItemsByExistPermItem(existPermInfoList, entityName, FA, newPermItemList);
    }
}

