/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.business.enums.lease.LeaseContractRentSettleStatus;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;

public class LeaseRentSettleStatusUpgradeService
implements IUpgradeService {
    private static final Log LOG = LogFactory.getLog((String)"kd.fi.fa.upgradeservice.LeaseRentSettleStatusUpgradeService");
    private static final DBRoute FA = DBRoute.of((String)"fa");

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle h = TX.required();){
            try {
                this.upgrade();
                result.setSuccess(true);
            }
            catch (Exception e) {
                h.markRollback();
                result.setSuccess(false);
                LOG.info("FAUPGRADE_RENTSETTLESTATUS_ERROR");
                result.setErrorInfo("FAUPGRADE_RENTSETTLESTATUS_ERROR " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        return result;
    }

    private void upgrade() {
        Long id;
        String leaseContractSql = "select fid, fisexempt, fleaseliab, fsourcetype, finitconfirmdate, fsysswitchdate from t_fa_lease_contract_new where fid = fmasterid";
        List tempList = (List)DB.query((DBRoute)FA, (String)leaseContractSql, resultSet -> {
            ArrayList<LeaseContractTemp> list = new ArrayList<LeaseContractTemp>(256);
            while (resultSet.next()) {
                Long id = resultSet.getLong("fid");
                String isExempt = resultSet.getString("fisexempt");
                BigDecimal leaseLiab = resultSet.getBigDecimal("fleaseliab");
                String sourceType = resultSet.getString("fsourcetype");
                Date intDetailBeginDate = LeaseContractSourceType.A.name().equals(sourceType) ? resultSet.getDate("finitconfirmdate") : resultSet.getDate("fsysswitchdate");
                list.add(new LeaseContractTemp(id, isExempt, leaseLiab, intDetailBeginDate));
            }
            return list;
        });
        Object[] ids = tempList.stream().map(LeaseContractTemp::getId).distinct().toArray();
        ArrayList<Object> tempIds = new ArrayList<Object>(1000);
        HashSet<Long> leaseContractIds4RentSettle = new HashSet<Long>(ids.length);
        HashSet<Long> leaseContractIds4PayPlay = new HashSet<Long>(ids.length);
        int i = 0;
        for (Object id2 : ids) {
            tempIds.add(id2);
            if (++i != 1000) continue;
            this.getLeaseContract4RentSettle(tempIds, leaseContractIds4RentSettle);
            this.getLeaseContract4PayPlay(tempIds, leaseContractIds4PayPlay);
            tempIds.clear();
            i = 0;
        }
        if (!tempIds.isEmpty()) {
            this.getLeaseContract4RentSettle(tempIds, leaseContractIds4RentSettle);
            this.getLeaseContract4PayPlay(tempIds, leaseContractIds4PayPlay);
        }
        HashMap<Long, String> idToStatusMap = new HashMap<Long, String>(tempList.size());
        for (LeaseContractTemp leaseContractTemp : tempList) {
            boolean needRentSettle = this.checkLeaseNeedRentSettle(leaseContractTemp, leaseContractIds4PayPlay);
            id = leaseContractTemp.getId();
            if (needRentSettle) {
                if (leaseContractIds4RentSettle.contains(id)) {
                    idToStatusMap.put(id, LeaseContractRentSettleStatus.C.name());
                    continue;
                }
                idToStatusMap.put(id, LeaseContractRentSettleStatus.A.name());
                continue;
            }
            idToStatusMap.put(id, LeaseContractRentSettleStatus.B.name());
        }
        ArrayList<Object[]> list = new ArrayList<Object[]>(idToStatusMap.size());
        for (Map.Entry idToStatus : idToStatusMap.entrySet()) {
            id = (Long)idToStatus.getKey();
            String status = (String)idToStatus.getValue();
            list.add(new Object[]{status, id});
        }
        if (!list.isEmpty()) {
            DB.executeBatch((DBRoute)FA, (String)"update t_fa_lease_contract_new set frentsettlestatus = ? where fmasterid = ?", list);
        }
    }

    private void getLeaseContract4RentSettle(List<Object> ids, Set<Long> leaseContractIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.appendIn("select fleasecontractid from t_fa_lease_rent_settle where fleasecontractid ", ids);
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)FA, (SqlBuilder)sqlBuilder);
        DataSet distinct = dataSet.distinct();
        for (Row row : distinct) {
            leaseContractIds.add(row.getLong("fleasecontractid"));
        }
        dataSet.close();
        distinct.close();
    }

    private void getLeaseContract4PayPlay(List<Object> ids, Set<Long> leaseContractIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.appendIn("select fid from t_fa_lease_pay_plan where fid ", ids);
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)FA, (SqlBuilder)sqlBuilder);
        DataSet distinct = dataSet.distinct();
        for (Row row : distinct) {
            leaseContractIds.add(row.getLong("fid"));
        }
        dataSet.close();
        distinct.close();
    }

    private boolean checkLeaseNeedRentSettle(LeaseContractTemp leaseContractTemp, Set<Long> hasPayPlayLeaseIds) {
        String isExempt = leaseContractTemp.getIsExempt();
        Long id = leaseContractTemp.getId();
        if ("0".equals(isExempt)) {
            BigDecimal leaseLiab = leaseContractTemp.getLeaseLiab();
            if (leaseLiab == null || BigDecimal.ZERO.compareTo(leaseLiab) == 0) {
                return false;
            }
            return hasPayPlayLeaseIds.contains(id);
        }
        java.util.Date intDetailBeginDate = leaseContractTemp.getIntDetailBeginDate();
        String payRuleSql = "select a.fid from t_fa_lease_pay_plan a left join t_fa_payment_item b on a.fpayitemid = b.fid  where a.fid = ? and a.fplanpaydate >= ? and b.faccountingclass = 'A'";
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)FA, (String)payRuleSql, (Object[])new Object[]{id, intDetailBeginDate});
        boolean needRentSettle = !dataSet.isEmpty();
        dataSet.close();
        return needRentSettle;
    }

    static class LeaseContractTemp {
        private final Long id;
        private final String isExempt;
        private final BigDecimal leaseLiab;
        private final java.util.Date intDetailBeginDate;

        public LeaseContractTemp(Long id, String isExempt, BigDecimal leaseLiab, java.util.Date intDetailBeginDate) {
            this.id = id;
            this.isExempt = isExempt;
            this.leaseLiab = leaseLiab;
            this.intDetailBeginDate = intDetailBeginDate;
        }

        public Long getId() {
            return this.id;
        }

        public String getIsExempt() {
            return this.isExempt;
        }

        public BigDecimal getLeaseLiab() {
            return this.leaseLiab;
        }

        public java.util.Date getIntDetailBeginDate() {
            return this.intDetailBeginDate;
        }
    }
}

