/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.common.batch;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.fi.fa.common.batch.BatchResult;
import kd.fi.fa.common.util.CommonUtils;

public class BatchOneByOne<T, U> {
    public final T[] allElements;

    public BatchOneByOne(T[] allElements) {
        this.allElements = allElements;
    }

    BatchResult<T, U> execute(Function<T, U> action, BiConsumer<T, Exception> exceptionConsumer) {
        BatchResult<T, U> batchResult = new BatchResult<T, U>();
        for (T element : this.allElements) {
            try {
                batchResult.addSuccessElement(element, action.apply(element));
            }
            catch (Exception ex) {
                exceptionConsumer.accept(element, ex);
                batchResult.addFailureInfo(element, ex);
            }
        }
        return batchResult;
    }

    public BatchResult<T, U> execute(Consumer<T> action, Function<T, String> flagFn) {
        return this.execute(action, (T elem, Exception ex) -> CommonUtils.logException((String)flagFn.apply(elem), ex));
    }

    BatchResult<T, U> execute(Consumer<T> action, BiConsumer<T, Exception> exceptionConsumer) {
        return this.execute((T elem) -> {
            action.accept(elem);
            return null;
        }, exceptionConsumer);
    }
}

