/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtil {
    private static final Log logger = LogFactory.getLog(DateUtil.class);

    public static SimpleDateFormat getShortDate() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static SimpleDateFormat getLongDate() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static SimpleDateFormat getLongDate2() {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    public static Date parseDate(String dateStr, String pattern, boolean lenient) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setLenient(lenient);
        return sdf.parse(dateStr);
    }

    public static Date getCurrentDay0hour() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.get(5) + 1);
        cal.set(5, cal.get(5) - 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getNextDay0hour() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.get(5) + 1);
        cal.set(5, cal.get(5));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getNextDay0hour(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.get(5) + 1);
        cal.set(5, cal.get(5));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static int getDay(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(5);
    }

    public static Date getDateFormat(Date date, boolean isStart) {
        String dateStr = DateUtil.getShortDate().format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        try {
            return DateUtil.getLongDate().parse(dateStr + suffix);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isSameDay(Date date, Date anotherDate) {
        String dateStr = DateUtil.getShortDate().format(date);
        String anotherDateStr = DateUtil.getShortDate().format(anotherDate);
        return dateStr.equals(anotherDateStr);
    }

    public static int getShortOfYear(Date date, Date anotherDate) {
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(date);
        int dateYear = dateCal.get(1);
        Calendar anotherDateCal = Calendar.getInstance();
        anotherDateCal.setTime(anotherDate);
        int anotherDateYear = anotherDateCal.get(1);
        return dateYear - anotherDateYear;
    }

    public static int getShortOfMonth(Date date, Date anotherDate) {
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(date);
        int dateMonth = dateCal.get(2);
        Calendar anotherDateCal = Calendar.getInstance();
        anotherDateCal.setTime(anotherDate);
        int anotherDateMonth = anotherDateCal.get(2);
        return dateMonth - anotherDateMonth;
    }

    public static int getDateOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(1);
        return cal.get(7);
    }

    public static String getHour(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int hour = cal.get(11);
        return hour + ":00";
    }

    public static int getHourOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(11);
    }

    public static int getMinuteOfHour(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(12);
    }

    public static Date getCurrentDayStart(Date curDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(curDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getCurrentDayEnd(Date curDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(curDate);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        DateTime start = formatter.parseDateTime(DateUtil.getShortDate().format(beginDate));
        DateTime end = formatter.parseDateTime(DateUtil.getShortDate().format(endDate));
        return Days.daysBetween((ReadableInstant)start, (ReadableInstant)end).getDays();
    }

    public static int getDiffDays(Date startDay, Date endDay, boolean includeBegin, boolean includeEnd) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        DateTime start = formatter.parseDateTime(DateUtil.getShortDate().format(startDay));
        DateTime end = formatter.parseDateTime(DateUtil.getShortDate().format(endDay));
        int diff = Math.abs(Days.daysBetween((ReadableInstant)start, (ReadableInstant)end).getDays());
        if (includeBegin && includeEnd) {
            return diff + 1;
        }
        if (!includeBegin && !includeEnd) {
            return diff > 1 ? diff - 1 : 0;
        }
        return diff;
    }

    public static int getDiffMonths(Date begindate, Date enddate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
        int begin = Integer.parseInt(df.format(begindate));
        int end = Integer.parseInt(df.format(enddate));
        return (end / 100 - begin / 100) * 12 + (end % 100 - begin % 100);
    }

    public static int getDiffMonthsByLocalDate(Date beginDate, Date endDate, boolean includeBeginDate) {
        return DateUtil.getDiffMonthsByLocalDate(beginDate, endDate, includeBeginDate, false);
    }

    public static int getDiffMonthsByLocalDate(Date beginDate, Date endDate, boolean includeBeginDate, boolean monthRoundUp) {
        if (DateUtil.compareDate(beginDate, endDate) >= 0) {
            return 0;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String beginDateStr = format.format(beginDate);
        String endDateStr = format.format(endDate);
        LocalDate beginLocalDate = LocalDate.parse(beginDateStr);
        LocalDate endLocalDate = LocalDate.parse(endDateStr);
        if (includeBeginDate) {
            endLocalDate = endLocalDate.plusDays(1L);
        }
        Period period = Period.between(beginLocalDate, endLocalDate);
        int years = period.getYears();
        int months = period.getMonths();
        int days = period.getDays();
        int diffMonth = years * 12 + months;
        if (monthRoundUp && days > 0) {
            ++diffMonth;
        }
        return diffMonth;
    }

    public static boolean isOverlap(List<Tuple<Date, Date>> dateRangeList) {
        if (dateRangeList == null || dateRangeList.size() < 2) {
            return false;
        }
        boolean isOverlap = false;
        for (int i = 0; i < dateRangeList.size(); ++i) {
            for (int j = i + 1; j < dateRangeList.size(); ++j) {
                Tuple<Date, Date> range2;
                Tuple<Date, Date> range1 = dateRangeList.get(i);
                if (!DateUtil.isOverlap(range1, range2 = dateRangeList.get(j))) continue;
                isOverlap = true;
                break;
            }
            if (isOverlap) break;
        }
        return isOverlap;
    }

    private static boolean isOverlap(Tuple<Date, Date> dateRange1, Tuple<Date, Date> dateRange2) {
        Date startDate1 = (Date)dateRange1.item1;
        Date endDate1 = (Date)dateRange1.item2;
        Date startDate2 = (Date)dateRange2.item1;
        Date endDate2 = (Date)dateRange2.item2;
        if (DateUtil.compareDate(startDate1, startDate2) == 0 && DateUtil.compareDate(endDate1, endDate2) == 0) {
            return true;
        }
        Date maxStartDate = DateUtil.maxDate(startDate1, startDate2);
        Date minEndDate = DateUtil.minDate(endDate1, endDate2);
        return DateUtil.compareDate(maxStartDate, minEndDate) <= 0;
    }

    public static Date maxDate(Date ... dates) {
        Optional<Date> optional = Stream.of(dates).max(Date::compareTo);
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public static Date minDate(Date ... dates) {
        Optional<Date> optional = Stream.of(dates).min(Date::compareTo);
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public static Date stripTime(Date date) {
        try {
            return Fa.getDF().parse(Fa.getDF().format(date));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date addDay(Date date, int amount) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(6, amount);
        return ca.getTime();
    }

    public static Date addMonth(Date date, int amount) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(2, amount);
        return ca.getTime();
    }

    public static Date addNaturalMonth(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int lastDay = calendar.getActualMaximum(5);
        int now = calendar.get(5);
        boolean isLastDay = lastDay == now;
        calendar.add(2, amount);
        if (isLastDay) {
            lastDay = calendar.getActualMaximum(5);
            calendar.set(5, lastDay);
        }
        return calendar.getTime();
    }

    public static int compareDate(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            KDBizException exception = new KDBizException(ResManager.loadKDString((String)"\u6bd4\u8f83\u7684\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DateUtil_0", (String)"fi-fa-common", (Object[])new Object[0]));
            logger.error(String.format("\u65e5\u671f\u6bd4\u8f83\u9519\u8bef\uff1adate1:[%s], date2:[%s]", d1, d2), (Throwable)exception);
            throw exception;
        }
        long t1 = d1.getTime();
        long t2 = d2.getTime();
        return Long.compare(t1, t2);
    }

    public static int compareShortDate(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            KDBizException exception = new KDBizException(ResManager.loadKDString((String)"\u6bd4\u8f83\u7684\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DateUtil_0", (String)"fi-fa-common", (Object[])new Object[0]));
            logger.error(String.format("\u65e5\u671f\u6bd4\u8f83\u9519\u8bef\uff1adate1:[%s], date2:[%s]", d1, d2), (Throwable)exception);
            throw exception;
        }
        d1 = DateUtil.getCurrentDayStart(d1);
        d2 = DateUtil.getCurrentDayStart(d2);
        return DateUtil.compareDate(d1, d2);
    }

    public static Date getMinDateOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getMaxDateOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getMinDateOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 0);
        calendar.set(5, calendar.getActualMinimum(5));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int getDateField(Date date, int field) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(field);
    }

    public static Long dateToStamp(String str) {
        Date date = new Date();
        try {
            date = DateUtil.getShortDate().parse(str);
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        return date.getTime();
    }

    public static String formatToString(Date date) {
        return DateUtil.getShortDate().format(date);
    }

    public static Date getShortTypeDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

