/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.common.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Fa {
    public static final String COMMA = ",";
    public static final String SEMICOLON = ";";
    public static final String COLON = ":";
    public static final String DOT = ".";
    public static final String CR = System.lineSeparator();
    public static final String UNDERLINE = "_";
    public static final BigDecimal ZERO = BigDecimal.ZERO;
    public static final BigDecimal ONE = BigDecimal.ONE;
    public static final BigDecimal TWO = new BigDecimal("2");
    public static final BigDecimal HUNDRED = new BigDecimal("100");

    public static DateFormat getDF() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static DateFormat getTF2() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static Date getDFDate(Date newDate) {
        Date date = null;
        try {
            date = Fa.getDF().parse(Fa.getDF().format(newDate));
        }
        catch (ParseException e) {
            date = newDate;
        }
        return date;
    }

    public static DateFormat getTF() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }

    public static String objToJson(Object obj) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T jsonToObj(String json, Class<T> clazz) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String dot(String ... strs) {
        return Fa.join(DOT, strs);
    }

    public static String comma(String ... strs) {
        return Fa.join(COMMA, strs);
    }

    public static String id(String str) {
        return Fa.join(UNDERLINE, str, "Id");
    }

    public static String join(Object[] arr, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(arr[i]).append(separator);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.lastIndexOf(separator));
        }
        return null;
    }

    public static String join(Collection arr, String separator) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : arr) {
            sb.append(obj).append(separator);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.lastIndexOf(separator));
        }
        return null;
    }

    public static String join(String separator, String ... arr) {
        return Fa.join(arr, separator);
    }

    public static String fetchStackTrace(Exception ex) {
        Throwable t = ex;
        StringBuilder stackTrace = new StringBuilder();
        String sep = "@#$%";
        for (int loopCount = 0; t != null && loopCount <= 10; t = t.getCause(), ++loopCount) {
            StackTraceElement[] stackTraces = t.getStackTrace();
            stackTrace.append(sep);
            stackTrace.append("cause by ");
            stackTrace.append(t);
            stackTrace.append(sep);
            stackTrace.append(Stream.of(stackTraces).map(StackTraceElement::toString).collect(Collectors.joining(sep)));
        }
        return stackTrace.toString();
    }
}

