/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.mservice.api;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.business.SourceFlagEnum;

public class FaRealCardScanApi
implements ISkillRunnable {
    private static DBRoute ROUTE_FA = DBRoute.of((String)"fa");
    private static final Log logger = LogFactory.getLog(FaRealCardScanApi.class);

    public SkillRunResult pullData(SkillRunContext skillRunContext) {
        if (skillRunContext == null) {
            throw new KDBizException(ResManager.loadKDString((String)"SkillRunContext\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaRealCardScanApi_0", (String)"fi-fa-mservice", (Object[])new Object[0]));
        }
        String skillNum = skillRunContext.getSkillNum();
        Date startTime = skillRunContext.getStartTime();
        if (startTime == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaRealCardScanApi_1", (String)"fi-fa-mservice", (Object[])new Object[0]));
        }
        Date endTime = skillRunContext.getEndTime();
        if (endTime == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaRealCardScanApi_2", (String)"fi-fa-mservice", (Object[])new Object[0]));
        }
        Date date = new Date();
        Date lastMonFirstDay = this.getFirstMonthDay(date, -1);
        Date lastMonLastDay = this.getLastMonthDay(date, -1);
        int lastMonScanSize = this.getRealCardCount(lastMonFirstDay, lastMonLastDay, Boolean.TRUE);
        Date curMonFirstDay = this.getFirstMonthDay(date, 0);
        Date curMonLastDay = this.getLastMonthDay(date, 0);
        int curMonScanSize = this.getRealCardCount(curMonFirstDay, curMonLastDay, Boolean.TRUE);
        int curMonSize = this.getRealCardCount(curMonFirstDay, curMonLastDay, Boolean.FALSE);
        BigDecimal scanCardPercent = BigDecimal.ZERO;
        if (curMonScanSize != 0 && curMonSize != 0) {
            double curMonScanDouble = Double.parseDouble(String.valueOf(curMonScanSize));
            double curMonDouble = Double.parseDouble(String.valueOf(curMonSize));
            scanCardPercent = BigDecimal.valueOf(curMonScanDouble * 100.0 / curMonDouble);
        }
        scanCardPercent = scanCardPercent.setScale(2, RoundingMode.HALF_UP);
        SkillRunResult skillResult = skillRunContext.getSkillResult();
        List<Map<String, String>> queryResult = this.genData(lastMonScanSize, curMonScanSize, scanCardPercent);
        skillResult.setData(queryResult);
        skillResult.setSkillNum(skillNum);
        skillResult.setFailCount(Integer.valueOf(0));
        int total = this.getRealCardCount(startTime, endTime, Boolean.FALSE);
        skillResult.setTotalCount(Integer.valueOf(total));
        skillResult.setDate(startTime);
        logger.info("FaRealCardScanApi pullData skillResult: {}", (Object)skillResult);
        return skillResult;
    }

    private List<Map<String, String>> genData(int lastMonScanSize, int curMonScanSize, BigDecimal scanCardPercent) {
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>(3);
        HashMap<String, String> lastMonScanMap = new HashMap<String, String>(4);
        lastMonScanMap.put("name", ResManager.loadKDString((String)"\u4e0a\u6708\u667a\u80fd\u626b\u63cf\u5efa\u5361\u603b\u6570", (String)"FaRealCardScanApi_3", (String)"fi-fa-mservice", (Object[])new Object[0]));
        lastMonScanMap.put("value", String.valueOf(lastMonScanSize));
        lastMonScanMap.put("valueType", "0");
        lastMonScanMap.put("number", "syznsmjkzs");
        data.add(lastMonScanMap);
        HashMap<String, String> curMonScanMap = new HashMap<String, String>(4);
        curMonScanMap.put("name", ResManager.loadKDString((String)"\u672c\u6708\u667a\u80fd\u626b\u63cf\u5efa\u5361\u603b\u6570", (String)"FaRealCardScanApi_4", (String)"fi-fa-mservice", (Object[])new Object[0]));
        curMonScanMap.put("value", String.valueOf(curMonScanSize));
        curMonScanMap.put("valueType", "0");
        curMonScanMap.put("number", "byznsmjkzs");
        data.add(curMonScanMap);
        HashMap<String, String> curMonScanPercentMap = new HashMap<String, String>(4);
        curMonScanPercentMap.put("name", ResManager.loadKDString((String)"\u672c\u6708\u667a\u80fd\u626b\u63cf\u5efa\u5361\u5360\u6bd4", (String)"FaRealCardScanApi_5", (String)"fi-fa-mservice", (Object[])new Object[0]));
        String value = "0.00%";
        if (scanCardPercent != null && !BigDecimal.ZERO.equals(scanCardPercent)) {
            value = scanCardPercent.toString() + "%";
        }
        curMonScanPercentMap.put("value", value);
        curMonScanPercentMap.put("valueType", "1");
        curMonScanPercentMap.put("number", "byznsmjkzb");
        data.add(curMonScanPercentMap);
        return data;
    }

    private Date getFirstMonthDay(Date date, int month) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        if (month != 0) {
            c.add(2, month);
        }
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    private Date getLastMonthDay(Date date, int month) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        if (month != 0) {
            c.add(2, month);
        }
        c.set(5, c.getActualMaximum(5));
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 0);
        return c.getTime();
    }

    private int getRealCardCount(Date startTime, Date endTime, boolean scan) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select count(1) from  t_fa_card_real where", new Object[0]);
        sqlBuilder.append(" fcreatetime >= ?", new Object[]{startTime});
        sqlBuilder.append(" and fcreatetime <= ?", new Object[]{endTime});
        sqlBuilder.append(" and fisbak = ?", new Object[]{"0"});
        if (scan) {
            sqlBuilder.append(" and fsourceflag = ?", new Object[]{SourceFlagEnum.SCAN.name()});
        }
        return (Integer)DB.query((DBRoute)ROUTE_FA, (SqlBuilder)sqlBuilder, rs -> {
            rs.next();
            return rs.getInt(1);
        });
    }
}

