/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.mservice.fa;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.instance.Instance;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.depretask.DepreSplitTask;
import kd.fi.fa.business.depretask.DepreStatusEnum2;
import kd.fi.fa.business.enums.SplitMode;
import kd.fi.fa.business.po.DisDepreMessage;
import kd.fi.fa.business.po.FaDisDepreLogEntryUpdatePo;
import kd.fi.fa.business.utils.FaDisDepreLogUtils;
import kd.fi.fa.business.utils.FunctionMutexHelper;
import kd.fi.fa.common.util.ThrowableHelper;

public class FaDepreConsumer
implements MessageConsumer {
    private static String selectIds = "select fids_tag from t_fa_disdepre_task where fid = ? and fbatchno = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        if (message == null) {
            return;
        }
        DisDepreMessage msBody = (DisDepreMessage)message;
        DepreSplitTask splitTask = null;
        DynamicObject bookObj = null;
        try {
            int updateCount = FaDisDepreLogUtils.updateDisDepreLogEntryInit2Doing((Long)msBody.getDisLogId(), (Integer)msBody.getDisBatchNo(), (String)Instance.getInstanceId(), (boolean)true);
            if (updateCount != 1) {
                return;
            }
            Map<String, Set<Long>> rMap = this.queryIds2Set(msBody);
            Set<Long> realCardIdSet = rMap.get("realSet");
            Set<Long> finCardIdSet = rMap.get("finSet");
            if (finCardIdSet.size() == 0) {
                return;
            }
            try (TXHandle tx = TX.requiresNew();){
                try {
                    bookObj = BusinessDataServiceHelper.loadSingle((Object)msBody.getAssetBookId(), (String)"fa_assetbook");
                    DepreBook bookBox = new DepreBook(bookObj);
                    bookBox.setNoEnterWkRealSet(msBody.getCache().getNoEnterWkRealSet());
                    bookBox.depreFinCards(finCardIdSet, true, true, false);
                    long bookOrgId = bookObj.getLong("org_id");
                    long bookDepreusegId = bookObj.getLong("depreuse_id");
                    long bookCurperiodId = bookObj.getLong("curperiod_id");
                    splitTask = new DepreSplitTask(Long.valueOf(bookOrgId), Long.valueOf(bookDepreusegId), Long.valueOf(bookCurperiodId), Boolean.valueOf(true), true, SplitMode.DETAILADDREVERSE);
                    splitTask.setEnabledisdepre(msBody.getCache().isEnabledisdepre());
                    splitTask.execute(realCardIdSet);
                    FaDisDepreLogEntryUpdatePo logEntryUpdatePo = new FaDisDepreLogEntryUpdatePo(msBody.getDisLogId(), msBody.getDisBatchNo(), DepreStatusEnum2.SUC, Integer.valueOf(realCardIdSet.size()));
                    FaDisDepreLogUtils.updateDisDepreLog4SubTask((FaDisDepreLogEntryUpdatePo)logEntryUpdatePo, (boolean)false);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
        catch (Throwable e) {
            String detailResult = "FaDepreError:" + ThrowableHelper.toString((Throwable)e);
            FaDisDepreLogEntryUpdatePo logEntryUpdatePo = new FaDisDepreLogEntryUpdatePo(msBody.getDisLogId(), msBody.getDisBatchNo(), DepreStatusEnum2.FAI, Integer.valueOf(0));
            logEntryUpdatePo.setErrorLog(detailResult);
            FaDisDepreLogUtils.updateDisDepreLog4SubTask((FaDisDepreLogEntryUpdatePo)logEntryUpdatePo, (boolean)true);
        }
        if (splitTask == null) {
            return;
        }
        boolean isInitOrDoing = FaDisDepreLogUtils.haveInitOrDoingTask((Long)msBody.getDisLogId());
        if (isInitOrDoing) {
            return;
        }
        int updateSubStatusCount = FaDisDepreLogUtils.updateDisDepreLog4SubStatus((Long)msBody.getDisLogId());
        if (updateSubStatusCount != 1) {
            return;
        }
        boolean isFail = FaDisDepreLogUtils.haveFailedTask((Long)msBody.getDisLogId());
        if (isFail) {
            if (msBody.getCache().isNeedLock()) {
                FunctionMutexHelper.releaseLockWithBook((String)"fa_new_depre", (DynamicObject)bookObj);
            }
            return;
        }
        try {
            splitTask.close();
            FaDisDepreLogUtils.updateDisDepreLog4BillHead((Long)msBody.getDisLogId(), (DepreStatusEnum2)DepreStatusEnum2.SUC, null, (boolean)false, (boolean)true);
        }
        catch (Exception e) {
            FaDisDepreLogUtils.updateDisDepreLog4BillHeadOnError((Long)msBody.getDisLogId(), (Throwable)e, (boolean)false, (boolean)true);
        }
        finally {
            acker.ack(messageId);
            if (msBody.getCache().isNeedLock()) {
                FunctionMutexHelper.releaseLockWithBook((String)"fa_new_depre", (DynamicObject)bookObj);
            }
        }
    }

    private Map<String, Set<Long>> queryIds2Set(DisDepreMessage msBody) {
        Object[] params = new Object[]{msBody.getDisLogId(), msBody.getDisBatchNo()};
        HashMap<String, Set<Long>> rMap = new HashMap<String, Set<Long>>(2, 1.0f);
        HashSet<Long> realCardIdSet = new HashSet<Long>(1);
        HashSet<Long> finCardIdSet = new HashSet<Long>(1);
        try (DataSet idsDs = DB.queryDataSet((String)"FaDepreConsumer_selectIds", (DBRoute)DBRoute.of((String)"fa"), (String)selectIds, (Object[])params);){
            Row ids;
            String idsStr;
            String[] idsStrArr;
            Iterator iterator = idsDs.iterator();
            while (iterator.hasNext() && (idsStrArr = (idsStr = (ids = (Row)iterator.next()).getString("fids_tag")).split(";")) != null) {
                if (idsStrArr != null && idsStrArr.length != 2) {
                    break;
                }
                String realIdsStr = idsStrArr[0];
                String finIdsStr = idsStrArr[1];
                String[] realIdsStrArr = realIdsStr.split(",");
                String[] finIdsStrArr = finIdsStr.split(",");
                realCardIdSet = new HashSet(realIdsStrArr.length, 1.0f);
                finCardIdSet = new HashSet(finIdsStrArr.length, 1.0f);
                for (String realId : realIdsStrArr) {
                    realCardIdSet.add(Long.parseLong(realId));
                }
                for (String finId : finIdsStrArr) {
                    finCardIdSet.add(Long.parseLong(finId));
                }
            }
        }
        rMap.put("realSet", realCardIdSet);
        rMap.put("finSet", finCardIdSet);
        return rMap;
    }
}

