/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.mservice.operation;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.common.util.Fa;

public class FaAbandonAssetOpService
extends EntityOperateService {
    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        fieldKeys.add("billstatus");
        fieldKeys.add("entryentity");
        fieldKeys.add(Fa.dot((String[])new String[]{"entryentity", "real_card"}));
        fieldKeys.add("assettransferentry");
        fieldKeys.add(Fa.dot((String[])new String[]{"assettransferentry", "realcard"}));
        fieldKeys.add("assetdrawbackentry");
        fieldKeys.add(Fa.dot((String[])new String[]{"assetdrawbackentry", "realcard"}));
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        super.addDefaultValidator(validators);
        validators.add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    String billStatus = bill.getString("billstatus");
                    if (billStatus.equals(BillStatus.A.toString())) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u5e9f\u5f03\u3002", (String)"FaAbandonAssetOpService_0", (String)"fi-fa-mservice", (Object[])new Object[0]));
                }
            }
        });
    }

    protected void executeOperate(DynamicObject[] dataEntities) {
        block10: for (DynamicObject bill : dataEntities) {
            String billFromId = bill.getDataEntityType().getName();
            bill.set("billstatus", (Object)BillStatus.D.toString());
            switch (billFromId) {
                case "fa_asset_requisition": {
                    FaModiRealStatsUtils.update_oneBill_bizStatus((DynamicObject)bill, (String)"entryentity", (String)"real_card", (BizStatusEnum)BizStatusEnum.READY, (BizStatusEnum)BizStatusEnum.COLLECTING);
                    continue block10;
                }
                case "fa_asset_transfer_admin": {
                    FaModiRealStatsUtils.update_oneBill_bizStatus((DynamicObject)bill, (String)"assettransferentry", (String)"realcard", (BizStatusEnum)BizStatusEnum.READY, (BizStatusEnum)BizStatusEnum.TRANSFERING);
                    continue block10;
                }
                case "fa_asset_drawback_admin": {
                    FaModiRealStatsUtils.update_oneBill_bizStatus((DynamicObject)bill, (String)"assetdrawbackentry", (String)"realcard", (BizStatusEnum)BizStatusEnum.READY, (BizStatusEnum)BizStatusEnum.DRAWBACKING);
                    continue block10;
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }
}

