/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.mservice.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.fa.business.dao.factory.FaDispatchBillDaoFactory;
import kd.fi.fa.business.dispatch.FaConfirmOp;
import kd.fi.fa.common.util.Fa;

public class FaConfirmOpService
extends EntityOperateService {
    private static final Log log = LogFactory.getLog(FaConfirmOpService.class);

    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        fieldKeys.add("org");
        fieldKeys.add("inorg");
        fieldKeys.add("dispatchentry");
        fieldKeys.add("inusedept");
        fieldKeys.add("incostcentrer");
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        super.addDefaultValidator(validators);
        validators.add(new AbstractValidator(){

            public void validate() {
                ArrayList<Object> pkIds = new ArrayList<Object>(10);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    Object billPkId = dataEntity.getBillPkId();
                    pkIds.add(billPkId);
                }
                DynamicObject[] dyns = FaDispatchBillDaoFactory.getInstance().query("id,billstatus", new QFilter("id", "in", pkIds));
                Map<Long, String> map = Stream.of(dyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getString("billstatus")));
                block1: for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    Long billPkId = (Long)dataEntity.getBillPkId();
                    String status = map.get(billPkId);
                    if (!BillStatus.C.name().equals(status)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u3002", (String)"FaConfirmOpService_0", (String)"fi-fa-mservice", (Object[])new Object[0]));
                    }
                    DynamicObject org = (DynamicObject)dataEntity.getValue("org");
                    DynamicObject inorg = (DynamicObject)dataEntity.getValue("inorg");
                    String selectFields = Fa.comma((String[])new String[]{"org", "depreuse", "curperiod"});
                    QFilter[] filters = new QFilter("org", "in", (Object)new Object[]{org.get("id"), inorg.get("id")}).toArray();
                    DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)selectFields, (QFilter[])filters);
                    HashMap<Object, Object> depreusePeriodMap = new HashMap<Object, Object>();
                    for (DynamicObject book : books) {
                        Object depreuseId = book.get("depreuse");
                        Object curPeriodId = book.get("curperiod");
                        if (!depreusePeriodMap.containsKey(depreuseId)) {
                            depreusePeriodMap.put(depreuseId, curPeriodId);
                            continue;
                        }
                        if (depreusePeriodMap.get(depreuseId).equals(curPeriodId)) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8c03\u51fa\u65b9\u548c\u8c03\u5165\u65b9\u7684\u5f53\u524d\u671f\u95f4\u9700\u8981\u4e00\u81f4\u3002", (String)"FaConfirmOpService_1", (String)"fi-fa-mservice", (Object[])new Object[0]));
                        continue block1;
                    }
                }
            }
        });
    }

    protected void executeOperate(DynamicObject[] objs) {
        List<Long> ids = Arrays.stream(objs).map(v -> v.getLong("id")).collect(Collectors.toList());
        try (TXHandle handle0 = null;){
            handle0 = TX.requiresNew();
            this.deleteBotp(ids);
        }
        try (TXHandle handle = null;){
            handle = TX.required();
            new FaConfirmOp().execute(objs);
        }
    }

    private void deleteBotp(List<Long> ids) {
        DeleteServiceHelper.delete((String)"botp_billtracker", (QFilter[])new QFilter[]{new QFilter("sbillid", "in", ids)});
    }
}

