/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.mservice.operation;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.service.operation.EntityOperateService;
import kd.fi.fa.business.dao.factory.FaDispatchBillDaoFactory;
import kd.fi.fa.business.dispatch.FaUnConfirmOp;
import kd.fi.fa.business.operate.FaOpCmdUtils;

public class FaUnConfirmOpService
extends EntityOperateService {
    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        fieldKeys.add("billstatus");
    }

    protected void executeOperate(DynamicObject[] objs) {
        new FaUnConfirmOp().executeOperate(objs);
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        super.addDefaultValidator(validators);
        validators.add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    Object billPkId = dataEntity.getBillPkId();
                    Object status = FaDispatchBillDaoFactory.getInstance().queryOne("id,billstatus", billPkId).get("billstatus");
                    if (!BillStatus.D.name().equals(status)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8c03\u5165\u5355\u672a\u786e\u8ba4\u3002", (String)"FaUnConfirmOpService_0", (String)"fi-fa-mservice", (Object[])new Object[0]));
                        continue;
                    }
                    List<String> errors = this.checkUndoOperable(dataEntity.getDataEntity().getDataEntityType().getName(), billPkId);
                    if (errors == null) continue;
                    this.addErrorMessage(dataEntity, this.handleError(errors));
                }
            }

            private List<String> checkUndoOperable(String entityType, Object dispatchPK) {
                ArrayList<String> errorList = new ArrayList<String>();
                boolean isOperable = FaOpCmdUtils.isUndoOperable((Object)dispatchPK, (String)entityType, errorList);
                if (!isOperable) {
                    return errorList;
                }
                return null;
            }

            private String handleError(List<String> errorList) {
                StringBuilder sb = new StringBuilder();
                for (String error : errorList) {
                    sb.append(sb.length() > 0 ? "\r\n" : "");
                    sb.append(error);
                }
                return sb.toString();
            }
        });
    }
}

