/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.mservice.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.card.AssetCardQueryServiceHelper;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.card.AssetCardQueryParam;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.service.FaCardListService;

public class FaCardListServiceImpl
implements FaCardListService {
    private String errorPrefix;
    private static final String RPT_TYPE_CARD_LIST = "fa_rpt_card_list";
    private static final String RPT_TYPE_DEPRE_FORECAST = "rpt_depre_forecast";
    private Map<Long, String> cachePeriodMap = new HashMap<Long, String>(10);

    public FaCardListServiceImpl() {
        this.errorPrefix = ResManager.loadKDString((String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u6b63\u786e\uff1a", (String)"FaCardListServiceImpl_0", (String)"fi-fa-mservice", (Object[])new Object[0]);
    }

    public List<Map<String, Object>> queryAssetCard(Map<String, Object> queryParamMap) {
        AssetCardQueryParam queryParam = this.checkParams(RPT_TYPE_CARD_LIST, queryParamMap);
        QFilter qorg = new QFilter("org", "=", (Object)queryParam.getOrgId());
        QFilter qdepreUse = new QFilter("depreuse", "=", (Object)queryParam.getDepreUseId());
        ArrayList<QFilter> finCardFilters = new ArrayList<QFilter>();
        DynamicObject assetBook = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (String)"id,basecurrency,periodtype", (QFilter[])new QFilter[]{qorg, qdepreUse});
        DynamicObject currency = assetBook.getDynamicObject("basecurrency");
        Object currencypk = currency.getPkValue();
        finCardFilters.add(qorg);
        finCardFilters.add(qdepreUse);
        if (!queryParam.isIncludeUnAudit()) {
            finCardFilters.add(new QFilter("billstatus", "=", (Object)BillStatus.C.toString()));
        }
        finCardFilters.add(new QFilter("endperiod", ">", queryParam.getStartPeriod().getPkValue()));
        finCardFilters.add(new QFilter("bizperiod", "<=", queryParam.getStartPeriod().getPkValue()));
        if (!queryParam.isIncludeClearCard()) {
            finCardFilters.add(new QFilter("bizperiod", "<", (Object)"clearperiod", true).or(new QFilter("clearperiod", "=", (Object)0L)));
        }
        if (queryParam.getOtherFilters() != null) {
            finCardFilters.addAll(queryParam.getOtherFilters());
        }
        DataSet resultData = null;
        try {
            resultData = AssetCardQueryServiceHelper.queryRptDataSet((String)"FaCardListService", (Set)queryParam.getFields(), finCardFilters);
            if (queryParam.isIncludeClearCard()) {
                QFilter periodFilter = new QFilter("clearperiod", "<=", queryParam.getStartPeriod().getPkValue());
                QFilter changeModeFilter = new QFilter("changemode", "=", (Object)21L);
                DataSet clearDs = QueryServiceHelper.queryDataSet((String)"FaCardListService", (String)"fa_clearbill", (String)"detail_entry.fincard clearfincard", (QFilter[])new QFilter[]{qorg, periodFilter, changeModeFilter}, null);
                resultData = resultData.join(clearDs, JoinType.LEFT).on("id", "clearfincard").select(resultData.getRowMeta().getFieldNames(), clearDs.getRowMeta().getFieldNames()).finish();
                resultData = resultData.filter("clearfincard = null");
                resultData = resultData.removeFields(new String[]{"clearfincard"});
            }
            boolean addExtField = queryParam.getFields() != null && queryParam.getFields().size() > 0;
            List<Map<String, Object>> resultMap = this.convertDataSet3ResultMap(resultData, currency, addExtField);
            return resultMap;
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u6e05\u5355\u67e5\u8be2\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a%s", (String)"FaCardListServiceImpl_1", (String)"fi-fa-mservice", (Object[])new Object[0]), ThrowableHelper.toString((Throwable)e)));
        }
    }

    public List<Map<String, Object>> queryCardDepreForecast(Map<String, Object> queryParamMap) {
        AssetCardQueryParam queryParam = this.checkParams(RPT_TYPE_DEPRE_FORECAST, queryParamMap);
        ReportQueryParam rptParam = new ReportQueryParam();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.addFilterItem("q_org", (Object)queryParam.getOrgId());
        DynamicObject depreuseDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)queryParam.getDepreUseId(), (String)"fa_depreuse");
        filterInfo.addFilterItem("depreuse", (Object)depreuseDyn);
        filterInfo.addFilterItem("q_startperiod", (Object)queryParam.getStartPeriod());
        filterInfo.addFilterItem("q_period", (Object)queryParam.getEndPeriod());
        if (queryParam.getOtherFilters() != null && queryParam.getOtherFilters().size() > 0) {
            filterInfo.setCommFilter(Collections.singletonMap("apiQueryFilter", queryParam.getOtherFilters().get(0)));
        }
        List<String> otherFields = new ArrayList<String>(2);
        otherFields.add("basecurrency.number");
        otherFields.add("basecurrency.name");
        otherFields.add("assetcat.number");
        otherFields.add("assetcat.name");
        otherFields.add("realcard.assetname");
        otherFields.add("realcard.headusedept.number");
        otherFields.add("realcard.headusedept.name");
        if (queryParam.getFields() != null) {
            otherFields.addAll(queryParam.getFields());
            otherFields = otherFields.stream().distinct().collect(Collectors.toList());
        }
        rptParam.setFilter(filterInfo);
        boolean containsDetail = (Boolean)queryParamMap.get("containsDetail");
        Object ignoreUseStatusObj = queryParamMap.get("ignoreUseStatus");
        boolean ignoreUseStatus = ignoreUseStatusObj == null ? false : (Boolean)ignoreUseStatusObj;
        Map customParam = rptParam.getCustomParam();
        customParam.put("ignoreUseStatus", ignoreUseStatus);
        DataSet dataSet = AssetCardQueryServiceHelper.queryDepreForecastDataSet((String)"FaCardListService.queryCardForecast", (ReportQueryParam)rptParam, otherFields, (!containsDetail ? 1 : 0) != 0);
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        boolean addExtFields = queryParam.getFields().size() > 0;
        Field[] fields = dataSet.getRowMeta().getFields();
        for (Row row : dataSet) {
            HashMap<String, Object> rowMap = new HashMap<String, Object>(16);
            rowList.add(rowMap);
            rowMap.put("number", row.getString("number"));
            rowMap.put("periodid", row.getString("periodnumber"));
            rowMap.put("periodnumber", this.getPeriodNumberById(row.getString("periodnumber")));
            rowMap.put("predictdepre", row.get("predictDepre"));
            rowMap.put("monthdepre", row.get("monthdepre"));
            rowMap.put("predictoriginalval", row.get("predictoriginalval"));
            rowMap.put("predictaccumdepre", row.get("predictAccumDepre"));
            rowMap.put("predictnetworth", row.get("predictNetWorth"));
            rowMap.put("predictdecval", row.get("predictdecval"));
            rowMap.put("predictnetamount", row.get("predictNetAmount"));
            rowMap.put("preusingamount", row.get("preusingamount"));
            rowMap.put("predepredamount", row.get("predepredamount"));
            rowMap.put("preresidualval", row.get("preresidualval"));
            rowMap.put("preremainderamount", row.get("preremainderamount"));
            rowMap.put("preaddupyeardepre", row.get("preaddupyeardepre"));
            rowMap.put("assetname", row.get("realcard.assetname"));
            rowMap.put("currency", row.get("currency"));
            rowMap.put("currencynumber", row.get("basecurrency.number"));
            rowMap.put("currencyname", row.get("basecurrency.name"));
            rowMap.put("assetcatnumber", row.get("assetcat.number"));
            rowMap.put("assetcatname", row.get("assetcat.name"));
            rowMap.put("headusedeptnumber", row.get("realcard.headusedept.number"));
            rowMap.put("headusedeptname", row.get("realcard.headusedept.name"));
            if (!addExtFields) continue;
            HashMap<String, Object> extFieldMap = new HashMap<String, Object>(6);
            rowMap.put("extBaseFieldMap", extFieldMap);
            for (Field field : fields) {
                if (rowMap.containsKey(field.getName()) || "realcard".equals(field.getName()) || "fincard".equals(field.getName()) || !queryParam.getFields().contains(field.getName())) continue;
                extFieldMap.put(field.getName(), row.get(field.getName()));
            }
        }
        return rowList;
    }

    private AssetCardQueryParam checkParams(String type, Map<String, Object> queryParamMap) {
        Object ignoreUseStatus;
        List fields;
        Object includeUnAudit;
        if (queryParamMap == null) {
            throw new KDBizException(this.errorPrefix + "queryParam is null!");
        }
        AssetCardQueryParam queryParam = new AssetCardQueryParam();
        Object orgId = queryParamMap.get("orgId");
        if (orgId == null || orgId.equals(0L)) {
            String orgNumber = (String)queryParamMap.get("orgNumber");
            if (StringUtils.isEmpty((String)orgNumber)) {
                throw new KDBizException(this.errorPrefix + "org is null!");
            }
            DynamicObject orgDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
            if (orgDyn == null) {
                throw new KDBizException(this.errorPrefix + "org is not exists!");
            }
            orgId = orgDyn.getLong("id");
        }
        queryParam.setOrgId(Long.valueOf(orgId.toString()));
        Object depreUseId = queryParamMap.get("depreUseId");
        DynamicObject bookInfo = null;
        if (depreUseId == null || depreUseId.equals(0L)) {
            String depreUseNumber = (String)queryParamMap.get("depreUseNumber");
            if (StringUtils.isEmpty((String)depreUseNumber)) {
                bookInfo = FaBizUtils.getAsstBookByOrg((Long)Long.valueOf(orgId.toString()));
            } else {
                DynamicObject depreUseDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_depreuse", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)depreUseNumber)});
                if (depreUseDyn == null) {
                    throw new KDBizException(this.errorPrefix + "depreUse is not exists!");
                }
                bookInfo = FaBizUtils.getAsstBookByOrgAndDepreuse((Long)Long.valueOf(orgId.toString()), (Long)depreUseDyn.getLong("id"), (String)"id,periodtype,curperiod,depreuse");
            }
        } else {
            bookInfo = FaBizUtils.getAsstBookByOrgAndDepreuse((Long)Long.valueOf(orgId.toString()), (Long)Long.valueOf(depreUseId.toString()), (String)"id,periodtype,curperiod,depreuse");
        }
        if (bookInfo == null) {
            String errorMsg = ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7684\u201c\u8d44\u4ea7\u8d26\u7c3f\u201d\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\u3002", (String)"FaCardListServiceImpl_2", (String)"fi-fa-mservice", (Object[])new Object[0]);
            throw new KDBizException(this.errorPrefix + errorMsg);
        }
        long bookDepreUse = bookInfo.getLong("depreuse");
        queryParam.setDepreUseId(Long.valueOf(bookDepreUse));
        queryParam.setPeriodType(Long.valueOf(bookInfo.getLong("periodtype")));
        this.checkPeriod(type, queryParamMap, queryParam, bookInfo);
        Object includeClearCard = queryParamMap.get("includeClearCard");
        if (includeClearCard != null) {
            queryParam.setIncludeClearCard(Boolean.parseBoolean(includeClearCard.toString()));
        }
        if ((includeUnAudit = queryParamMap.get("includeUnAudit")) != null) {
            queryParam.setIncludeUnAudit(Boolean.parseBoolean(includeUnAudit.toString()));
        }
        if (RPT_TYPE_DEPRE_FORECAST.equals(type)) {
            fields = (List)queryParamMap.get("extBaseField");
            if (fields != null) {
                queryParam.setFields(new HashSet(fields));
            }
        } else if (RPT_TYPE_CARD_LIST.equals(type) && (fields = (List)queryParamMap.get("fields")) != null) {
            queryParam.setFields(new HashSet(fields));
        }
        String otherFilters = (String)queryParamMap.get("otherFilters");
        if (StringUtils.isNotEmpty((String)otherFilters)) {
            queryParam.setOtherFilters(Collections.singletonList(QFilter.of((String)otherFilters, (Object[])new Object[0])));
        }
        if ((ignoreUseStatus = queryParamMap.get("ignoreUseStatus")) != null && !(ignoreUseStatus instanceof Boolean)) {
            throw new KDBizException(this.errorPrefix + "the param ignoreUseStatus must be Boolean type!");
        }
        return queryParam;
    }

    private void checkPeriod(String type, Map<String, Object> queryParamMap, AssetCardQueryParam queryParam, DynamicObject bookInfo) {
        if (RPT_TYPE_DEPRE_FORECAST.equals(type)) {
            long periodType = bookInfo.getLong("periodtype");
            long curPeriodId = bookInfo.getLong("curperiod");
            Object startPeriodId = queryParamMap.get("startPeriodId");
            DynamicObject startPeriodDyn = null;
            if (startPeriodId == null || startPeriodId.equals(0L)) {
                String periodNumber = (String)queryParamMap.get("startPeriodNumber");
                if (StringUtils.isEmpty((String)periodNumber)) {
                    throw new KDBizException(this.errorPrefix + "start period is null!");
                }
                startPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)periodNumber), new QFilter("periodtype", "=", (Object)periodType)});
            } else {
                startPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)startPeriodId, (String)"bd_period");
            }
            if (startPeriodDyn == null) {
                throw new KDBizException(this.errorPrefix + "start period is not exists!");
            }
            queryParam.setStartPeriod(startPeriodDyn);
            Object endPeriodId = queryParamMap.get("endPeriodId");
            DynamicObject endPeriodDyn = null;
            if (endPeriodId == null || endPeriodId.equals(0L)) {
                String periodNumber = (String)queryParamMap.get("endPeriodNumber");
                if (StringUtils.isEmpty((String)periodNumber)) {
                    throw new KDBizException(this.errorPrefix + "end period is null!");
                }
                endPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)periodNumber), new QFilter("periodtype", "=", (Object)periodType)});
                if (endPeriodDyn == null) {
                    throw new KDBizException(this.errorPrefix + "end period is not exists!");
                }
            } else {
                endPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)endPeriodId, (String)"bd_period");
            }
            queryParam.setEndPeriod(endPeriodDyn);
            if (endPeriodDyn.getLong("id") < startPeriodDyn.getLong("id")) {
                String errorInfo = ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5e94\u665a\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"FaCardListServiceImpl_3", (String)"fi-fa-mservice", (Object[])new Object[0]);
                throw new KDBizException(this.errorPrefix + errorInfo);
            }
        } else if (RPT_TYPE_CARD_LIST.equals(type)) {
            Object periodId = queryParamMap.get("periodId");
            DynamicObject startPeriodDyn = null;
            if (periodId == null || periodId.equals(0L)) {
                String periodNumber = (String)queryParamMap.get("periodNumber");
                if (StringUtils.isEmpty((String)periodNumber)) {
                    throw new KDBizException(this.errorPrefix + "period is null!");
                }
                DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)periodNumber), new QFilter("periodtype", "=", (Object)bookInfo.getLong("periodtype"))});
                if (periodDyn == null) {
                    throw new KDBizException(this.errorPrefix + "period is not exists!");
                }
                startPeriodDyn = periodDyn;
            } else {
                startPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
            }
            queryParam.setStartPeriod(startPeriodDyn);
        }
    }

    private List<Map<String, Object>> convertDataSet3ResultMap(DataSet dataSet, DynamicObject currency, boolean addExtFields) {
        if (dataSet.isEmpty()) {
            return Collections.emptyList();
        }
        Field[] fields = dataSet.getRowMeta().getFields();
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>(100);
        for (Row row : dataSet) {
            HashMap<String, Object> card = new HashMap<String, Object>(10);
            card.put("number", row.getString("number"));
            card.put("currency", currency.getLong("id"));
            card.put("currencyName", currency.getString("name"));
            card.put("currencyNumber", currency.getString("number"));
            resultMap.add(card);
            if (!addExtFields) continue;
            for (Field field : fields) {
                if ("number".equals(field.getName())) continue;
                card.put(field.getName(), row.get(field.getName()));
            }
        }
        return resultMap;
    }

    private String getPeriodNumberById(String period) {
        long periodId = Long.parseLong(period);
        if (this.cachePeriodMap.containsKey(periodId)) {
            return this.cachePeriodMap.get(periodId);
        }
        DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period", (String)"number");
        String periodNumber = periodDyn.getString("number");
        this.cachePeriodMap.put(periodId, periodNumber);
        return periodNumber;
    }
}

