/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.billmapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.BillFieldMappingSelectTypeEnum;

public class BillFieldMappingConvertHelper {
    private static Log logger = LogFactory.getLog(BillFieldMappingConvertHelper.class);
    private final String targetEntityNo;
    private final MainEntityType targetEntityType;
    private final DynamicObject mappingConfig;

    public BillFieldMappingConvertHelper(DynamicObject mappingConfig) {
        this.mappingConfig = mappingConfig;
        DynamicObject targetBillObj = mappingConfig.getDynamicObject("targetobj");
        this.targetEntityNo = targetBillObj.getString("number");
        this.targetEntityType = EntityMetadataCache.getDataEntityType((String)this.targetEntityNo);
    }

    public void convert(DynamicObject fromObj, DynamicObject toObj, boolean isReversed, boolean isForceConvert, Set<String> unNeededFields) {
        DynamicObjectCollection configEntries = this.mappingConfig.getDynamicObjectCollection("colsmap");
        for (DynamicObject entry : configEntries) {
            if (CollectionUtils.isNotEmpty(unNeededFields) && (unNeededFields.contains(entry.getString("sourcebillcol")) || unNeededFields.contains(entry.getString("targetobjcol")))) continue;
            String targetField = entry.getString("targetobjcol");
            if (StringUtils.isEmpty((String)targetField)) {
                logger.error("entryId[{}]\u76ee\u6807\u5b57\u6bb5\u6807\u8bc6\u672a\u914d\u7f6e\uff01", entry.get("entryid"));
                continue;
            }
            BillFieldMappingSelectTypeEnum selectTypeEnum = BillFieldMappingSelectTypeEnum.getEnumByVal(entry.getString("selecttype"));
            switch (selectTypeEnum) {
                case ENTITYFIELD: {
                    String sourceField = this.getSourceFieldByObj(entry.getString("sourcebillcol"), isReversed ? toObj : fromObj);
                    if (StringUtils.isEmpty((String)targetField)) {
                        logger.error("entryId[{}]\u6765\u6e90\u5b57\u6bb5\u6807\u8bc6\u672a\u914d\u7f6e\uff01", entry.get("entryid"));
                        break;
                    }
                    this.setVal(fromObj, toObj, isReversed ? targetField : sourceField, isReversed ? sourceField : targetField, isForceConvert);
                    break;
                }
                case FIXEDVAL: {
                    if (isReversed) break;
                    String fixedVal = entry.getString("fixedvalue");
                    toObj.set(targetField, (Object)fixedVal);
                }
            }
        }
    }

    public Map<String, String> getColsMap(boolean onlyLastGrade, boolean sourceBillIsKey) {
        DynamicObjectCollection configEntries = this.mappingConfig.getDynamicObjectCollection("colsmap");
        HashMap<String, String> colsMap = new HashMap<String, String>(configEntries.size());
        configEntries.stream().forEach(t -> {
            BillFieldMappingSelectTypeEnum selectTypeEnum = BillFieldMappingSelectTypeEnum.getEnumByVal(t.getString("selecttype"));
            if (BillFieldMappingSelectTypeEnum.ENTITYFIELD == selectTypeEnum) {
                String sourceBillField = t.getString("sourcebillcol");
                String targetBillField = t.getString("targetobjcol");
                if (onlyLastGrade) {
                    String[] fieldArray = sourceBillField.split("\\.");
                    sourceBillField = fieldArray[fieldArray.length - 1];
                }
                colsMap.put(sourceBillIsKey ? sourceBillField : targetBillField, sourceBillIsKey ? targetBillField : sourceBillField);
            }
        });
        return colsMap;
    }

    private void setVal(DynamicObject fromObj, DynamicObject toObj, String fromFiled, String toField, boolean isForceConvert) {
        if (isForceConvert || toObj.get(toField) == null || StringUtils.isEmpty((String)String.valueOf(toObj.get(toField)))) {
            toObj.set(toField, fromObj.get(fromFiled));
        }
    }

    private String getSourceFieldByObj(String sourceField, DynamicObject sourceObj) {
        if (StringUtils.isEmpty((String)sourceField)) {
            return null;
        }
        String[] sourceFieldArray = sourceField.split("\\.");
        int matchIndex = 0;
        String objTypeName = sourceObj.getDataEntityType().getName();
        for (String item : sourceFieldArray) {
            if (item.equalsIgnoreCase(objTypeName)) break;
            ++matchIndex;
        }
        if (matchIndex < sourceFieldArray.length - 1) {
            StringBuffer resultBuf = new StringBuffer();
            for (int i = matchIndex + 1; i < sourceFieldArray.length; ++i) {
                resultBuf.append(sourceFieldArray[i]);
            }
            return resultBuf.toString();
        }
        logger.error("sourceObj[{}]\u4e0e\u914d\u7f6e\u7684\u539f\u5355\u5b57\u6bb5\u6807\u8bc6[{}]\u4e0d\u5339\u914d\uff01", (Object)objTypeName, (Object)sourceField);
        return sourceField;
    }

    public List<String> getConfigFields4Target() {
        DynamicObjectCollection configEntries = this.mappingConfig.getDynamicObjectCollection("colsmap");
        ArrayList<String> configFields = new ArrayList<String>(configEntries.size());
        for (DynamicObject entry : configEntries) {
            String targetField = entry.getString("targetobjcol");
            configFields.add(targetField);
        }
        return configFields;
    }

    public List<String> getConfigFields4Source() {
        DynamicObjectCollection configEntries = this.mappingConfig.getDynamicObjectCollection("colsmap");
        ArrayList<String> configFields = new ArrayList<String>(configEntries.size());
        for (DynamicObject entry : configEntries) {
            String sourceField = entry.getString("sourcebillcol");
            String[] split = sourceField.split("\\.");
            if (!sourceField.contains("subassetsplitentry") || split.length <= 1 || !"subassetsplitentry".equals(split[split.length - 2])) continue;
            configFields.add(split[split.length - 1]);
        }
        return configFields;
    }

    public MainEntityType getTargetEntityType() {
        return this.targetEntityType;
    }

    public DynamicObject getMappingConfig() {
        return this.mappingConfig;
    }
}

