/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.busyrecord.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.busyrecord.AbstractBusyRecordServicePlugin;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.PeriodUtil;

public class BusyChgCommUtils {
    public static Set<Long> getOrgSet4ExestedInParam(DynamicObject[] bills) {
        HashSet<Long> orgSet4ExestedInParam = new HashSet<Long>(8);
        HashSet<Long> orgSet4Select = new HashSet<Long>(8);
        for (DynamicObject bill : bills) {
            orgSet4Select.add(bill.getLong("org.id"));
        }
        if (orgSet4Select.size() == 0) {
            return orgSet4ExestedInParam;
        }
        QFilter[] billParamFilters = new QFilter[]{new QFilter("org", "in", orgSet4Select), new QFilter("param", "=", (Object)"START_BUSY_RECORD_PERIOD")};
        DynamicObjectCollection billParams = QueryServiceHelper.query((String)"fa_billparam", (String)"org", (QFilter[])billParamFilters);
        billParams.stream().mapToLong(v -> v.getLong("org")).forEach(orgSet4ExestedInParam::add);
        return orgSet4ExestedInParam;
    }

    public static Map<Map<String, Long>, Long> getOrgDepreUseId2TypeIdMap(String entityName, DynamicObject[] bills) {
        HashMap<Map<String, Long>, Long> orgDepreUseId2TypeIdMap = new HashMap<Map<String, Long>, Long>(8);
        if (!entityName.equals("fa_change_dept") && !entityName.equals("fa_dispatch")) {
            return orgDepreUseId2TypeIdMap;
        }
        HashSet<Long> orgSet4Select = new HashSet<Long>(8);
        for (DynamicObject bill : bills) {
            orgSet4Select.add(bill.getLong("org.id"));
        }
        DynamicObjectCollection books = FaBizUtils.getAsstBookFieldsByOrg(orgSet4Select, "org,depreuse,periodtype");
        for (DynamicObject book : books) {
            HashMap<String, Long> orgDepreUseIdKey = new HashMap<String, Long>(8);
            orgDepreUseIdKey.put("orgId", book.getLong("org"));
            orgDepreUseIdKey.put("useId", book.getLong("depreuse"));
            orgDepreUseId2TypeIdMap.put(orgDepreUseIdKey, book.getLong("periodtype"));
        }
        return orgDepreUseId2TypeIdMap;
    }

    public static Long getPeriodId(Long typeId, Date changeDate, Map<String, DynamicObject> typeIDDate2PeriodMap) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObject period = typeIDDate2PeriodMap.get(typeId + "_" + format.format(changeDate));
        if (period != null) {
            return period.getLong("id");
        }
        for (DynamicObject periodv : typeIDDate2PeriodMap.values()) {
            Long periodTypeId = periodv.getLong("periodtype");
            if (typeId.longValue() != periodTypeId.longValue()) continue;
            Date beginDate = periodv.getDate("begindate");
            Date enddate = periodv.getDate("enddate");
            if (beginDate.equals(changeDate) || enddate.equals(changeDate)) {
                return periodv.getLong("id");
            }
            if (!beginDate.before(changeDate) || !enddate.after(changeDate)) continue;
            return periodv.getLong("id");
        }
        DynamicObject periodfdb = PeriodUtil.getPeriodByDate(changeDate, "id,periodtype,begindate,enddate", typeId);
        if (periodfdb != null) {
            typeIDDate2PeriodMap.put(typeId + "_" + format.format(changeDate), periodfdb);
            return periodfdb.getLong("id");
        }
        return 0L;
    }

    public static Map<Long, Map<Long, Long>> getCommMasterId2depreUseId2PeriodId(DynamicObject bill, String entityName, Map<Map<String, Long>, Long> orgDepreUseId2TypeIdMap, Map<String, DynamicObject> typeIDDate2PeriodMap) {
        String entryName = AbstractBusyRecordServicePlugin.entity2Entry4PeriodchgMap.get(entityName);
        DynamicObjectCollection entryDataList = bill.getDynamicObjectCollection(entryName);
        HashMap<Long, Map<Long, Long>> masterId2depreUseId2PeriodIdMap = new HashMap<Long, Map<Long, Long>>(entryDataList.size() * 3);
        block16: for (DynamicObject entryData : entryDataList) {
            Long periodId;
            Long masterId = 0L;
            switch (entityName) {
                case "fa_change_dept": {
                    masterId = entryData.getLong("realcardmasterid");
                    break;
                }
                case "fa_clearbill": {
                    masterId = entryData.getLong("realcardmasterid");
                    break;
                }
                case "fa_asset_devalue": {
                    masterId = entryData.getLong("realcardmasterid");
                    break;
                }
                case "fa_assetsplitbill": {
                    masterId = bill.getLong("split_realcard.masterid");
                    break;
                }
                case "fa_mergebill": {
                    masterId = entryData.getLong("inrealcardmasterid");
                    break;
                }
                case "fa_restartrealbill": {
                    masterId = entryData.getLong("realcard.masterid");
                }
            }
            if (masterId == 0L) continue;
            HashMap<Long, Long> depreUserId2periodIdMap = (HashMap<Long, Long>)masterId2depreUseId2PeriodIdMap.get(masterId);
            if (depreUserId2periodIdMap == null) {
                depreUserId2periodIdMap = new HashMap<Long, Long>(3, 1.0f);
                masterId2depreUseId2PeriodIdMap.put(masterId, depreUserId2periodIdMap);
            }
            if (entityName.equals("fa_change_dept")) {
                String field = entryData.getString("field");
                String[] split = field.split("\\.");
                boolean isReal = "fa_card_real".equals(split[0]);
                Date changeDate = bill.getDate("changedate");
                if (isReal) {
                    for (Map.Entry<Map<String, Long>, Long> entry : orgDepreUseId2TypeIdMap.entrySet()) {
                        Long depreUserId = entry.getKey().get("useId");
                        Long typeId = entry.getValue();
                        Long periodId2 = BusyChgCommUtils.getPeriodId(typeId, changeDate, typeIDDate2PeriodMap);
                        if (depreUserId == 0L && periodId2 == 0L) continue;
                        depreUserId2periodIdMap.put(depreUserId, periodId2);
                    }
                    continue;
                }
                Long depreUserId = entryData.getLong("depreuse1.id");
                for (Map.Entry<Map<String, Long>, Long> entry : orgDepreUseId2TypeIdMap.entrySet()) {
                    Long depreUserId2 = entry.getKey().get("useId");
                    if (depreUserId.longValue() != depreUserId2.longValue()) continue;
                    Long typeId = entry.getValue();
                    Long periodId3 = BusyChgCommUtils.getPeriodId(typeId, changeDate, typeIDDate2PeriodMap);
                    if (depreUserId == 0L && periodId3 == 0L) continue block16;
                    depreUserId2periodIdMap.put(depreUserId, periodId3);
                    continue block16;
                }
                continue;
            }
            if (entityName.equals("fa_clearbill")) {
                Long depreUserId = entryData.getLong("depreuse.id");
                periodId = bill.getLong("clearperiod.id");
                if (depreUserId == 0L && periodId == 0L) continue;
                depreUserId2periodIdMap.put(depreUserId, periodId);
                continue;
            }
            if (entityName.equals("fa_asset_devalue")) {
                Long depreUserId = bill.getLong("depreuse.id");
                periodId = bill.getLong("devalueperiod.id");
                if (depreUserId == 0L && periodId == 0L) continue;
                depreUserId2periodIdMap.put(depreUserId, periodId);
                continue;
            }
            if (entityName.equals("fa_assetsplitbill")) {
                Long depreUserId = entryData.getLong("bef_fincard.depreuse.id");
                periodId = bill.getLong("splitperiod.id");
                if (depreUserId == 0L && periodId == 0L) continue;
                depreUserId2periodIdMap.put(depreUserId, periodId);
                continue;
            }
            if (entityName.equals("fa_mergebill")) {
                Long depreUserId = entryData.getLong("indepreuse.id");
                periodId = bill.getLong("mergeperiod.id");
                if (depreUserId == 0L && periodId == 0L) continue;
                depreUserId2periodIdMap.put(depreUserId, periodId);
                continue;
            }
            if (!entityName.equals("fa_restartrealbill")) continue;
            long depreUserId = entryData.getLong("entitydepreuse.id");
            long periodId4 = bill.getLong("restartperiod_id");
            if (depreUserId == 0L && periodId4 == 0L) continue;
            depreUserId2periodIdMap.put(depreUserId, periodId4);
        }
        return masterId2depreUseId2PeriodIdMap;
    }

    public static Map<Long, Map<Long, Long>> getSpecialBillMasterId2depreUseId2PeriodId(DynamicObject bill, String entityName, Map<Map<String, Long>, Long> orgDepreUseId2TypeIdMap, Map<String, DynamicObject> typeIDDate2PeriodMap) {
        String entryName = AbstractBusyRecordServicePlugin.entity2Entry4BusyChgRecordSpecilBillMap.get(entityName);
        DynamicObjectCollection entryDataList = bill.getDynamicObjectCollection(entryName);
        HashMap<Long, Map<Long, Long>> masterId2depreUseId2PeriodIdMap = new HashMap<Long, Map<Long, Long>>(entryDataList.size() * 3);
        for (DynamicObject entryData : entryDataList) {
            Long masterId = 0L;
            switch (entityName) {
                case "fa_depreadjustbill": {
                    masterId = entryData.getLong("realcard.masterid");
                    break;
                }
                case "fa_dispatch": {
                    masterId = entryData.getLong("realcard.masterid");
                }
            }
            if (masterId == 0L) continue;
            HashMap<Long, Long> depreUserId2periodIdMap = (HashMap<Long, Long>)masterId2depreUseId2PeriodIdMap.get(masterId);
            if (depreUserId2periodIdMap == null) {
                depreUserId2periodIdMap = new HashMap<Long, Long>(3, 1.0f);
                masterId2depreUseId2PeriodIdMap.put(masterId, depreUserId2periodIdMap);
            }
            if (entityName.equals("fa_dispatch")) {
                Date dispatchDate = bill.getDate("dispatchdate");
                for (Map.Entry<Map<String, Long>, Long> entry : orgDepreUseId2TypeIdMap.entrySet()) {
                    Long depreUserId = entry.getKey().get("useId");
                    Long typeId = entry.getValue();
                    Long periodId = BusyChgCommUtils.getPeriodId(typeId, dispatchDate, typeIDDate2PeriodMap);
                    if (depreUserId == 0L && periodId == 0L) continue;
                    depreUserId2periodIdMap.put(depreUserId, periodId);
                }
                continue;
            }
            if (!entityName.equals("fa_depreadjustbill")) continue;
            Long depreUserId = bill.getLong("depreuse.id");
            Long periodId = bill.getLong("period.id");
            if (depreUserId == 0L && periodId == 0L) continue;
            depreUserId2periodIdMap.put(depreUserId, periodId);
        }
        return masterId2depreUseId2PeriodIdMap;
    }
}

