/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.busyrecord.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.busyrecord.FaPeriodBusyChgKey;
import kd.fi.fa.business.busyrecord.utils.BusyChgCommUtils;

public class PeriodBusyChgUtils {
    public static void genPeriodBusyChgRecord(String entityName, DynamicObject[] bills) {
        if (bills == null || bills.length == 0) {
            return;
        }
        Map<FaPeriodBusyChgKey, Set<Long>> periodBusyChgMap = PeriodBusyChgUtils.bills2Map(entityName, bills);
        for (Map.Entry<FaPeriodBusyChgKey, Set<Long>> entry : periodBusyChgMap.entrySet()) {
            FaPeriodBusyChgKey entryKey = entry.getKey();
            Set<Long> entryValue = entry.getValue();
            if (entryValue == null || entryValue.size() == 0) continue;
            Set<Long> extstedMasterIdSet = PeriodBusyChgUtils.getExistedPeriodBusyChg(entryKey.getOrgId(), entryKey.getDepreuseId(), entryKey.getPeriodId(), entryValue);
            Set<Long> masterIds = entry.getValue();
            masterIds.removeAll(extstedMasterIdSet);
        }
        ArrayList<DynamicObject> periodBusyChgList = new ArrayList<DynamicObject>();
        for (Map.Entry<FaPeriodBusyChgKey, Set<Long>> entry : periodBusyChgMap.entrySet()) {
            Set<Long> value = entry.getValue();
            if (value.size() == 0) continue;
            FaPeriodBusyChgKey key = entry.getKey();
            MainEntityType periodBusyChgType = EntityMetadataCache.getDataEntityType((String)"fa_period_busy_chg");
            for (Long masterId : value) {
                DynamicObject periodBusyChgDy = new DynamicObject((DynamicObjectType)periodBusyChgType);
                periodBusyChgDy.set("org", (Object)key.getOrgId());
                periodBusyChgDy.set("depreuse", (Object)key.getDepreuseId());
                periodBusyChgDy.set("period", (Object)key.getPeriodId());
                periodBusyChgDy.set("realcardmasterid", (Object)masterId);
                periodBusyChgList.add(periodBusyChgDy);
            }
        }
        if (periodBusyChgList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])periodBusyChgList.toArray(new DynamicObject[1]));
        }
    }

    private static Set<Long> getExistedPeriodBusyChg(Long orgId, Long depreUseId, Long periodId, Set<Long> masterIdsPa) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("period", "=", (Object)periodId), new QFilter("realcardmasterid", "in", masterIdsPa)};
        DynamicObjectCollection busyChgList = QueryServiceHelper.query((String)"fa_period_busy_chg", (String)"realcardmasterid", (QFilter[])filters);
        HashSet<Long> masterIds = new HashSet<Long>(busyChgList.size());
        busyChgList.stream().mapToLong(dy -> dy.getLong("realcardmasterid")).forEach(masterIds::add);
        return masterIds;
    }

    private static Map<FaPeriodBusyChgKey, Set<Long>> bills2Map(String entityName, DynamicObject[] bills) {
        HashMap<FaPeriodBusyChgKey, Set<Long>> periodBusyChgMap = new HashMap<FaPeriodBusyChgKey, Set<Long>>(8);
        HashMap<String, DynamicObject> typeIDDate2PeriodMap = new HashMap<String, DynamicObject>(bills.length);
        Map<Map<String, Long>, Long> orgDepreUseId2TypeIdMap = BusyChgCommUtils.getOrgDepreUseId2TypeIdMap(entityName, bills);
        for (DynamicObject bill : bills) {
            Long orgId = bill.getLong("org.id");
            Map<Long, Map<Long, Long>> masterId2depreUseId2PeriodIdMap = BusyChgCommUtils.getCommMasterId2depreUseId2PeriodId(bill, entityName, orgDepreUseId2TypeIdMap, typeIDDate2PeriodMap);
            if (masterId2depreUseId2PeriodIdMap.size() == 0) continue;
            for (Map.Entry<Long, Map<Long, Long>> entry : masterId2depreUseId2PeriodIdMap.entrySet()) {
                Long masterId = entry.getKey();
                if (masterId == 0L) continue;
                Map<Long, Long> entryValue = entry.getValue();
                for (Map.Entry<Long, Long> depreuseId2periodId : entryValue.entrySet()) {
                    FaPeriodBusyChgKey periodBusyChgKey = new FaPeriodBusyChgKey();
                    periodBusyChgKey.setOrgId(orgId);
                    periodBusyChgKey.setDepreuseId(depreuseId2periodId.getKey());
                    periodBusyChgKey.setPeriodId(depreuseId2periodId.getValue());
                    HashSet<Long> periodBusyChgValue = (HashSet<Long>)periodBusyChgMap.get(periodBusyChgKey);
                    if (periodBusyChgValue == null) {
                        periodBusyChgValue = new HashSet<Long>(masterId2depreUseId2PeriodIdMap.size());
                        periodBusyChgMap.put(periodBusyChgKey, periodBusyChgValue);
                    }
                    periodBusyChgValue.add(masterId);
                }
            }
        }
        return periodBusyChgMap;
    }
}

