/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.calc;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fa.business.calc.IObjWrapper;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.utils.AssetPolicyUtil;

public class FinCardCalc {
    public static BigDecimal setNetWorth(IObjWrapper objWrapper) {
        Object obj1 = objWrapper.getValue("originalval");
        Object obj2 = objWrapper.getValue("accumdepre");
        BigDecimal result = null;
        if (null != obj2 && null != obj1) {
            result = ((BigDecimal)obj1).subtract((BigDecimal)obj2);
            objWrapper.setValue("networth", result.toString());
        }
        return result;
    }

    public static BigDecimal setPreResidualVal(IObjWrapper objWrapper, boolean isNeeQuery, DynamicObject currency) {
        int currencyAmtprecision;
        BigDecimal result = null;
        DynamicObject dynObj = objWrapper.getDynamicObject();
        BigDecimal originalVal = dynObj.getBigDecimal("originalval");
        BigDecimal netResidualValRate = dynObj.getBigDecimal("netresidualvalrate");
        if (netResidualValRate == null || BigDecimal.ZERO.equals(netResidualValRate)) {
            netResidualValRate = FinCardCalc.getNetResidualValRate(dynObj, isNeeQuery);
        }
        int n = currencyAmtprecision = currency == null ? 2 : currency.getInt("amtprecision");
        if (netResidualValRate != null && null != originalVal) {
            result = originalVal.multiply(netResidualValRate).divide(new BigDecimal(100), 4);
            result = result.setScale(currencyAmtprecision, RoundingMode.HALF_UP);
            objWrapper.setValue("preresidualval", result.toString());
        }
        return result;
    }

    public static BigDecimal getPreResidualVal(DynamicObject assetBook, DynamicObject assetCat, DynamicObject currency, BigDecimal originalVal) {
        BigDecimal result = null;
        if (currency == null) {
            return null;
        }
        BigDecimal netResidualValRate = FinCardCalc.getNetResidualValRate(assetBook, assetCat);
        int currencyAmtprecision = currency.getInt("amtprecision");
        if (netResidualValRate != null && null != originalVal) {
            result = originalVal.multiply(netResidualValRate).divide(new BigDecimal(100), 4);
            result = result.setScale(currencyAmtprecision, RoundingMode.HALF_UP);
        }
        return result;
    }

    public static BigDecimal getNetResidualValRate(DynamicObject dynObj, boolean isNeedQuery) {
        DynamicObject assetBookDO = dynObj.getDynamicObject("assetbook");
        DynamicObject assetCatDO = dynObj.getDynamicObject("assetcat");
        if (assetCatDO == null) {
            return BigDecimal.ZERO;
        }
        DynamicObject assetPolicy = AssetPolicyUtil.getByBookAndCat(assetBookDO.getPkValue(), assetCatDO.getPkValue());
        return assetPolicy == null ? null : assetPolicy.getBigDecimal("netresidualvalrate");
    }

    public static BigDecimal getNetResidualValRate(DynamicObject assetBook, DynamicObject assetCat) {
        if (assetBook == null || assetCat == null) {
            return BigDecimal.ZERO;
        }
        DynamicObject assetPolicy = AssetPolicyUtil.getByBookAndCat(assetBook.getPkValue(), assetCat.getPkValue());
        return assetPolicy == null ? null : assetPolicy.getBigDecimal("netresidualvalrate");
    }

    public static BigDecimal getNetResidualValRate(DynamicObject finObj, Map<String, String> longnumberMap, Map<String, String> bookIdAndassetPolicyIdCache, Map<String, DynamicObjectCollection> depresystemCache) {
        DynamicObject assetBookDO = finObj.getDynamicObject("assetbook");
        DynamicObject assetCatDO = finObj.getDynamicObject("assetcat");
        if (assetCatDO == null) {
            return BigDecimal.ZERO;
        }
        String cateLongNumber = longnumberMap.get(assetCatDO.getString("id"));
        if (cateLongNumber == null) {
            return BigDecimal.ZERO;
        }
        String policyId = bookIdAndassetPolicyIdCache.get(String.valueOf(assetBookDO.getPkValue()));
        DynamicObjectCollection entrysDOC = depresystemCache.get(policyId);
        Optional<DynamicObject> entryOp = entrysDOC.stream().filter(v -> cateLongNumber.indexOf(v.getString("assetcat.longnumber")) == 0).reduce((u, v) -> {
            int len_v;
            int len_u = u.getString("assetcat.longnumber").length();
            return len_u > (len_v = v.getString("assetcat.longnumber").length()) ? u : v;
        });
        return entryOp.map(dynamicObject -> dynamicObject.getBigDecimal("netresidualvalrate")).orElse(null);
    }

    public static BigDecimal setNetAmount(IObjWrapper objWrapper) {
        Object obj1 = objWrapper.getValue("networth");
        Object obj2 = objWrapper.getValue("decval");
        BigDecimal result = null;
        if (null != obj2 && null != obj1) {
            result = ((BigDecimal)obj1).subtract((BigDecimal)obj2);
            objWrapper.setValue("netamount", result.toString());
        }
        return result;
    }

    public static boolean setCurrencyRate(IObjWrapper objWrapper) {
        DynamicObject dynObj = objWrapper.getDynamicObject();
        DynamicObject currency = dynObj.getDynamicObject("currency");
        DynamicObject assetBook = dynObj.getDynamicObject("assetbook");
        DynamicObject exchangetable = assetBook.getDynamicObject("exchangetable");
        DynamicObject baseCurrency = FaAssetBookDaoFactory.getInstance().queryCurrencyByBook(assetBook.getPkValue());
        boolean result = false;
        if (null != currency && null != baseCurrency) {
            if (currency.getString("number").equals(baseCurrency.getString("number"))) {
                objWrapper.setValue("currencyrate", new BigDecimal(1).toString());
                result = true;
            } else {
                Object exchangeRateValue = FinCardCalc.getExchangeRate(exchangetable, baseCurrency, currency, (Date)objWrapper.getValue("finaccountdate"));
                objWrapper.setValue("currencyrate", exchangeRateValue);
            }
        }
        return result;
    }

    private static Object getExchangeRate(DynamicObject exchangetable, DynamicObject destCurrency, DynamicObject srcCurrency, Date date) {
        Long sourceCurrencyID = (Long)srcCurrency.getPkValue();
        Long targetCurrencyID = (Long)destCurrency.getPkValue();
        Long exchangeTableID = (Long)exchangetable.getPkValue();
        return BaseDataServiceHelper.getExchangeRate((Long)exchangeTableID, (Long)sourceCurrencyID, (Long)targetCurrencyID, (Date)date);
    }

    public static BigDecimal setPurOriginalValue(IObjWrapper objWrapper) {
        Object obj1 = objWrapper.getValue("currencyrate");
        Object obj2 = objWrapper.getValue("originalamount");
        BigDecimal result = null;
        if (null != obj2 && null != obj1) {
            result = ((BigDecimal)obj1).multiply((BigDecimal)obj2);
            objWrapper.setValue("originalval", result.toString());
        }
        return result;
    }

    public static BigDecimal setOriginalVal(IObjWrapper objWrapper) {
        Object obj2 = objWrapper.getValue("puroriginalval");
        Object obj1 = objWrapper.getValue("originalval");
        BigDecimal result = null;
        if (null != obj2 && (obj1 == null || BigDecimal.ZERO.compareTo((BigDecimal)obj1) == 0)) {
            result = (BigDecimal)obj2;
            objWrapper.setValue("originalval", result.toString());
        }
        return result;
    }
}

