/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.cardgenerate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.cardgenerate.impl.AbstractFinCardGenerate;
import kd.fi.fa.business.cardgenerate.impl.AddCardToFinCardGenerate;
import kd.fi.fa.business.cardgenerate.impl.AssetCardToFinCardGenerate;
import kd.fi.fa.business.cardgenerate.impl.DispatchToFinCardGenerate;
import kd.fi.fa.business.cardgenerate.impl.DispatchToRealCardGenerate;
import kd.fi.fa.business.cardgenerate.impl.EngineeringToFinCardGenerate;
import kd.fi.fa.business.cardgenerate.impl.InitLeaseContractToFinCardGenerate;
import kd.fi.fa.business.cardgenerate.impl.InventoryProfitToFinCardGenerate;
import kd.fi.fa.business.cardgenerate.impl.LeaseContractToFinCardGenerate;
import kd.fi.fa.business.cardgenerate.impl.PurchaseToFinCardGenerate;
import kd.fi.fa.business.errorcode.FinCardErrorCode;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;

public class CardGenerateHelper {
    public static final Object[] generateRealCard(DynamicObject srcBill) {
        DispatchToRealCardGenerate generate = null;
        DynamicObjectType dt = srcBill.getDynamicObjectType();
        if (!"fa_dispatch_in".equals(dt.getName()) && !"fa_dispatch".equals(dt.getName())) {
            throw new KDBizException(FinCardErrorCode.FINCARD_GENERATE_ERROR, new Object[0]);
        }
        generate = new DispatchToRealCardGenerate(srcBill.getPkValue());
        return generate.generateRealCard();
    }

    public static void generateFinCard(List<DynamicObject> objects) {
        MainEntityType finCardType = EntityMetadataCache.getDataEntityType((String)"fa_card_fin");
        DynamicObjectType billHeadType = ((EntryProp)finCardType.getProperty("billhead_lk")).getDynamicCollectionItemPropertyType();
        Long realCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_real", (String)"fa_card_real").getTableId();
        AbstractFinCardGenerate generate = null;
        ArrayList<DynamicObject> dynamicAdd = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> dynamicPurchase = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> dynamicDispatch = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> dynamicInventory = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> dynamicEnginner = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> dynamicLease = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> dynamicInitLease = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> callbackFincards = new ArrayList<DynamicObject>();
        Map<Object, DynamicObject[]> orgAssetBooksMap = CardGenerateHelper.getAssetBooksByOrg(objects);
        for (DynamicObject dynamicObject : objects) {
            long realCardId = dynamicObject.getLong("id");
            Object sourceFlag = dynamicObject.get("sourceflag");
            boolean justrealcard = dynamicObject.getBoolean("justrealcard");
            if (justrealcard) {
                dynamicObject.set("bizstatus", (Object)"READY");
                continue;
            }
            if (FaCommonUtils.equals(SourceFlagEnum.ADD, sourceFlag) || FaCommonUtils.equals(SourceFlagEnum.IMPORT, sourceFlag) || FaCommonUtils.equals(SourceFlagEnum.INITIAL, sourceFlag) || FaCommonUtils.equals(SourceFlagEnum.INVENTORYPROFIT, sourceFlag) || FaCommonUtils.equals(SourceFlagEnum.DATAASSET, sourceFlag) || FaCommonUtils.equals(SourceFlagEnum.SCAN, sourceFlag)) {
                dynamicAdd.add(dynamicObject);
                continue;
            }
            if (FaCommonUtils.equals(SourceFlagEnum.PURCHASE, sourceFlag)) {
                dynamicPurchase.add(dynamicObject);
                continue;
            }
            if (FaCommonUtils.equals(SourceFlagEnum.DISPATCH, sourceFlag)) {
                dynamicDispatch.add(dynamicObject);
                continue;
            }
            if (FaCommonUtils.equals(SourceFlagEnum.INVENTORYPROFIT, sourceFlag)) {
                dynamicInventory.add(dynamicObject);
                continue;
            }
            if (FaCommonUtils.equals(SourceFlagEnum.ENGINEERINGTRANS, sourceFlag)) {
                dynamicEnginner.add(dynamicObject);
                continue;
            }
            if (FaCommonUtils.equals(SourceFlagEnum.LEASECONTRACT, sourceFlag)) {
                dynamicLease.add(dynamicObject);
                continue;
            }
            if (FaCommonUtils.equals(SourceFlagEnum.INITLEASECONTRACT, sourceFlag)) {
                dynamicInitLease.add(dynamicObject);
                continue;
            }
            throw new KDBizException(FinCardErrorCode.FINCARD_GENERATE_ERROR, new Object[0]);
        }
        HashMap<Object, Object> finCardAndrealCard = new HashMap<Object, Object>();
        if (CollectionUtils.isNotEmpty(dynamicAdd)) {
            generate = new AddCardToFinCardGenerate();
            callbackFincards.addAll(generate.generateDynamicFinCard(dynamicAdd, orgAssetBooksMap, finCardType, billHeadType, realCardTableId, finCardAndrealCard));
        }
        if (CollectionUtils.isNotEmpty(dynamicPurchase)) {
            generate = new PurchaseToFinCardGenerate();
            callbackFincards.addAll(generate.generateDynamicFinCard(dynamicPurchase, orgAssetBooksMap, finCardType, billHeadType, realCardTableId, finCardAndrealCard));
        }
        if (CollectionUtils.isNotEmpty(dynamicDispatch)) {
            generate = new DispatchToFinCardGenerate();
            callbackFincards.addAll(generate.generateDynamicFinCard(dynamicDispatch, orgAssetBooksMap, finCardType, billHeadType, realCardTableId, finCardAndrealCard));
        }
        if (CollectionUtils.isNotEmpty(dynamicInventory)) {
            generate = new InventoryProfitToFinCardGenerate();
            callbackFincards.addAll(generate.generateDynamicFinCard(dynamicInventory, orgAssetBooksMap, finCardType, billHeadType, realCardTableId, finCardAndrealCard));
        }
        if (CollectionUtils.isNotEmpty(dynamicEnginner)) {
            generate = new EngineeringToFinCardGenerate();
            callbackFincards.addAll(generate.generateDynamicFinCard(dynamicEnginner, orgAssetBooksMap, finCardType, billHeadType, realCardTableId, finCardAndrealCard));
        }
        if (CollectionUtils.isNotEmpty(dynamicLease)) {
            generate = new LeaseContractToFinCardGenerate();
            callbackFincards.addAll(generate.generateDynamicFinCard(dynamicLease, orgAssetBooksMap, finCardType, billHeadType, realCardTableId, finCardAndrealCard));
        }
        if (CollectionUtils.isNotEmpty(dynamicInitLease)) {
            generate = new InitLeaseContractToFinCardGenerate();
            callbackFincards.addAll(generate.generateDynamicFinCard(dynamicInitLease, orgAssetBooksMap, finCardType, billHeadType, realCardTableId, finCardAndrealCard));
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("genfincard", "true");
        operateOption.setVariableValue("ignore_validate_initial_fincard", "true");
        operateOption.setVariableValue("ignoreAssetBookStatus", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"fa_card_fin", (DynamicObject[])callbackFincards.toArray(new DynamicObject[0]), (OperateOption)operateOption);
        if (!result.isSuccess()) {
            List allError = result.getAllErrorOrValidateInfo();
            result.getAllErrorInfo();
            StringBuilder errorInfo = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)allError)) {
                for (IOperateInfo in : allError) {
                    errorInfo.append(in.getMessage());
                }
            }
            String msg = new LocaleString(String.format("%s%s-%s", ResManager.loadKDString((String)"\u751f\u6210\u8d22\u52a1\u5361\u7247\u5931\u8d25,\u5ba1\u6838\u4e8b\u52a1\u5931\u8d25", (String)"CardGenerateHelper_0", (String)"fi-fa-business", (Object[])new Object[0]), result.getMessage(), errorInfo.toString())).toString();
            throw new KDBizException(msg);
        }
    }

    public static Map<Long, Map<Long, DynamicObject>> generateFinCardForAssetCard(List<DynamicObject> realCardList, String entityName) {
        String finEntityName = "";
        if (entityName.equals("fa_asset_card")) {
            finEntityName = "fa_card_fin";
        }
        if (entityName.equals("fa_asset_initcard")) {
            finEntityName = "fa_initcard_fin";
        }
        MainEntityType finCardType = EntityMetadataCache.getDataEntityType((String)finEntityName);
        DynamicObjectType billHeadType = ((EntryProp)finCardType.getProperty("billhead_lk")).getDynamicCollectionItemPropertyType();
        Long realCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_real", (String)"fa_card_real").getTableId();
        Map<Object, DynamicObject[]> orgAssetBookMap = CardGenerateHelper.getAssetBooksByOrg(realCardList);
        HashMap<Object, Object> finCardAndrealCard = new HashMap<Object, Object>(realCardList.size());
        AssetCardToFinCardGenerate generate = new AssetCardToFinCardGenerate();
        List<DynamicObject> finCardList = generate.generateDynamicFinCard(realCardList, orgAssetBookMap, finCardType, billHeadType, realCardTableId, finCardAndrealCard);
        HashMap<Long, Map<Long, DynamicObject>> finCardMap = new HashMap<Long, Map<Long, DynamicObject>>(finCardList.size());
        for (DynamicObject finCard : finCardList) {
            long fid = DBServiceHelper.genGlobalLongId();
            finCard.set("id", (Object)fid);
            long realCardId = finCard.getLong(Fa.id((String)"realcard"));
            long depreUseId = finCard.getLong(Fa.id((String)"depreuse"));
            Map depreUseCardMap = finCardMap.computeIfAbsent(realCardId, v -> new HashMap(4));
            depreUseCardMap.put(depreUseId, finCard);
            finCard.getDynamicObjectCollection("billhead_lk").clear();
        }
        return finCardMap;
    }

    private static Map<Object, DynamicObject[]> getAssetBooksByOrg(List<DynamicObject> realCards) {
        HashSet<Long> orgIds = new HashSet<Long>(4);
        HashSet<Long> realCardIds = new HashSet<Long>(FaUtils.getInitialCapacity43(realCards.size()));
        for (DynamicObject realCard : realCards) {
            orgIds.add(realCard.getLong(Fa.id((String)"org")));
            realCardIds.add(realCard.getLong("id"));
        }
        QFilter filters = new QFilter("org", "in", orgIds);
        String sic = Fa.join((String)",", (String[])new String[]{"id", "depreuse", "org", "ismainbook", "basecurrency", "periodtype", "depresystem", "curperiod", "isgroupbook", "exchangetable", "status", "startperiod"});
        Map assetBook4Load = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)sic, (QFilter[])new QFilter[]{filters});
        HashMap<Long, Set> org2AssetBooks = new HashMap<Long, Set>(FaUtils.getInitialCapacity43(orgIds.size()));
        for (DynamicObject assetBook : assetBook4Load.values()) {
            long orgId = assetBook.getLong(Fa.id((String)"org"));
            Set assetBooks = org2AssetBooks.computeIfAbsent(orgId, k -> new HashSet(4));
            assetBooks.add(assetBook);
        }
        DataSet finCards = QueryServiceHelper.queryDataSet((String)"getAssetBooksByOrg.realCardsQueryFinCards", (String)"fa_card_fin", (String)Fa.comma((String[])new String[]{"realcard", "assetbook"}), (QFilter[])new QFilter[]{new QFilter("realcard", "in", realCardIds), new QFilter("endperiod", "=", (Object)99999999999L)}, null);
        HashMap<Long, Set> realCardId2AssetBookIds = new HashMap<Long, Set>(realCards.size());
        while (finCards.hasNext()) {
            Row next = finCards.next();
            long realCardId = next.getLong("realcard");
            Set assetBookIds = realCardId2AssetBookIds.computeIfAbsent(realCardId, v -> new HashSet(4));
            assetBookIds.add(next.getLong("assetbook"));
        }
        HashMap<Object, DynamicObject[]> realCardId2AssetBooks = new HashMap<Object, DynamicObject[]>(FaUtils.getInitialCapacity43(realCards.size()));
        block3: for (DynamicObject realCard : realCards) {
            long orgId = realCard.getLong(Fa.id((String)"org"));
            long realCardId = realCard.getLong("id");
            boolean isFromLease = SourceFlagEnum.INITLEASECONTRACT.name().equals(realCard.getString("sourceflag")) || SourceFlagEnum.LEASECONTRACT.name().equals(realCard.getString("sourceflag"));
            Set assetBookIds = (Set)realCardId2AssetBookIds.get(realCardId);
            Set assetBooks = (Set)org2AssetBooks.get(orgId);
            if (assetBooks == null) continue;
            if (assetBookIds == null) {
                if (isFromLease) {
                    for (DynamicObject assetBook : assetBooks) {
                        if (!assetBook.getBoolean("ismainbook")) continue;
                        realCardId2AssetBooks.put(realCardId, new DynamicObject[]{assetBook});
                        continue block3;
                    }
                    continue;
                }
                realCardId2AssetBooks.put(realCardId, assetBooks.toArray(new DynamicObject[0]));
                continue;
            }
            HashSet<DynamicObject> books = new HashSet<DynamicObject>(FaUtils.getInitialCapacity43(assetBooks.size()));
            for (DynamicObject assetBook : assetBooks) {
                boolean mainBook = assetBook.getBoolean("ismainbook");
                long assetBookId = assetBook.getLong("id");
                if (assetBookIds.contains(assetBookId)) continue;
                if (isFromLease) {
                    if (!mainBook) continue;
                    books.add(assetBook);
                    break;
                }
                books.add(assetBook);
            }
            realCardId2AssetBooks.put(realCardId, books.toArray(new DynamicObject[0]));
        }
        return realCardId2AssetBooks;
    }
}

